/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.smapifier.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.smapi.Main;
import org.eclipse.imp.smapifier.SmapiePlugin;
import org.eclipse.imp.utils.BreakpointUtils;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmapieBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.imp.smapifier.SmapieBuilder";
    private IProject fProject;
    private String fPathPrefix;
    private final DeltaVisitor fDeltaVisitor = new DeltaVisitor();
    private final ResourceVisitor fResourceVisitor = new ResourceVisitor();
    private IProgressMonitor fMonitor;
    private String fFileExten = "x10";

    public String getOrigExten() {
        return this.fFileExten;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta;
        this.fProject = this.getProject();
        this.fMonitor = monitor;
        this.fPathPrefix = this.fProject.getWorkspace().getRoot().getRawLocation() + this.fProject.getFullPath().toString();
        if (args.get("exten") != null) {
            this.fFileExten = (String)args.get("exten");
        }
        if (Main.debug) {
            System.out.println("Inside SMAP builder");
        }
        if ((delta = this.getDelta(this.fProject)) != null) {
            SmapiePlugin.getDefault().maybeWriteInfoMsg("==> Smapi Scanning resource delta for project '" + this.fProject.getName() + "'... <==");
            delta.accept((IResourceDeltaVisitor)this.fDeltaVisitor);
            if (SmapiePlugin.getDefault() != null) {
                SmapiePlugin.getDefault().maybeWriteInfoMsg("Smapi delta scan completed for project '" + this.fProject.getName() + "'...");
            }
        } else {
            SmapiePlugin.getDefault().maybeWriteInfoMsg("==> Smapi Scanning for '." + this.fFileExten + "' source files in project '" + this.fProject.getName() + "'... <==");
            this.fProject.accept((IResourceVisitor)this.fResourceVisitor);
            if (SmapiePlugin.getDefault() != null) {
                SmapiePlugin.getDefault().maybeWriteInfoMsg("Smapi source file scan completed for project '" + this.fProject.getName() + "'...");
            }
        }
        IProject[] ret = new IProject[]{this.fProject};
        if (Main.debug) {
            System.out.println("Leaving SMAP builder");
        }
        this.refresh();
        return ret;
    }

    protected boolean processResource(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (!this.isSourceFile(file)) {
                return false;
            }
            String filename = file.getRawLocation().toString();
            Set classFiles = this.getClassFiles(file);
            BreakpointUtils.resetJavaBreakpoints((IFile)file);
            for (IFile classFile : classFiles) {
                Main.smapify((String)filename, (String)this.fPathPrefix, (String)classFile.getRawLocation().toString());
            }
        }
        return true;
    }

    private boolean isSourceFile(IFile file) {
        String fileExten = file.getFileExtension();
        return fileExten != null && fileExten.equals(this.fFileExten);
    }

    private Set getClassFiles(IFile file) {
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        IPath parentPath = file.getParent().getFullPath();
        HashSet<IResource> ret = new HashSet<IResource>();
        try {
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 3 && file.getFullPath().matchingFirstSegments(entries[i].getPath()) == entries[i].getPath().segmentCount()) {
                    IPath parentSrcPath;
                    IPath parentFullPath;
                    IResource parent;
                    IPath out = entries[i].getOutputLocation();
                    if (out == null) {
                        out = javaProject.getOutputLocation().removeFirstSegments(1);
                    }
                    if ((parent = this.fProject.findMember(parentFullPath = out.append(parentSrcPath = parentPath.removeFirstSegments(entries[i].getPath().segmentCount())))) != null) {
                        IResource[] members = ((IContainer)parent).members();
                        int j = 0;
                        while (j < members.length) {
                            String name = members[j].getName();
                            if (this.classBelongsTo(file, name)) {
                                ret.add(members[j]);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            System.err.println((Object)e);
        }
        catch (CoreException e) {
            System.err.println((Object)e);
        }
        return ret;
    }

    private boolean classBelongsTo(IFile file, String name) {
        if (!name.endsWith(".class")) {
            return false;
        }
        name = name.substring(0, name.indexOf("."));
        String fileName = file.getFullPath().removeFileExtension().lastSegment();
        if (fileName.equals(name)) {
            return true;
        }
        return name.startsWith(fileName) && name.indexOf("$") == fileName.length();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBinaryFolder(IResource resource) {
        try {
            boolean projectIsSrcBin;
            IPath projPath = this.fProject.getFullPath();
            IJavaProject javaProj = JavaCore.create((IProject)this.fProject);
            if (javaProj.getOutputLocation().matchingFirstSegments(projPath) == projPath.segmentCount()) {
                return false;
            }
            boolean bl = projectIsSrcBin = false;
            if (projectIsSrcBin) {
                return false;
            }
            IPath resourcePath = resource.getFullPath();
            if (resourcePath.equals((Object)javaProj.getOutputLocation())) {
                return true;
            }
            IClasspathEntry[] cp = javaProj.getResolvedClasspath(true);
            int i = 0;
            while (true) {
                if (i >= cp.length) {
                    return false;
                }
                if (cp[i].getEntryKind() == 3 && resourcePath.equals((Object)cp[i].getOutputLocation())) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            System.err.println((Object)e);
        }
        return false;
    }

    private void refresh() throws CoreException {
        List<IPath> projectSrcPath = this.getProjectSrcPath();
        for (IPath pathEntry : projectSrcPath) {
            if (pathEntry.segmentCount() == 1) {
                this.fProject.refreshLocal(2, this.fMonitor);
                continue;
            }
            this.fProject.getWorkspace().getRoot().getFolder(pathEntry).refreshLocal(2, this.fMonitor);
        }
    }

    private List<IPath> getProjectSrcPath() throws JavaModelException {
        ArrayList<IPath> srcPath = new ArrayList<IPath>();
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        IClasspathEntry[] classPath = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < classPath.length) {
            IClasspathEntry e = classPath[i];
            if (e.getEntryKind() == 3) {
                srcPath.add(e.getPath());
            }
            ++i;
        }
        if (srcPath.size() == 0) {
            srcPath.add(this.fProject.getLocation());
        }
        return srcPath;
    }

    private final class DeltaVisitor
    implements IResourceDeltaVisitor {
        private DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getKind() == 2) {
                return false;
            }
            return SmapieBuilder.this.processResource(delta.getResource());
        }
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private ResourceVisitor() {
        }

        public boolean visit(IResource res) throws CoreException {
            return SmapieBuilder.this.processResource(res);
        }
    }
}

