/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.launching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.atl.adt.debug.Messages;
import org.eclipse.m2m.atl.adt.launching.AtlLauncherTools;
import org.eclipse.m2m.atl.adt.launching.AtlVM;
import org.eclipse.m2m.atl.adt.launching.MainAtlTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AdvancedTab
extends AbstractLaunchConfigurationTab
implements ModifyListener,
SelectionListener {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    static final String SUPERIMPOSE = "SUPERIMPOSE";
    private Composite container;
    private Group groupSuperimpose;
    private Table tableSuperimpose;
    private Button buttonSuperimpose;
    private Button buttonRemoveSuperimpose;
    private Group groupOthersInformation;
    private Button buttonModeDebug;
    private Button buttonAllowInterModelReferences;
    private Combo atlVMs;
    private Map buttonArray = new HashMap();

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.groupSuperimpose = new Group(this.container, 0);
        this.buttonSuperimpose = new Button((Composite)this.groupSuperimpose, 0x1000000);
        this.tableSuperimpose = new Table((Composite)this.groupSuperimpose, 67584);
        this.buttonRemoveSuperimpose = new Button((Composite)this.groupSuperimpose, 0x1000000);
        this.groupOthersInformation = new Group(this.container, 0);
        this.buttonModeDebug = new Button((Composite)this.groupOthersInformation, 32);
        this.buttonAllowInterModelReferences = new Button((Composite)this.groupOthersInformation, 32);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        GridData gd3 = new GridData(768);
        this.groupOthersInformation.setLayoutData((Object)gd3);
        this.container.setLayout((Layout)layout);
        this.groupSuperimpose.setLayoutData((Object)new GridData(1808));
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 4;
        groupLayout.makeColumnsEqualWidth = true;
        this.groupSuperimpose.setLayout((Layout)groupLayout);
        this.groupSuperimpose.setText(Messages.getString("AdvancedTab.SUPERIMPOSE"));
        this.buttonSuperimpose.setText(Messages.getString("AdvancedTab.ADD"));
        this.buttonSuperimpose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AdvancedTab.this.addPath(AdvancedTab.SUPERIMPOSE, AdvancedTab.this.tableSuperimpose);
                AdvancedTab.this.canSave();
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.buttonRemoveSuperimpose.setText(Messages.getString("AdvancedTab.REMOVE"));
        this.buttonRemoveSuperimpose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AdvancedTab.this.removePath(AdvancedTab.this.tableSuperimpose);
                AdvancedTab.this.canSave();
                AdvancedTab.this.updateLaunchConfigurationDialog();
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.tableSuperimpose.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.tableSuperimpose.setLinesVisible(true);
        this.tableSuperimpose.setHeaderVisible(true);
        TableColumn superimposeName = new TableColumn(this.tableSuperimpose, 16384);
        superimposeName.setText(Messages.getString("AdvancedTab.SUPERIMPOSE"));
        this.buttonSuperimpose.setLayoutData((Object)new GridData(768));
        this.buttonRemoveSuperimpose.setLayoutData((Object)new GridData(770));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 3;
        this.tableSuperimpose.setLayoutData((Object)gd);
        this.groupOthersInformation.setText(Messages.getString("MainAtlTab.OTHERSPARAMETERS"));
        this.buttonAllowInterModelReferences.setLayoutData((Object)new GridData(1808));
        this.buttonAllowInterModelReferences.setText(Messages.getString("MainAtlTab.INTERMODELREFS"));
        this.buttonAllowInterModelReferences.addSelectionListener((SelectionListener)this);
        this.buttonModeDebug.setLayoutData((Object)new GridData(1808));
        this.buttonModeDebug.setText(Messages.getString("MainAtlTab.MODEDEBUG"));
        this.buttonModeDebug.addSelectionListener((SelectionListener)this);
        this.checkButtonFactory();
        Composite groupATLVMs = new Composite((Composite)this.groupOthersInformation, 32);
        Label atlVMLabel = new Label(groupATLVMs, 0);
        atlVMLabel.setText("ATL Virtual Machine: ");
        atlVMLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.atlVMs = new Combo(groupATLVMs, 8);
        this.atlVMs.setItems(AtlVM.getVMs());
        this.atlVMs.select(0);
        this.atlVMs.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.atlVMs.addModifyListener((ModifyListener)this);
        groupATLVMs.setLayout((Layout)new GridLayout(2, false));
        groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        groupLayout.makeColumnsEqualWidth = true;
        this.groupOthersInformation.setLayout((Layout)groupLayout);
        this.container.layout();
        this.container.pack();
        this.setControl((Control)this.container);
        this.canSave();
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
            int i = 0;
            while (i < tabs.length) {
                if (tabs[i] instanceof MainAtlTab) {
                    ((MainAtlTab)tabs[i]).superimposedChanged(this.createSuperimposedList());
                }
                ++i;
            }
        }
        super.updateLaunchConfigurationDialog();
    }

    private void checkButtonFactory() {
        int i = 0;
        while (i < AtlLauncherTools.additionalParamIds.length) {
            Button newCheckButton = new Button((Composite)this.groupOthersInformation, 32);
            newCheckButton.setLayoutData((Object)new GridData(1808));
            newCheckButton.setText(AtlLauncherTools.additionalParamLabels[i]);
            newCheckButton.addSelectionListener((SelectionListener)this);
            this.buttonArray.put(AtlLauncherTools.additionalParamIds[i], newCheckButton);
            ++i;
        }
    }

    public String getName() {
        return AtlLauncherTools.ADVANCEDTABNAME;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            List superimpose = configuration.getAttribute("Superimpose", new ArrayList());
            this.tableSuperimpose.removeAll();
            Iterator i = superimpose.iterator();
            while (i.hasNext()) {
                String mName = (String)i.next();
                TableItem item = new TableItem(this.tableSuperimpose, 0);
                item.setText(mName);
            }
            this.buttonModeDebug.setSelection(configuration.getAttribute("Mode Debug", false));
            this.buttonAllowInterModelReferences.setSelection(configuration.getAttribute("AllowInterModelReferences", false));
            int item = 0;
            while (item < this.atlVMs.getItems().length) {
                if (this.atlVMs.getItem(item).equals(configuration.getAttribute("ATL VM", ""))) {
                    this.atlVMs.select(item);
                }
                ++item;
            }
            Iterator it = this.buttonArray.keySet().iterator();
            while (it.hasNext()) {
                String currentButtonName = (String)it.next();
                Button currentButton = (Button)this.buttonArray.get(currentButtonName);
                currentButton.setSelection(configuration.getAttribute(currentButtonName, false));
            }
            this.canSave();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException e) {
            this.tableSuperimpose.removeAll();
            this.buttonModeDebug.setSelection(false);
            this.buttonAllowInterModelReferences.setSelection(true);
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private List createSuperimposedList() {
        ArrayList<String> superimpose = new ArrayList<String>();
        int i = 0;
        while (i < this.tableSuperimpose.getItemCount()) {
            TableItem ti = this.tableSuperimpose.getItem(i);
            superimpose.add(ti.getText());
            ++i;
        }
        return superimpose;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("Superimpose", this.createSuperimposedList());
        configuration.setAttribute("AllowInterModelReferences", this.buttonAllowInterModelReferences.getSelection());
        configuration.setAttribute("Mode Debug", this.buttonModeDebug.getSelection());
        configuration.setAttribute("ATL VM", this.atlVMs.getItem(this.atlVMs.getSelectionIndex()));
        Iterator it = this.buttonArray.keySet().iterator();
        while (it.hasNext()) {
            String currentButtonName = (String)it.next();
            Button currentButton = (Button)this.buttonArray.get(currentButtonName);
            configuration.setAttribute(currentButtonName, currentButton.getSelection());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean canSave() {
        if (this.tableSuperimpose.getItemCount() != 0) {
            int i = 0;
            while (i < this.tableSuperimpose.getItemCount()) {
                if (this.tableSuperimpose.getItem(i).getText().equals("")) {
                    this.setErrorMessage(Messages.getString("AdvancedTab.GIVEPATHSUPERIMPOSE"));
                    return false;
                }
                ++i;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public Image getImage() {
        return AtlLauncherTools.createImage("icons/atllogo_icon.gif");
    }

    private void addPath(final String type, Table table) {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        elementTreeSelectionDialog.setMessage(String.valueOf(Messages.getString("AdvancedTab.CHOOSE")) + type);
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setDoubleClickSelects(true);
        elementTreeSelectionDialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean ret = false;
                if (element instanceof IContainer) {
                    ret = true;
                } else if (element instanceof IFile) {
                    IFile currentFile = (IFile)element;
                    if (currentFile.getFileExtension() == null) {
                        return false;
                    }
                    ret = type == AdvancedTab.SUPERIMPOSE ? currentFile.getFileExtension().toUpperCase().equals("ASM") : true;
                }
                return ret;
            }
        });
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IStatus ret = Status.CANCEL_STATUS;
                if (selection.length == 1 && selection[0] instanceof IFile) {
                    ret = Status.OK_STATUS;
                }
                return ret;
            }
        });
        elementTreeSelectionDialog.open();
        Object result = elementTreeSelectionDialog.getFirstResult();
        if (result != null && result instanceof IFile) {
            IFile currentFile = (IFile)result;
            TableItem item = new TableItem(table, 0);
            item.setText(currentFile.getFullPath().toString());
        }
    }

    private void removePath(Table table) {
        int index = table.getSelectionIndex();
        if (index == -1) {
            AtlLauncherTools.messageBox(Messages.getString("AdvancedTab.CHOOSEENTRY"));
            return;
        }
        table.remove(index);
    }

    public void modifyText(ModifyEvent e) {
        this.canSave();
        this.updateLaunchConfigurationDialog();
    }

    public void widgetSelected(SelectionEvent e) {
        this.canSave();
        this.updateLaunchConfigurationDialog();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Table getTableSuperimpose() {
        return this.tableSuperimpose;
    }
}

