/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.outline;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.am3.tools.tge.editor.TextualGenericEditor;
import org.eclipse.am3.tools.tge.outline.Position;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.m2m.atl.engine.AtlNbCharFile;

public class DocumentOffsetCount {
    private Document doc;
    private TextualGenericEditor textEditor;
    private AtlNbCharFile currentAtlNbCharFile;

    public DocumentOffsetCount(TextualGenericEditor textEditor) {
        this.textEditor = textEditor;
        this.updateInput();
    }

    public void updateInput() {
        this.doc = new Document(this.textEditor.getDocumentProviderContent());
        this.currentAtlNbCharFile = new AtlNbCharFile(this.toInputStream(this.textEditor.getDocumentProviderContent()));
    }

    private InputStream toInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    public Position getPositionTab1(int line, int column) {
        if (line > this.doc.getNumberOfLines()) {
            return new Position();
        }
        try {
            int offset = this.doc.getLineOffset(line - 1);
            return new Position(line, column, offset += column - 1);
        }
        catch (BadLocationException badLocationException) {
            return new Position();
        }
    }

    public Position getPosition(int line, int column) {
        if (line > this.doc.getNumberOfLines()) {
            return new Position();
        }
        int offset = this.currentAtlNbCharFile.getIndex(String.valueOf(line) + ":" + column);
        return new Position(line, column, offset);
    }

    public Position[] getPositions(String sourceLocation) {
        this.currentAtlNbCharFile.getIndexChar(sourceLocation);
        Position[] ret = new Position[2];
        try {
            String[] ss = sourceLocation.split("-");
            String[] starts = ss[0].split(":");
            int startLine = Integer.parseInt(starts[0]);
            int startColumn = Integer.parseInt(starts[1]);
            String[] ends = ss[1].split(":");
            int endLine = Integer.parseInt(ends[0]);
            int endColumn = Integer.parseInt(ends[1]);
            ret[0] = this.getPositionTab1(startLine, startColumn);
            ret[1] = this.getPositionTab1(endLine, endColumn);
        }
        catch (Exception exception) {
            ret[0] = new Position();
            ret[1] = new Position();
        }
        return ret;
    }
}

