/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.profile.definition.LabelTypesEnum;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.NamedElement;

public class CustomizableDelegatingItemLabelProvider
implements IItemLabelProvider {
    public static String ST_LEFT = "\u00ab";
    public static String ST_RIGHT = "\u00bb";
    private static final Pattern UML2_LABEL_PATTERN = Pattern.compile("(?:<<(.+?)>>)?\\s*(<[^<>]+>)?\\s*(.*)");
    private static final String SEPARATOR_DASH = "-";
    private static final String SEPARATOR_COLON = ":";
    private final AdapterFactory itemAdapterFactory;
    private List<Map.Entry<String, StyledString.Styler>> stylesList = new ArrayList<Map.Entry<String, StyledString.Styler>>();

    public CustomizableDelegatingItemLabelProvider(AdapterFactory itemAdapterFactory, List<Map.Entry<String, StyledString.Styler>> stylesList) {
        this.itemAdapterFactory = itemAdapterFactory;
        this.stylesList = stylesList;
    }

    public CustomizableDelegatingItemLabelProvider(AdapterFactory itemAdapterFactory) {
        this(itemAdapterFactory, CustomizableDelegatingItemLabelProvider.getDefaultStyles());
    }

    public CustomizableDelegatingItemLabelProvider(List<String> labelTypes, List<StyledString.Styler> labelStyles) {
        this(Activator.getDefault().getItemProviderAdapterFactory(), CustomizableDelegatingItemLabelProvider.toStylesList(labelTypes, labelStyles));
    }

    public void setStylesList(List<Map.Entry<String, StyledString.Styler>> stylesList) {
        this.stylesList = stylesList;
    }

    public void setStylesList(List<String> labelTypes, List<StyledString.Styler> labelStyles) {
        this.stylesList = CustomizableDelegatingItemLabelProvider.toStylesList(labelTypes, labelStyles);
    }

    public List<Map.Entry<String, StyledString.Styler>> getStylesList() {
        return this.stylesList;
    }

    protected static List<Map.Entry<String, StyledString.Styler>> toStylesList(List<String> labelTypes, List<StyledString.Styler> labelStyles) {
        ArrayList<Map.Entry<String, StyledString.Styler>> list = new ArrayList<Map.Entry<String, StyledString.Styler>>();
        Iterator<StyledString.Styler> stylerIterator = labelStyles.iterator();
        for (String type : labelTypes) {
            StyledString.Styler styler = null;
            if (stylerIterator.hasNext()) {
                styler = stylerIterator.next();
            }
            list.add(new StyleEntry(type, styler));
        }
        return list;
    }

    public CustomizableDelegatingItemLabelProvider(List<Map.Entry<String, StyledString.Styler>> styleslist) {
        this(Activator.getDefault().getItemProviderAdapterFactory(), styleslist);
    }

    protected static List<Map.Entry<String, StyledString.Styler>> getDefaultStyles() {
        ArrayList<Map.Entry<String, StyledString.Styler>> styles = new ArrayList<Map.Entry<String, StyledString.Styler>>();
        styles.add(new StyleEntry(LabelTypesEnum.STEREOTYPE.getLiteral(), null));
        styles.add(new StyleEntry(LabelTypesEnum.LABEL.getLiteral(), null));
        return styles;
    }

    public CustomizableDelegatingItemLabelProvider() {
        this(Activator.getDefault().getItemProviderAdapterFactory());
    }

    public String getText(Object object) {
        return this.getStyledText(object).toString();
    }

    public StyledString getStyledText(Object object) {
        EObject element = EMFHelper.getEObject((Object)object);
        StyledString result = new StyledString();
        if (element != null) {
            LinkedList<Map.Entry<String, StyledString.Styler>> styles = new LinkedList<Map.Entry<String, StyledString.Styler>>(this.stylesList);
            while (!styles.isEmpty()) {
                Map.Entry<String, StyledString.Styler> stypeEntry = styles.pop();
                String type = stypeEntry.getKey();
                LabelTypesEnum typeEnum = LabelTypesEnum.getByLiteral(type);
                StyledString.Styler style = stypeEntry.getValue();
                Boolean stringAdded = false;
                switch (typeEnum) {
                    case LABEL: {
                        result.append(this.getLabel(element, LabelTypesEnum.LABEL.getLiteral()), style);
                        stringAdded = true;
                        break;
                    }
                    case STEREOTYPE: {
                        String stereotypes = this.getLabel(element, LabelTypesEnum.STEREOTYPE.getLiteral());
                        if (stereotypes == null || stereotypes.isEmpty()) break;
                        result.append(ST_LEFT, style).append(stereotypes, style).append(ST_RIGHT, style);
                        stringAdded = true;
                        break;
                    }
                    case METACLASS: {
                        result.append(this.getLabel(element, LabelTypesEnum.METACLASS.getLiteral()), style);
                        stringAdded = true;
                        break;
                    }
                    case DASH_SEPARATOR: {
                        if (result.length() <= 0 || this.isStylesListEmpty(element, styles)) break;
                        result.append(SEPARATOR_DASH, style);
                        stringAdded = true;
                        break;
                    }
                    case COLON_SEPARATOR: {
                        if (result.length() <= 0 || this.isStylesListEmpty(element, styles)) break;
                        result.append(SEPARATOR_COLON, style);
                        stringAdded = true;
                        break;
                    }
                    case QUALIFIED_NAME: {
                        if (!(element instanceof NamedElement) || ((NamedElement)element).getQualifiedName() == null) break;
                        result.append(((NamedElement)element).getQualifiedName(), style);
                        stringAdded = true;
                        break;
                    }
                }
                if (!stringAdded.booleanValue() || this.isStylesListEmpty(element, styles)) continue;
                result.append(' ');
            }
        }
        if (result.length() <= 0) {
            result.append(new UMLLabelProvider().getText(element));
        }
        return result;
    }

    private boolean isStylesListEmpty(EObject element, LinkedList<Map.Entry<String, StyledString.Styler>> styles) {
        StringBuilder text = new StringBuilder();
        for (Map.Entry entry : styles) {
            if (LabelTypesEnum.DASH_SEPARATOR.getLiteral().equals(entry.getKey()) || LabelTypesEnum.COLON_SEPARATOR.getLiteral().equals(entry.getKey())) continue;
            text.append(this.getLabel(element, (String)entry.getKey()));
        }
        return text.toString().isEmpty();
    }

    protected String getLabel(EObject element, String type) {
        Matcher m;
        String umlResult;
        String result = null;
        IItemLabelProvider provider = this.getDelegate(element);
        String string = umlResult = provider == null ? ModelUtils.getDefaultName((EObject)element) : provider.getText((Object)element);
        if (umlResult != null && (m = UML2_LABEL_PATTERN.matcher(umlResult)).matches()) {
            LabelTypesEnum typeEnum = LabelTypesEnum.getByLiteral(type);
            switch (typeEnum) {
                case LABEL: {
                    if (element instanceof Comment) {
                        result = new UMLLabelProvider().getText((Comment)element);
                        break;
                    }
                    result = m.group(3);
                    break;
                }
                case STEREOTYPE: {
                    result = m.group(1);
                    break;
                }
                case METACLASS: {
                    result = m.group(2);
                    break;
                }
                case DASH_SEPARATOR: {
                    result = SEPARATOR_DASH;
                    break;
                }
                case COLON_SEPARATOR: {
                    result = SEPARATOR_COLON;
                    break;
                }
                case QUALIFIED_NAME: {
                    if (!(element instanceof NamedElement) || ((NamedElement)element).getQualifiedName() == null) break;
                    result = ((NamedElement)element).getQualifiedName();
                    break;
                }
            }
        }
        return result != null ? result : "";
    }

    public Object getImage(Object object) {
        EObject element = EMFHelper.getEObject((Object)object);
        if (element == null) {
            return null;
        }
        IItemLabelProvider provider = this.getDelegate(element);
        return provider == null ? null : provider.getImage((Object)element);
    }

    protected IItemLabelProvider getDelegate(EObject object) {
        return (IItemLabelProvider)this.itemAdapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
    }

    public static class StyleEntry
    implements Map.Entry<String, StyledString.Styler> {
        private String type;
        private StyledString.Styler styler;

        public StyleEntry() {
        }

        public StyleEntry(String type, StyledString.Styler styler) {
            this.type = type;
            this.styler = styler;
        }

        @Override
        public String getKey() {
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public StyledString.Styler getValue() {
            return this.styler;
        }

        public StyledString.Styler getStyle() {
            return this.getValue();
        }

        @Override
        public StyledString.Styler setValue(StyledString.Styler value) {
            StyledString.Styler oldValue = this.styler;
            this.styler = value;
            return oldValue;
        }

        public StyledString.Styler setStyler(StyledString.Styler value) {
            return this.setValue(value);
        }
    }
}

