/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class StateMachineInternalSourceToRepresentationDropChecker
implements IInternalSourceToRepresentationDropChecker {
    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new StateMachineDropOutsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class StateMachineDropOutsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private EObject newSemanticContainer;

        StateMachineDropOutsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseRegion(Region region) {
            CheckStatus result = !(this.newSemanticContainer instanceof StateMachine) && !(this.newSemanticContainer instanceof State) ? CheckStatus.no("Region can only be drag and drop on State or StateMachine.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseState(State state) {
            CheckStatus result = !(this.newSemanticContainer instanceof Region) ? CheckStatus.no("State can only be drag and drop on Region.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus casePseudostate(Pseudostate pseudostate) {
            CheckStatus result = pseudostate.getKind().equals((Object)PseudostateKind.ENTRY_POINT_LITERAL) || pseudostate.getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL) ? (!(this.newSemanticContainer instanceof Region || this.newSemanticContainer instanceof StateMachine || this.newSemanticContainer instanceof State) ? CheckStatus.no("Entry or Exit Point can only be drag and drop on StateMachine or State.") : CheckStatus.YES) : (!(this.newSemanticContainer instanceof Region) ? CheckStatus.no("This Pseudostate can only be drag and drop on Region.") : CheckStatus.YES);
            return result;
        }

        public CheckStatus caseComment(Comment comment) {
            return this.handleContainer();
        }

        private CheckStatus handleContainer() {
            CheckStatus result = !(this.newSemanticContainer instanceof Region) && !(this.newSemanticContainer instanceof StateMachine) && !(this.newSemanticContainer instanceof State) ? CheckStatus.no(MessageFormat.format("{0} can only be drag and drop on a StateMachine kind element.", this.newSemanticContainer.eClass().getName())) : CheckStatus.YES;
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("DnD is not authorized.");
        }
    }
}

