/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.color;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.color.RGBValuesProvider;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class RGBColorChooserPropertySection
extends AbstractViewpointPropertySection {
    protected CLabel colorLabel;
    protected Button button;
    protected CLabel nameLabel;
    protected Composite composite;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(95, 0);
        data.top = new FormAttachment(0, 4);
        this.colorLabel = this.getWidgetFactory().createCLabel(this.composite, "");
        this.colorLabel.setLayoutData((Object)data);
        this.button = this.getWidgetFactory().createButton(this.composite, "...", 8);
        data = new FormData();
        data.left = new FormAttachment(95, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.colorLabel, 0, 0x1000000);
        this.button.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.colorLabel, -25);
        data.top = new FormAttachment((Control)this.colorLabel, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(RGBColorChooserPropertySection.this.composite.getShell());
                colorDialog.setText("RGB Color Selection");
                colorDialog.setRGB(new RGB(255, 255, 255));
                RGB newColor = colorDialog.open();
                if (newColor != null) {
                    RGBColorChooserPropertySection.this.handleFeatureModified(newColor);
                }
            }
        });
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.eObject.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (RGBColorChooserPropertySection.this.eObject instanceof FixedColor) {
                    FixedColor newColor = (FixedColor)RGBColorChooserPropertySection.this.eObject;
                    if (!RGBColorChooserPropertySection.this.colorLabel.isDisposed()) {
                        RGBColorChooserPropertySection.this.colorLabel.setBackground(VisualBindingManager.getDefault().getColorFromRGBValues(new RGBValuesProvider().getRGBValues(newColor)));
                    }
                }
                super.notifyChanged(msg);
            }
        });
    }

    protected void handleFeatureModified(RGB newColor) {
        boolean equals = this.isEqual(newColor);
        if (!equals) {
            this.colorLabel.setBackground(VisualBindingManager.getDefault().getColorFromRGB(newColor));
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            if (this.eObjectList.size() == 1) {
                CompoundCommand compoundCommand = new CompoundCommand();
                compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)DescriptionPackage.eINSTANCE.getFixedColor_Blue(), (Object)newColor.blue));
                compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)DescriptionPackage.eINSTANCE.getFixedColor_Green(), (Object)newColor.green));
                compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)DescriptionPackage.eINSTANCE.getFixedColor_Red(), (Object)newColor.red));
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)DescriptionPackage.eINSTANCE.getFixedColor_Blue(), (Object)newColor.blue));
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)DescriptionPackage.eINSTANCE.getFixedColor_Green(), (Object)newColor.green));
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)DescriptionPackage.eINSTANCE.getFixedColor_Red(), (Object)newColor.red));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        if (this.colorLabel != null) {
            RGBValues color = new RGBValuesProvider().getRGBValues((FixedColor)this.eObject);
            this.colorLabel.setBackground(VisualBindingManager.getDefault().getColorFromRGBValues(color));
        }
    }

    protected String getLabelText() {
        return "Selected RGB Color:";
    }

    protected boolean isEqual(RGB newColor) {
        boolean equal = true;
        if (newColor != null && this.eObject instanceof FixedColor) {
            FixedColor rgbColor = (FixedColor)this.eObject;
            equal = rgbColor.getBlue() == newColor.blue && rgbColor.getRed() == newColor.red && rgbColor.getGreen() == newColor.green;
        } else {
            this.refresh();
        }
        return equal;
    }

    protected Object getFeatureValue(String newText) {
        return this.toInteger(newText);
    }

    private Integer toInteger(String text) {
        Integer integerValue = null;
        try {
            integerValue = new Integer(text);
        }
        catch (NumberFormatException numberFormatException) {}
        return integerValue;
    }

    public void dispose() {
        if (this.eObject != null) {
            this.eObject.eAdapters().clear();
        }
        super.dispose();
    }

    @Override
    protected void makeReadonly() {
        this.button.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.button.setEnabled(true);
    }

    @Override
    protected EStructuralFeature getFeature() {
        return DescriptionPackage.eINSTANCE.getFixedColor_Blue();
    }
}

