/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.migration;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.uml2.uml.Lifeline;

public class SequenceDiagramLunaToMarsReconciler
extends DiagramReconciler {
    private static final String DIAGRAM_COMPATIBILITY_VERSION_KEY = "diagram_compatibility_version";
    private static final String sourceDiagramVersion = "1.0.0";

    public ICommand getReconcileCommand(final Diagram diagram) {
        String diagramVersion = NotationUtils.getStringValue((View)diagram, (String)DIAGRAM_COMPATIBILITY_VERSION_KEY, (String)"");
        AbstractCommand cmd = null;
        if (sourceDiagramVersion.equals(diagramVersion)) {
            cmd = new AbstractCommand("Reconcile Sequence Diagram locations."){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    SequenceDiagramLunaToMarsReconciler.this.addManualSizeEAnnotation(diagram);
                    return CommandResult.newOKCommandResult();
                }

                protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    return null;
                }

                protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    return null;
                }
            };
        }
        return cmd;
    }

    private void addManualSizeEAnnotation(Diagram diagram) {
        TreeIterator allContentIterator = diagram.eAllContents();
        while (allContentIterator.hasNext()) {
            EObject element;
            EObject eObject = (EObject)allContentIterator.next();
            if (!(eObject instanceof Shape) || !((element = ((Shape)eObject).getElement()) instanceof Lifeline)) continue;
            Shape shape = (Shape)eObject;
            EAnnotation eannotation = shape.getEAnnotation("CustomExtensionInfo");
            if (eannotation != null) {
                String value = (String)eannotation.getDetails().get((Object)"manual.label.size");
                if (Boolean.FALSE.toString().equals(value) || value == null) {
                    eannotation.getDetails().put((Object)"manual.label.size", (Object)Boolean.TRUE.toString());
                }
            }
            if (eannotation != null) continue;
            eannotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eannotation.getDetails().put((Object)"manual.label.size", (Object)Boolean.TRUE.toString());
            eannotation.setSource("CustomExtensionInfo");
            shape.getEAnnotations().add((Object)eannotation);
        }
    }
}

