/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.modelresource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.AbstractModelWithSharedResource;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class PapyrusNattableModel
extends AbstractModelWithSharedResource<Table>
implements IModel {
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.nattable.resource.NattableModel";
    public static final String TABLE_MODEL_FILE_EXTENSION = "notation";

    public void init(ModelSet modelManager) {
        super.init(modelManager);
    }

    protected String getModelFileExtension() {
        return TABLE_MODEL_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public void addPapyrusTable(Table tableInstance) {
        EObject context = tableInstance.getContext();
        if (context != null) {
            Resource targetResource;
            Resource contextResource = context.eResource();
            if (!contextResource.getURI().trimFileExtension().equals(this.getResource().getURI().trimFileExtension())) {
                URI uri = contextResource.getURI();
                uri = uri.trimFileExtension();
                uri = uri.appendFileExtension(this.getModelFileExtension());
                ResourceSet set = contextResource.getResourceSet();
                targetResource = set.getResource(uri, true);
            } else {
                targetResource = this.getResource();
            }
            if (targetResource != null) {
                targetResource.getContents().add((Object)tableInstance);
            }
        }
    }

    public void removeTable(Table tableInstance) {
        if (tableInstance.eResource() != null) {
            tableInstance.eResource().getContents().remove((Object)tableInstance);
        }
    }

    protected boolean isModelRoot(EObject object) {
        return object instanceof Table;
    }

    public Table getTable(String tableName) throws NotFoundException, BadArgumentExcetion {
        if (tableName == null || tableName.length() == 0) {
            throw new BadArgumentExcetion("Table name should not be null and size should be >0.");
        }
        for (Resource current : this.getResources()) {
            for (EObject element : current.getContents()) {
                Table table;
                if (!(element instanceof Table) || !tableName.equals((table = (Table)element).getName())) continue;
                return table;
            }
        }
        throw new NotFoundException(NLS.bind((String)"No Table named {0} can be found in Model.", (Object)tableName));
    }

    public List<Table> getTableByName(String tableName) {
        Assert.isNotNull((Object)tableName);
        ArrayList<Table> matchingTables = new ArrayList<Table>();
        for (Resource current : this.getResources()) {
            for (EObject element : current.getContents()) {
                Table table;
                if (!(element instanceof Table) || !tableName.equals((table = (Table)element).getName())) continue;
                matchingTables.add(table);
            }
        }
        return matchingTables;
    }

    public List<Table> getTableByType(String tableType) {
        Assert.isNotNull((Object)tableType);
        ArrayList<Table> matchingTables = new ArrayList<Table>();
        for (Resource current : this.getResources()) {
            for (EObject element : current.getContents()) {
                Table table;
                if (!(element instanceof Table) || !tableType.equals((table = (Table)element).getTableConfiguration().getType())) continue;
                matchingTables.add(table);
            }
        }
        return matchingTables;
    }

    public List<Table> getTableByContext(EObject tableContext) {
        Assert.isNotNull((Object)tableContext);
        ArrayList<Table> matchingTables = new ArrayList<Table>();
        for (Resource current : this.getResources()) {
            for (EObject element : current.getContents()) {
                Table table;
                if (!(element instanceof Table) || !tableContext.equals((table = (Table)element).getContext())) continue;
                matchingTables.add(table);
            }
        }
        return matchingTables;
    }

    public List<Table> getTableByOwner(EObject tableOwner) {
        Assert.isNotNull((Object)tableOwner);
        ArrayList<Table> matchingTables = new ArrayList<Table>();
        for (Resource current : this.getResources()) {
            for (EObject element : current.getContents()) {
                Table table;
                if (!(element instanceof Table) || !tableOwner.equals((table = (Table)element).getOwner())) continue;
                matchingTables.add(table);
            }
        }
        return matchingTables;
    }

    public List<Table> findMatchingTables(EObject tableContext, EObject tableOwner, String tableType, String tableName) {
        ArrayList<Table> matchingTables = new ArrayList<Table>();
        for (Resource current : this.getResources()) {
            for (EObject element : current.getContents()) {
                if (!(element instanceof Table)) continue;
                Table table = (Table)element;
                boolean matchName = true;
                boolean matchType = true;
                boolean matchOwner = true;
                boolean matchContext = true;
                if (tableName != null) {
                    matchName = tableName.equals(table.getName());
                }
                if (tableType != null) {
                    matchType = tableType.equals(table.getTableConfiguration().getType());
                }
                if (tableOwner != null) {
                    matchOwner = tableOwner.equals(table.getOwner());
                }
                if (tableContext != null) {
                    matchContext = tableContext.equals(table.getContext());
                }
                if (!matchName || !matchType || !matchOwner || !matchContext) continue;
                matchingTables.add(table);
            }
        }
        return matchingTables;
    }
}

