/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.assistedinject;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.assistedinject.AssistedInjectBinding;
import com.google.inject.assistedinject.AssistedInjectTargetVisitor;
import com.google.inject.assistedinject.AssistedMethod;
import com.google.inject.assistedinject.BindingCollector;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.internal.util.Classes;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryProvider2<F>
implements InvocationHandler,
ProviderWithExtensionVisitor<F>,
HasDependencies,
AssistedInjectBinding<F> {
    static final Annotation RETURN_ANNOTATION = UniqueAnnotations.create();
    static final Logger logger = Logger.getLogger(AssistedInject.class.getName());
    private static boolean allowPrivateLookupFallback = true;
    private static boolean allowMethodHandleWorkaround = true;
    static final Assisted DEFAULT_ANNOTATION = new Assisted(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Assisted.class;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Assisted && ((Assisted)o).value().isEmpty();
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ "".hashCode();
        }

        @Override
        public String toString() {
            return "@" + Assisted.class.getName() + "(" + Annotations.memberValueString((String)"value", (Object)"") + ")";
        }
    };
    private final ImmutableMap<Method, AssistData> assistDataByMethod;
    private final ImmutableMap<Method, MethodHandle> methodHandleByMethod;
    private Injector injector;
    private final F factory;
    private final Key<F> factoryKey;
    private final BindingCollector collector;

    FactoryProvider2(Key<F> factoryKey, BindingCollector collector, MethodHandles.Lookup userLookups) {
        this.factoryKey = factoryKey;
        this.collector = collector;
        TypeLiteral factoryType = factoryKey.getTypeLiteral();
        Errors errors = new Errors();
        Class factoryRawType = factoryType.getRawType();
        try {
            if (!factoryRawType.isInterface()) {
                throw errors.addMessage("%s must be an interface.", new Object[]{factoryRawType}).toException();
            }
            HashMultimap defaultMethods = HashMultimap.create();
            HashMultimap otherMethods = HashMultimap.create();
            ImmutableMap.Builder assistDataBuilder = ImmutableMap.builder();
            for (Method method : factoryRawType.getMethods()) {
                InjectionPoint ctorInjectionPoint;
                Class scope;
                Key returnType;
                if (Modifier.isStatic(method.getModifiers())) continue;
                if (FactoryProvider2.isDefault(method) && (method.isBridge() || method.isSynthetic())) {
                    this.validateFactoryReturnType(errors, method.getReturnType(), factoryRawType);
                    defaultMethods.put((Object)method.getName(), (Object)method);
                    continue;
                }
                otherMethods.put((Object)method.getName(), (Object)method);
                TypeLiteral returnTypeLiteral = factoryType.getReturnType(method);
                try {
                    returnType = Annotations.getKey((TypeLiteral)returnTypeLiteral, (Member)method, (Annotation[])method.getAnnotations(), (Errors)errors);
                }
                catch (ConfigurationException ce) {
                    if (this.isTypeNotSpecified(returnTypeLiteral, ce)) {
                        throw errors.keyNotFullySpecified(TypeLiteral.get((Class)factoryRawType)).toException();
                    }
                    throw ce;
                }
                this.validateFactoryReturnType(errors, returnType.getTypeLiteral().getRawType(), factoryRawType);
                List params = factoryType.getParameterTypes((Member)method);
                Annotation[][] paramAnnotations = method.getParameterAnnotations();
                int p = 0;
                ArrayList keys = Lists.newArrayList();
                for (TypeLiteral param : params) {
                    Key paramKey = Annotations.getKey((TypeLiteral)param, (Member)method, (Annotation[])paramAnnotations[p++], (Errors)errors);
                    Class underlylingType = paramKey.getTypeLiteral().getRawType();
                    if (underlylingType.equals(Provider.class) || underlylingType.equals(jakarta.inject.Provider.class)) {
                        errors.addMessage("A Provider may not be a type in a factory method of an AssistedInject.\n  Offending instance is parameter [%s] with key [%s] on method [%s]", new Object[]{p, paramKey, method});
                    }
                    keys.add(this.assistKey(method, paramKey, errors));
                }
                ImmutableList immutableParamList = ImmutableList.copyOf((Collection)keys);
                TypeLiteral implementation = collector.getBindings().get(returnType);
                if (implementation == null) {
                    implementation = returnType.getTypeLiteral();
                }
                if ((scope = Annotations.findScopeAnnotation((Errors)errors, (Class)implementation.getRawType())) != null) {
                    errors.addMessage("Found scope annotation [%s] on implementation class [%s] of AssistedInject factory [%s].\nThis is not allowed, please remove the scope annotation.", new Object[]{scope, implementation.getRawType(), factoryType});
                }
                try {
                    ctorInjectionPoint = this.findMatchingConstructorInjectionPoint(method, (Key<?>)returnType, (TypeLiteral)implementation, (List<Key<?>>)immutableParamList);
                }
                catch (ErrorsException ee) {
                    errors.merge(ee.getErrors());
                    continue;
                }
                Constructor constructor = (Constructor)ctorInjectionPoint.getMember();
                ImmutableList providers = Collections.emptyList();
                Set<Dependency<?>> deps = this.getDependencies(ctorInjectionPoint, implementation);
                boolean optimized = false;
                if (this.isValidForOptimizedAssistedInject(deps, implementation.getRawType(), factoryType)) {
                    ImmutableList.Builder providerListBuilder = ImmutableList.builder();
                    for (int i = 0; i < params.size(); ++i) {
                        providerListBuilder.add((Object)new ThreadLocalProvider());
                    }
                    providers = providerListBuilder.build();
                    optimized = true;
                }
                AssistData data = new AssistData(constructor, returnType, immutableParamList, implementation, method, this.removeAssistedDeps(deps), optimized, (List<ThreadLocalProvider>)providers);
                assistDataBuilder.put((Object)method, (Object)data);
            }
            this.factory = factoryRawType.cast(Proxy.newProxyInstance(factoryRawType.getClassLoader(), new Class[]{factoryRawType}, (InvocationHandler)this));
            ImmutableMap dataSoFar = assistDataBuilder.buildOrThrow();
            ImmutableMap.Builder methodHandleBuilder = ImmutableMap.builder();
            boolean warnedAboutUserLookups = false;
            for (Map.Entry entry : defaultMethods.entries()) {
                MethodHandle handle;
                Method defaultMethod;
                block27: {
                    if (!warnedAboutUserLookups && userLookups == null && !Modifier.isPublic(this.factory.getClass().getModifiers())) {
                        warnedAboutUserLookups = true;
                        logger.log(Level.WARNING, "AssistedInject factory {0} is non-public and has javac-generated default methods.  Please pass a `MethodHandles.lookup()` with FactoryModuleBuilder.withLookups when using this factory so that Guice can properly call the default methods. Guice will try to workaround this, but it does not always work (depending on the method signatures of the factory).", new Object[]{factoryType});
                    }
                    defaultMethod = (Method)entry.getValue();
                    handle = null;
                    try {
                        handle = FactoryProvider2.superMethodHandle(SuperMethodSupport.METHOD_LOOKUP, defaultMethod, this.factory, userLookups);
                    }
                    catch (ReflectiveOperationException e1) {
                        if (!allowPrivateLookupFallback || SuperMethodSupport.METHOD_LOOKUP == SuperMethodLookup.PRIVATE_LOOKUP) break block27;
                        try {
                            handle = FactoryProvider2.superMethodHandle(SuperMethodLookup.PRIVATE_LOOKUP, defaultMethod, this.factory, userLookups);
                        }
                        catch (ReflectiveOperationException p) {
                            // empty catch block
                        }
                    }
                }
                Supplier<String> failureMsg = () -> "Unable to use non-public factory " + factoryRawType.getName() + ". Please call FactoryModuleBuilder.withLookups(MethodHandles.lookup()) (with a lookups that has access to the factory), or make the factory public.";
                if (handle != null) {
                    methodHandleBuilder.put((Object)defaultMethod, (Object)handle);
                    continue;
                }
                if (!allowMethodHandleWorkaround) {
                    errors.addMessage(failureMsg.get(), new Object[0]);
                    continue;
                }
                boolean foundMatch = false;
                for (Method otherMethod : otherMethods.get((Object)defaultMethod.getName())) {
                    if (!dataSoFar.containsKey(otherMethod) || !this.isCompatible(defaultMethod, otherMethod)) continue;
                    if (foundMatch) {
                        errors.addMessage(failureMsg.get(), new Object[0]);
                        break;
                    }
                    assistDataBuilder.put((Object)defaultMethod, (Object)((AssistData)dataSoFar.get(otherMethod)));
                    foundMatch = true;
                }
                if (foundMatch) continue;
                throw new IllegalStateException("Can't find method compatible with: " + defaultMethod);
            }
            if (errors.hasErrors()) {
                throw errors.toException();
            }
            this.assistDataByMethod = assistDataBuilder.buildOrThrow();
            this.methodHandleByMethod = methodHandleBuilder.buildOrThrow();
        }
        catch (ErrorsException e) {
            throw new ConfigurationException((Iterable)e.getErrors().getMessages());
        }
    }

    static boolean isDefault(Method method) {
        return (method.getModifiers() & 0x409) == 1;
    }

    private boolean isCompatible(Method src, Method dst) {
        Class<?>[] dstParams;
        if (!src.getReturnType().isAssignableFrom(dst.getReturnType())) {
            return false;
        }
        Class<?>[] srcParams = src.getParameterTypes();
        if (srcParams.length != (dstParams = dst.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < srcParams.length; ++i) {
            if (srcParams[i].isAssignableFrom(dstParams[i])) continue;
            return false;
        }
        return true;
    }

    public F get() {
        return this.factory;
    }

    public Set<Dependency<?>> getDependencies() {
        HashSet combinedDeps = new HashSet();
        for (AssistData data : this.assistDataByMethod.values()) {
            combinedDeps.addAll(data.dependencies);
        }
        return ImmutableSet.copyOf(combinedDeps);
    }

    @Override
    public Key<F> getKey() {
        return this.factoryKey;
    }

    @Override
    public Collection<AssistedMethod> getAssistedMethods() {
        return this.assistDataByMethod.values();
    }

    public <T, V> V acceptExtensionVisitor(BindingTargetVisitor<T, V> visitor, ProviderInstanceBinding<? extends T> binding) {
        if (visitor instanceof AssistedInjectTargetVisitor) {
            return ((AssistedInjectTargetVisitor)visitor).visit(this);
        }
        return (V)visitor.visit(binding);
    }

    private void validateFactoryReturnType(Errors errors, Class<?> returnType, Class<?> factoryType) {
        if (Modifier.isPublic(factoryType.getModifiers()) && !Modifier.isPublic(returnType.getModifiers())) {
            errors.addMessage("%s is public, but has a method that returns a non-public type: %s. Due to limitations with java.lang.reflect.Proxy, this is not allowed. Please either make the factory non-public or the return type public.", new Object[]{factoryType, returnType});
        }
    }

    private boolean isTypeNotSpecified(TypeLiteral<?> typeLiteral, ConfigurationException ce) {
        Collection messages = ce.getErrorMessages();
        if (messages.size() == 1) {
            Message msg = (Message)Iterables.getOnlyElement((Iterable)new Errors().keyNotFullySpecified(typeLiteral).getMessages());
            return msg.getMessage().equals(((Message)Iterables.getOnlyElement((Iterable)messages)).getMessage());
        }
        return false;
    }

    private <T> InjectionPoint findMatchingConstructorInjectionPoint(Method method, Key<?> returnType, TypeLiteral<T> implementation, List<Key<?>> paramList) throws ErrorsException {
        Errors errors = new Errors((Object)method);
        errors = returnType.getTypeLiteral().equals(implementation) ? errors.withSource(implementation) : errors.withSource(returnType).withSource(implementation);
        Class rawType = implementation.getRawType();
        if (Modifier.isInterface(rawType.getModifiers())) {
            errors.addMessage("%s is an interface, not a concrete class.  Unable to create AssistedInject factory.", new Object[]{implementation});
            throw errors.toException();
        }
        if (Modifier.isAbstract(rawType.getModifiers())) {
            errors.addMessage("%s is abstract, not a concrete class.  Unable to create AssistedInject factory.", new Object[]{implementation});
            throw errors.toException();
        }
        if (Classes.isInnerClass((Class)rawType)) {
            errors.cannotInjectInnerClass(rawType);
            throw errors.toException();
        }
        Constructor<?> matchingConstructor = null;
        boolean anyAssistedInjectConstructors = false;
        for (Constructor<?> constructor : rawType.getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(AssistedInject.class)) continue;
            anyAssistedInjectConstructors = true;
            if (!this.constructorHasMatchingParams(implementation, constructor, paramList, errors)) continue;
            if (matchingConstructor != null) {
                errors.addMessage("%s has more than one constructor annotated with @AssistedInject that matches the parameters in method %s.  Unable to create AssistedInject factory.", new Object[]{implementation, method});
                throw errors.toException();
            }
            matchingConstructor = constructor;
        }
        if (!anyAssistedInjectConstructors) {
            try {
                return InjectionPoint.forConstructorOf(implementation);
            }
            catch (ConfigurationException e) {
                errors.merge(e.getErrorMessages());
                throw errors.toException();
            }
        }
        if (matchingConstructor != null) {
            InjectionPoint ip = InjectionPoint.forConstructor(matchingConstructor, implementation);
            return ip;
        }
        errors.addMessage("%s has @AssistedInject constructors, but none of them match the parameters in method %s.  Unable to create AssistedInject factory.", new Object[]{implementation, method});
        throw errors.toException();
    }

    private boolean constructorHasMatchingParams(TypeLiteral<?> type, Constructor<?> constructor, List<Key<?>> paramList, Errors errors) throws ErrorsException {
        List params = type.getParameterTypes(constructor);
        Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
        int p = 0;
        ArrayList constructorKeys = Lists.newArrayList();
        for (TypeLiteral typeLiteral : params) {
            Key paramKey = Annotations.getKey((TypeLiteral)typeLiteral, constructor, (Annotation[])paramAnnotations[p++], (Errors)errors);
            constructorKeys.add(paramKey);
        }
        for (Key key : paramList) {
            if (constructorKeys.remove(key)) continue;
            return false;
        }
        for (Key key : constructorKeys) {
            if (key.getAnnotationType() != Assisted.class) continue;
            return false;
        }
        return true;
    }

    private Set<Dependency<?>> getDependencies(InjectionPoint ctorPoint, TypeLiteral<?> implementation) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)ctorPoint.getDependencies());
        if (!implementation.getRawType().isInterface()) {
            for (InjectionPoint ip : InjectionPoint.forInstanceMethodsAndFields(implementation)) {
                builder.addAll((Iterable)ip.getDependencies());
            }
        }
        return builder.build();
    }

    private Set<Dependency<?>> removeAssistedDeps(Set<Dependency<?>> deps) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Dependency<?> dep : deps) {
            Class annotationType = dep.getKey().getAnnotationType();
            if (annotationType != null && annotationType.equals(Assisted.class)) continue;
            builder.add(dep);
        }
        return builder.build();
    }

    private boolean isValidForOptimizedAssistedInject(Set<Dependency<?>> dependencies, Class<?> implementation, TypeLiteral<?> factoryType) {
        Set badDeps = null;
        for (Dependency<?> dep : dependencies) {
            if (!this.isInjectorOrAssistedProvider(dep)) continue;
            if (badDeps == null) {
                badDeps = Sets.newHashSet();
            }
            badDeps.add(dep);
        }
        if (badDeps != null && !badDeps.isEmpty()) {
            logger.log(Level.WARNING, "AssistedInject factory {0} will be slow because {1} has assisted Provider dependencies or injects the Injector. Stop injecting @Assisted Provider<T> (instead use @Assisted T) or Injector to speed things up. (It will be a ~6500% speed bump!)  The exact offending deps are: {2}", new Object[]{factoryType, implementation, badDeps});
            return false;
        }
        return true;
    }

    private boolean isInjectorOrAssistedProvider(Dependency<?> dependency) {
        Class annotationType = dependency.getKey().getAnnotationType();
        return annotationType != null && annotationType.equals(Assisted.class) ? dependency.getKey().getTypeLiteral().getRawType().equals(Provider.class) : dependency.getKey().getTypeLiteral().getRawType().equals(Injector.class);
    }

    private <T> Key<T> assistKey(Method method, Key<T> key, Errors errors) throws ErrorsException {
        if (key.getAnnotationType() == null) {
            return key.withAnnotation((Annotation)DEFAULT_ANNOTATION);
        }
        if (key.getAnnotationType() == Assisted.class) {
            return key;
        }
        errors.withSource((Object)method).addMessage("Only @Assisted is allowed for factory parameters, but found @%s", new Object[]{key.getAnnotationType()});
        throw errors.toException();
    }

    @Inject
    @Toolable
    void initialize(Injector injector) {
        if (this.injector != null) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message(FactoryProvider2.class, "Factories.create() factories may only be used in one Injector!")));
        }
        this.injector = injector;
        for (Map.Entry entry : this.assistDataByMethod.entrySet()) {
            Object[] args;
            Method method = (Method)entry.getKey();
            AssistData data = (AssistData)entry.getValue();
            if (!data.optimized) {
                args = new Object[method.getParameterTypes().length];
                Arrays.fill(args, "dummy object for validating Factories");
            } else {
                args = null;
            }
            this.getBindingFromNewInjector(method, args, data);
        }
    }

    public Binding<?> getBindingFromNewInjector(final Method method, final Object[] args, final AssistData data) {
        Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"Factories.create() factories cannot be used until they're initialized by Guice.");
        Key<?> returnType = data.returnType;
        final Key returnKey = Key.get((TypeLiteral)returnType.getTypeLiteral(), (Annotation)RETURN_ANNOTATION);
        AbstractModule assistedModule = new AbstractModule(this){

            protected void configure() {
                Constructor<?> constructor;
                Binder binder = this.binder().withSource((Object)method);
                int p = 0;
                if (!data.optimized) {
                    for (Key paramKey : data.paramTypes) {
                        binder.bind(paramKey).toProvider(Providers.of((Object)args[p++]));
                    }
                } else {
                    for (Key paramKey : data.paramTypes) {
                        binder.bind(paramKey).toProvider((Provider)data.providers.get(p++));
                    }
                }
                if ((constructor = data.constructor) != null) {
                    binder.bind(returnKey).toConstructor(constructor, data.implementationType).in(Scopes.NO_SCOPE);
                }
            }
        };
        Injector forCreate = this.injector.createChildInjector(new Module[]{assistedModule});
        Binding binding = forCreate.getBinding(returnKey);
        if (data.optimized) {
            data.cachedBinding = binding;
        }
        return binding;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.methodHandleByMethod.containsKey((Object)method)) {
            return ((MethodHandle)this.methodHandleByMethod.get((Object)method)).invokeWithArguments(args);
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            return method.invoke((Object)this, args);
        }
        AssistData data = (AssistData)this.assistDataByMethod.get((Object)method);
        Preconditions.checkState((data != null ? 1 : 0) != 0, (String)"No data for method: %s", (Object)method);
        Provider provider = data.cachedBinding != null ? data.cachedBinding.getProvider() : this.getBindingFromNewInjector(method, args, data).getProvider();
        try {
            int p = 0;
            for (ThreadLocalProvider threadLocalProvider : data.providers) {
                threadLocalProvider.set(args[p++]);
            }
            Object object = provider.get();
            return object;
        }
        catch (ProvisionException e) {
            Message onlyError;
            Throwable throwable;
            if (e.getErrorMessages().size() == 1 && (throwable = (onlyError = (Message)Iterables.getOnlyElement((Iterable)e.getErrorMessages())).getCause()) != null && FactoryProvider2.canRethrow(method, throwable)) {
                throw throwable;
            }
            throw e;
        }
        finally {
            for (ThreadLocalProvider tlp : data.providers) {
                tlp.remove();
            }
        }
    }

    public String toString() {
        return this.factory.getClass().getInterfaces()[0].getName();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.factoryKey, this.collector});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FactoryProvider2)) {
            return false;
        }
        FactoryProvider2 other = (FactoryProvider2)obj;
        return this.factoryKey.equals(other.factoryKey) && Objects.equal((Object)this.collector, (Object)other.collector);
    }

    static boolean canRethrow(Method invoked, Throwable thrown) {
        if (thrown instanceof Error || thrown instanceof RuntimeException) {
            return true;
        }
        for (Class<?> declared : invoked.getExceptionTypes()) {
            if (!declared.isInstance(thrown)) continue;
            return true;
        }
        return false;
    }

    private static MethodHandle superMethodHandle(SuperMethodLookup strategy, Method method, Object proxy, MethodHandles.Lookup userLookups) throws ReflectiveOperationException {
        MethodHandles.Lookup lookup = userLookups == null ? MethodHandles.lookup() : userLookups;
        MethodHandle handle = strategy.superMethodHandle(method, lookup);
        return handle != null ? handle.bindTo(proxy) : null;
    }

    static class PrivateLookup {
        private static final int ALL_MODES = 15;
        private static final Constructor<MethodHandles.Lookup> privateLookupCxtor = PrivateLookup.findPrivateLookupCxtor();

        PrivateLookup() {
        }

        private static Constructor<MethodHandles.Lookup> findPrivateLookupCxtor() {
            try {
                Constructor<MethodHandles.Lookup> cxtor;
                try {
                    cxtor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                }
                catch (NoSuchMethodException ignored) {
                    cxtor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Class.class, Integer.TYPE);
                }
                cxtor.setAccessible(true);
                return cxtor;
            }
            catch (Exception e) {
                return null;
            }
        }

        static MethodHandle superMethodHandle(Method method) throws ReflectiveOperationException {
            if (privateLookupCxtor == null) {
                return null;
            }
            Class<?> declaringClass = method.getDeclaringClass();
            MethodHandles.Lookup lookup = privateLookupCxtor.getParameterCount() == 2 ? privateLookupCxtor.newInstance(declaringClass, 15) : privateLookupCxtor.newInstance(declaringClass, null, 15);
            return lookup.unreflectSpecial(method, declaringClass);
        }
    }

    private static enum SuperMethodLookup {
        UNREFLECT_SPECIAL{

            @Override
            MethodHandle superMethodHandle(Method method, MethodHandles.Lookup lookup) throws ReflectiveOperationException {
                return lookup.unreflectSpecial(method, method.getDeclaringClass());
            }
        }
        ,
        FIND_SPECIAL{

            @Override
            MethodHandle superMethodHandle(Method method, MethodHandles.Lookup lookup) throws ReflectiveOperationException {
                Class<?> declaringClass = method.getDeclaringClass();
                return lookup.findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
            }
        }
        ,
        PRIVATE_LOOKUP{

            @Override
            MethodHandle superMethodHandle(Method method, MethodHandles.Lookup unused) throws ReflectiveOperationException {
                return PrivateLookup.superMethodHandle(method);
            }
        };


        abstract MethodHandle superMethodHandle(Method var1, MethodHandles.Lookup var2) throws ReflectiveOperationException;
    }

    private static class SuperMethodSupport {
        private static final SuperMethodLookup METHOD_LOOKUP;

        private SuperMethodSupport() {
        }

        static {
            SuperMethodLookup workingLookup = null;
            try {
                Class<?> hidden = Class.forName("com.google.inject.assistedinject.internal.LookupTester$Hidden");
                Method method = hidden.getMethod("method", new Class[0]);
                Field lookupsField = hidden.getEnclosingClass().getDeclaredField("LOOKUP");
                lookupsField.setAccessible(true);
                MethodHandles.Lookup lookups = (MethodHandles.Lookup)lookupsField.get(null);
                for (SuperMethodLookup attempt : SuperMethodLookup.values()) {
                    try {
                        attempt.superMethodHandle(method, lookups);
                        workingLookup = attempt;
                        break;
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                    }
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            if (workingLookup == null) {
                workingLookup = SuperMethodLookup.PRIVATE_LOOKUP;
            }
            METHOD_LOOKUP = workingLookup;
        }
    }

    private static class ThreadLocalProvider
    extends ThreadLocal<Object>
    implements Provider<Object> {
        private ThreadLocalProvider() {
        }

        @Override
        protected Object initialValue() {
            throw new IllegalStateException("Cannot use optimized @Assisted provider outside the scope of the constructor. (This should never happen.  If it does, please report it.)");
        }
    }

    private static class AssistData
    implements AssistedMethod {
        final Constructor<?> constructor;
        final Key<?> returnType;
        final ImmutableList<Key<?>> paramTypes;
        final TypeLiteral<?> implementationType;
        final Set<Dependency<?>> dependencies;
        final Method factoryMethod;
        final boolean optimized;
        final List<ThreadLocalProvider> providers;
        volatile Binding<?> cachedBinding;

        AssistData(Constructor<?> constructor, Key<?> returnType, ImmutableList<Key<?>> paramTypes, TypeLiteral<?> implementationType, Method factoryMethod, Set<Dependency<?>> dependencies, boolean optimized, List<ThreadLocalProvider> providers) {
            this.constructor = constructor;
            this.returnType = returnType;
            this.paramTypes = paramTypes;
            this.implementationType = implementationType;
            this.factoryMethod = factoryMethod;
            this.dependencies = dependencies;
            this.optimized = optimized;
            this.providers = providers;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("ctor", this.constructor).add("return type", this.returnType).add("param type", this.paramTypes).add("implementation type", this.implementationType).add("dependencies", this.dependencies).add("factory method", (Object)this.factoryMethod).add("optimized", this.optimized).add("providers", this.providers).add("cached binding", this.cachedBinding).toString();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }

        @Override
        public Method getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public Constructor<?> getImplementationConstructor() {
            return this.constructor;
        }

        @Override
        public TypeLiteral<?> getImplementationType() {
            return this.implementationType;
        }
    }
}

