/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcTransportImpl;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.parser.XmlRpcResponseParser;
import org.apache.xmlrpc.serializer.XmlRpcWriter;
import org.apache.xmlrpc.util.SAXParsers;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlRpcStreamTransport
extends XmlRpcTransportImpl {
    protected XmlRpcStreamTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    protected abstract void close() throws XmlRpcClientException;

    protected abstract boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig var1);

    protected abstract InputStream getInputStream() throws XmlRpcException;

    protected boolean isCompressingRequest(XmlRpcStreamRequestConfig pConfig) {
        return pConfig.isEnabledForExtensions() && pConfig.isGzipCompressing();
    }

    protected ReqWriter newReqWriter(XmlRpcRequest pRequest) throws XmlRpcException, IOException, SAXException {
        ReqWriter reqWriter = new ReqWriterImpl(pRequest);
        if (this.isCompressingRequest((XmlRpcStreamRequestConfig)pRequest.getConfig())) {
            reqWriter = new GzipReqWriter(reqWriter);
        }
        return reqWriter;
    }

    protected abstract void writeRequest(ReqWriter var1) throws XmlRpcException, IOException, SAXException;

    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        XmlRpcStreamRequestConfig config = (XmlRpcStreamRequestConfig)pRequest.getConfig();
        boolean closed = false;
        try {
            ReqWriter reqWriter = this.newReqWriter(pRequest);
            this.writeRequest(reqWriter);
            InputStream istream = this.getInputStream();
            if (this.isResponseGzipCompressed(config)) {
                istream = new GZIPInputStream(istream);
            }
            Object result = this.readResponse(config, istream);
            closed = true;
            this.close();
            Object object = result;
            return object;
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to read server's response: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            if (ex != null && ex instanceof XmlRpcException) {
                throw (XmlRpcException)ex;
            }
            throw new XmlRpcException("Failed to generate request: " + e.getMessage(), e);
        }
        finally {
            if (!closed) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected XMLReader newXMLReader() throws XmlRpcException {
        return SAXParsers.newXMLReader();
    }

    protected Object readResponse(XmlRpcStreamRequestConfig pConfig, InputStream pStream) throws XmlRpcException {
        XmlRpcResponseParser xp;
        InputSource isource = new InputSource(pStream);
        XMLReader xr = this.newXMLReader();
        try {
            xp = new XmlRpcResponseParser(pConfig, this.getClient().getTypeFactory());
            xr.setContentHandler(xp);
            xr.parse(isource);
        }
        catch (SAXException e) {
            throw new XmlRpcClientException("Failed to parse server's response: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to read server's response: " + e.getMessage(), e);
        }
        if (xp.isSuccess()) {
            return xp.getResult();
        }
        Throwable t = xp.getErrorCause();
        if (t == null) {
            throw new XmlRpcException(xp.getErrorCode(), xp.getErrorMessage());
        }
        if (t instanceof XmlRpcException) {
            throw (XmlRpcException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new XmlRpcException(xp.getErrorCode(), xp.getErrorMessage(), t);
    }

    protected class GzipReqWriter
    implements ReqWriter {
        private final ReqWriter reqWriter;

        protected GzipReqWriter(ReqWriter pReqWriter) {
            this.reqWriter = pReqWriter;
        }

        public void write(OutputStream pStream) throws XmlRpcException, IOException, SAXException {
            try {
                GZIPOutputStream gStream = new GZIPOutputStream(pStream);
                this.reqWriter.write(gStream);
                pStream.close();
                pStream = null;
            }
            catch (IOException e) {
                throw new XmlRpcException("Failed to write request: " + e.getMessage(), e);
            }
            finally {
                if (pStream != null) {
                    try {
                        pStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    protected class ReqWriterImpl
    implements ReqWriter {
        private final XmlRpcRequest request;

        protected ReqWriterImpl(XmlRpcRequest pRequest) {
            this.request = pRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(OutputStream pStream) throws XmlRpcException, IOException, SAXException {
            XmlRpcStreamConfig config = (XmlRpcStreamConfig)((Object)this.request.getConfig());
            try {
                ContentHandler h = XmlRpcStreamTransport.this.getClient().getXmlWriterFactory().getXmlWriter(config, pStream);
                XmlRpcWriter xw = new XmlRpcWriter(config, h, XmlRpcStreamTransport.this.getClient().getTypeFactory());
                xw.write(this.request);
                pStream.close();
                pStream = null;
            }
            finally {
                if (pStream != null) {
                    try {
                        pStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    protected static interface ReqWriter {
        public void write(OutputStream var1) throws XmlRpcException, IOException, SAXException;
    }
}

