/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.style.PapyrusDiagramStyle;
import org.eclipse.papyrus.uml.export.extension.AdditionalInformations;
import org.eclipse.papyrus.uml.export.tree.Node;
import org.eclipse.uml2.uml.NamedElement;

public class UMLTreeFactory {
    private Map<String, AdditionalInformations> additionnalDatas = new HashMap<String, AdditionalInformations>();
    private Node tree = null;

    public UMLTreeFactory(Map<String, AdditionalInformations> additionnalDatas) {
        this.additionnalDatas = additionnalDatas;
    }

    public Node addDiagram(Diagram diagram) {
        List<NamedElement> pathToRoot = this.getPathToRoot(diagram);
        if (this.tree == null) {
            this.tree = this.createSubTree(pathToRoot, diagram);
        } else {
            Collections.reverse(pathToRoot);
            this.addElementToTree(this.tree, pathToRoot, diagram);
        }
        return this.tree;
    }

    private Node createSubTree(List<NamedElement> pathToRoot, Diagram diagram) {
        Node node = this.createNode(diagram);
        for (NamedElement namedElement : pathToRoot) {
            node = this.createNode(namedElement, node);
        }
        return node;
    }

    private Node addElementToTree(Node parentNode, List<NamedElement> namespaceList, Diagram diagram) {
        if (namespaceList.size() > 1) {
            NamedElement namedElement = namespaceList.get(1);
            namespaceList.remove(0);
            Node childbyName = parentNode.getChildbyName(namedElement.getName());
            if (childbyName != null) {
                this.addElementToTree(childbyName, namespaceList, diagram);
            } else {
                Node node = this.createNode(namedElement);
                parentNode.addChild(node);
                this.addElementToTree(node, namespaceList, diagram);
            }
        } else {
            Node diagramLeaf = this.createNode(diagram);
            parentNode.childs.add(diagramLeaf);
        }
        return parentNode;
    }

    public Map<String, AdditionalInformations> getAdditionnalDatas() {
        return this.additionnalDatas;
    }

    public void setAdditionnalDatas(Map<String, AdditionalInformations> additionnalDatas) {
        this.additionnalDatas = additionnalDatas;
    }

    public Node getTree() {
        return this.tree;
    }

    public void setTree(Node tree) {
        this.tree = tree;
    }

    public List<NamedElement> getPathToRoot(Diagram diagram) {
        ArrayList<NamedElement> namespaceList = new ArrayList<NamedElement>();
        for (Object object : diagram.getStyles()) {
            if (!(object instanceof PapyrusDiagramStyle)) continue;
            EObject owner = ((PapyrusDiagramStyle)object).getOwner();
            while (owner instanceof NamedElement) {
                NamedElement namedOwner = (NamedElement)owner;
                namespaceList.add(namedOwner);
                owner = namedOwner.getOwner();
            }
        }
        return namespaceList;
    }

    public Node createNode(Diagram diagram) {
        String name = diagram.getName();
        Node node = new Node(name, name);
        node.setAdditionalInformations(this.getAdditionalDatasFor(diagram));
        return node;
    }

    public Node createNode(NamedElement namedElement) {
        Node node = new Node(UMLTreeFactory.utilgetNamespace(namedElement), namedElement.getName());
        node.setAdditionalInformations(this.getAdditionalDatasFor(namedElement));
        return node;
    }

    public Node createNode(NamedElement namedElement, Node child) {
        Node node = new Node(UMLTreeFactory.utilgetNamespace(namedElement), namedElement.getName(), child);
        node.setAdditionalInformations(this.getAdditionalDatasFor(namedElement));
        return node;
    }

    private static String utilgetNamespace(NamedElement namedElement) {
        Object namespace = namedElement.getName();
        while (namedElement.getOwner() != null) {
            namespace = namedElement.getName() + (String)namespace;
            namedElement = (NamedElement)namedElement.getOwner();
        }
        return namespace;
    }

    public Map<String, String> getAdditionalDatasFor(Object object) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<String, AdditionalInformations> entry : this.additionnalDatas.entrySet()) {
            String data = entry.getValue().getData(object);
            if (data == null) continue;
            res.put(entry.getKey(), data);
        }
        return res;
    }
}

