/*****************************************************************************
 * Copyright (c) 2022, 2024. CEA LIST
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) <vincent.lorenzo@cea.fr> - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.junit.Assert;

/**
 * Abstract GraphicalNodeChecker for creation tests.
 */
public abstract class AbstractGraphicalNodeCreationChecker extends AbstractGraphicalCreationChecker {

	/**
	 * Constructor.
	 *
	 * @param diagram
	 *            the gmf diagram
	 * @param graphicalParent
	 *            the graphical parent
	 */
	public AbstractGraphicalNodeCreationChecker(final Diagram diagram, final EObject graphicalParent) {
		super(diagram, graphicalParent);
	}

	@Override
	public void validateRepresentationElement(DRepresentationElement createdElementRepresentation) {

		// check the parent of the created element is the expected one.
		Assert.assertEquals("Unexpected parent for created graphical element", //$NON-NLS-1$
				graphicalParent, createdElementRepresentation.eContainer());

		super.validateRepresentationElement(createdElementRepresentation);
	}

	/**
	 * Check the mapping of the created element
	 *
	 * @param createdElementRepresentation
	 *            the created {@link DRepresentationElement}
	 */
	@Override
	protected void checkCreatedElementMapping(final DRepresentationElement createdView) {
		Assert.assertEquals("Unexpected mapping.", getNodeMappingType(), createdView.getMapping().getName()); //$NON-NLS-1$
	}

	/**
	 *
	 * @return
	 *         the expected mapping type for the created node
	 */
	protected abstract String getNodeMappingType();
}