/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteFromModelHandler
extends AbstractHandler {
    public boolean isEnabled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IGraphicalEditPart> selection = this.getSelectedElements();
        for (IGraphicalEditPart selectedGEF : selection) {
            EObject current = selectedGEF.resolveSemanticElement();
            DestroyElementRequest request = new DestroyElementRequest(current, false);
            if (request == null) continue;
            Command cmd = this.getEMFEditCommand(current, (IEditCommandRequest)request);
            TransactionalEditingDomain domain = this.getEditingDomain(current);
            if (domain == null) continue;
            domain.getCommandStack().execute(cmd);
        }
        return selection;
    }

    protected final TransactionalEditingDomain getEditingDomain(EObject eobject) {
        return TransactionUtil.getEditingDomain((EObject)eobject);
    }

    protected final IElementEditService getCommandProvider(EObject eobject) {
        return ElementEditServiceUtils.getCommandProvider((EObject)eobject);
    }

    protected final ICommand getGMFEditCommand(EObject eobject, IEditCommandRequest request) {
        IElementEditService provider = this.getCommandProvider(eobject);
        ICommand cmd = provider.getEditCommand(request);
        return cmd;
    }

    protected final Command getEMFEditCommand(EObject eobject, IEditCommandRequest request) {
        ICommand cmd = this.getGMFEditCommand(eobject, request);
        return cmd == null ? null : GMFtoEMFCommandWrapper.wrap((ICommand)cmd);
    }

    protected List<IGraphicalEditPart> getSelectedElements() {
        ArrayList<IGraphicalEditPart> editparts = new ArrayList<IGraphicalEditPart>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            ISelection selection = activeWorkbenchWindow.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object object : structuredSelection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    editparts.add((IGraphicalEditPart)object);
                }
            } else if (selection instanceof IGraphicalEditPart) {
                editparts.add((IGraphicalEditPart)selection);
            }
        }
        return editparts;
    }
}

