/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsLockHelper;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByComparator;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModelListener;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByTreeFormat;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.IGroupByComparator;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.IGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.IActivatableFilterStrategy;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.summaryrow.command.CalculateSummaryRowValuesCommand;
import org.eclipse.nebula.widgets.nattable.util.CalculatedValueCache;
import org.eclipse.nebula.widgets.nattable.util.ICalculatedValueCache;
import org.eclipse.nebula.widgets.nattable.util.ICalculatedValueCacheKey;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class GroupByDataLayer<T>
extends DataLayer
implements Observer,
GroupByModelListener {
    public static final String GROUP_BY_OBJECT = "GROUP_BY_OBJECT";
    public static final String GROUP_BY_COLUMN_PREFIX = "GROUP_BY_COLUMN_";
    public static final String GROUP_BY_SUMMARY = "GROUP_BY_SUMMARY";
    public static final String GROUP_BY_SUMMARY_COLUMN_PREFIX = "GROUP_BY_SUMMARY_COLUMN_";
    private final GroupByModel groupByModel;
    private final EventList<T> eventList;
    private final GlazedListTreeData<Object> treeData;
    private final GlazedListTreeRowModel<Object> treeRowModel;
    private final TreeList<Object> treeList;
    private final GroupByColumnAccessor<T> groupByColumnAccessor;
    private final IColumnAccessor<T> columnAccessor;
    private final GroupByTreeFormat<T> treeFormat;
    private final IConfigRegistry configRegistry;
    private ICalculatedValueCache valueCache;
    private final Map<GroupByObject, List<T>> itemsByGroup = new ConcurrentHashMap<GroupByObject, List<T>>();
    private GroupByExpansionModel groupByExpansionModel;
    private Matcher<Object> groupByMatcher = item -> item instanceof GroupByObject;
    private FilterRowDataProvider<T> filterRowDataProvider;

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor) {
        this(groupByModel, eventList, columnAccessor, null, true);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, boolean useDefaultConfiguration) {
        this(groupByModel, eventList, columnAccessor, null, useDefaultConfiguration);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        this(groupByModel, eventList, columnAccessor, configRegistry, true);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        this(groupByModel, eventList, columnAccessor, configRegistry, true, useDefaultConfiguration);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry, boolean smoothUpdates, boolean useDefaultConfiguration) {
        this(groupByModel, eventList, columnAccessor, null, configRegistry, smoothUpdates, useDefaultConfiguration);
    }

    public GroupByDataLayer(GroupByModel groupByModel, EventList<T> eventList, IColumnAccessor<T> columnAccessor, TreeList.ExpansionModel<Object> expansionModel, IConfigRegistry configRegistry, boolean smoothUpdates, boolean useDefaultConfiguration) {
        this.eventList = eventList;
        this.columnAccessor = columnAccessor;
        this.groupByModel = groupByModel;
        this.groupByModel.addGroupByModelListener(this);
        this.groupByColumnAccessor = new GroupByColumnAccessor<T>(columnAccessor);
        this.treeFormat = this.createGroupByTreeFormat(groupByModel, this.groupByColumnAccessor);
        this.treeFormat.setComparator(new GroupByComparator<T>(groupByModel, columnAccessor, this));
        if (expansionModel == null) {
            this.groupByExpansionModel = new GroupByExpansionModel();
            this.treeList = new TreeList(eventList, this.treeFormat, (TreeList.ExpansionModel)this.groupByExpansionModel);
        } else {
            this.treeList = new TreeList(eventList, this.treeFormat, expansionModel);
        }
        this.treeData = new GlazedListTreeData<Object>(this.treeList);
        this.treeRowModel = new GlazedListTreeRowModel<Object>(this.treeData);
        this.configRegistry = configRegistry;
        this.valueCache = new CalculatedValueCache((ILayer)this, true, false, smoothUpdates);
        this.setDataProvider((IDataProvider)new ListDataProvider(this.treeList, this.groupByColumnAccessor));
        if (useDefaultConfiguration) {
            this.addConfiguration((IConfiguration)new GroupByDataLayerConfiguration(this));
        }
    }

    protected GroupByTreeFormat<T> createGroupByTreeFormat(GroupByModel groupByModel, IColumnAccessor<T> groupByColumnAccessor) {
        return new GroupByTreeFormat<T>(groupByModel, groupByColumnAccessor);
    }

    public void initializeTreeComparator(ISortModel sortModel, IUniqueIndexLayer treeLayer, boolean setDataLayerReference) {
        this.treeFormat.setSortModel(sortModel);
        this.treeFormat.setTreeLayer(treeLayer);
        this.treeFormat.setDataLayer(setDataLayerReference ? this : null);
    }

    public void enableFilterSupport(FilterRowDataProvider<T> provider) {
        this.filterRowDataProvider = provider;
    }

    public void setComparator(IGroupByComparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("IGroupByComparator can not be null");
        }
        this.treeFormat.setComparator(comparator);
    }

    public ISortModel getSortModel() {
        return this.treeFormat.getSortModel();
    }

    protected void updateTree() {
        BusyIndicator.showWhile((Display)Display.getDefault(), () -> GlazedListsLockHelper.performWriteOperation(this.eventList.getReadWriteLock(), () -> {
            EventList temp = GlazedLists.eventList(this.eventList);
            this.eventList.clear();
            this.eventList.addAll((Collection)temp);
            if (this.groupByExpansionModel != null) {
                FilterList groupByObjects = new FilterList(this.treeList, this.groupByMatcher);
                this.groupByExpansionModel.cleanupCollapsed((Collection<Object>)groupByObjects);
            }
        }));
    }

    @Override
    public void update(Observable o, Object arg) {
        this.handleGroupByModelChange(this.groupByModel);
    }

    @Override
    public void handleGroupByModelChange(GroupByModel groupByModel) {
        BusyIndicator.showWhile((Display)Display.getDefault(), () -> {
            Map original;
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            indexes.addAll(this.groupByModel.getGroupByColumnIndexes());
            this.groupByModel.getGroupByColumnIndexes().clear();
            List sortedIndexes = Collections.emptyList();
            ArrayList<SortDirectionEnum> sortDirections = new ArrayList<SortDirectionEnum>();
            if (this.treeFormat.getSortModel() != null) {
                sortedIndexes = this.treeFormat.getSortModel().getSortedColumnIndexes();
                for (Integer index : sortedIndexes) {
                    sortDirections.add(this.treeFormat.getSortModel().getSortDirection(index.intValue()));
                }
                this.treeFormat.getSortModel().clear();
            }
            Map filterCopy = Collections.emptyMap();
            if (this.filterRowDataProvider != null) {
                if (this.filterRowDataProvider.getFilterStrategy() instanceof IActivatableFilterStrategy) {
                    ((IActivatableFilterStrategy)this.filterRowDataProvider.getFilterStrategy()).deactivateFilterStrategy();
                }
                original = this.filterRowDataProvider.getFilterIndexToObjectMap();
                filterCopy = new HashMap(original);
                original.clear();
                this.filterRowDataProvider.getFilterStrategy().applyFilter(original);
            }
            this.groupByModel.getGroupByColumnIndexes().addAll(indexes);
            this.updateTree();
            if (this.filterRowDataProvider != null) {
                if (this.filterRowDataProvider.getFilterStrategy() instanceof IActivatableFilterStrategy) {
                    ((IActivatableFilterStrategy)this.filterRowDataProvider.getFilterStrategy()).activateFilterStrategy();
                }
                original = this.filterRowDataProvider.getFilterIndexToObjectMap();
                original.putAll(filterCopy);
                this.filterRowDataProvider.getFilterStrategy().applyFilter(original);
            }
            if (this.treeFormat.getSortModel() != null) {
                int i = 0;
                while (i < sortedIndexes.size()) {
                    Integer index = (Integer)sortedIndexes.get(i);
                    this.treeFormat.getSortModel().sort(index.intValue(), (SortDirectionEnum)sortDirections.get(i), true);
                    ++i;
                }
            }
        });
        this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent((ILayer)this));
    }

    public GlazedListTreeRowModel<Object> getTreeRowModel() {
        return this.treeRowModel;
    }

    public TreeList<Object> getTreeList() {
        return this.treeList;
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        if (this.treeData.getDataAtIndex(this.getRowIndexByPosition(rowPosition)) instanceof GroupByObject) {
            LabelStack configLabels = new LabelStack(new String[0]);
            configLabels.addLabel(GROUP_BY_COLUMN_PREFIX + columnPosition);
            configLabels.addLabel(GROUP_BY_OBJECT);
            if (this.getConfigLabelAccumulator() != null) {
                this.getConfigLabelAccumulator().accumulateConfigLabels(configLabels, columnPosition, rowPosition);
            }
            if (this.getRegionName() != null) {
                configLabels.addLabel(this.getRegionName());
            }
            if (this.getGroupBySummaryProvider(configLabels) != null) {
                configLabels.addLabelOnTop(GROUP_BY_SUMMARY);
                configLabels.addLabelOnTop(GROUP_BY_SUMMARY_COLUMN_PREFIX + columnPosition);
            }
            return configLabels;
        }
        return super.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    public Collection<String> getProvidedLabels() {
        Collection labels = super.getProvidedLabels();
        labels.add(GROUP_BY_OBJECT);
        labels.add(GROUP_BY_SUMMARY);
        int i = 0;
        while (i < this.getColumnCount()) {
            labels.add(GROUP_BY_COLUMN_PREFIX + i);
            labels.add(GROUP_BY_SUMMARY_COLUMN_PREFIX + i);
            ++i;
        }
        return labels;
    }

    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        LabelStack labelStack = this.getConfigLabelsByPosition(columnPosition, rowPosition);
        return this.getDataValueByPosition(columnPosition, rowPosition, labelStack, true);
    }

    public Object getDataValueByPosition(int columnPosition, int rowPosition, LabelStack labelStack, boolean calculateInBackground) {
        if (labelStack.hasLabel(GROUP_BY_OBJECT)) {
            GroupByObject groupByObject = (GroupByObject)this.treeData.getDataAtIndex(rowPosition);
            IGroupBySummaryProvider summaryProvider = this.getGroupBySummaryProvider(labelStack);
            if (summaryProvider != null) {
                List children = this.getItemsInGroup(groupByObject);
                return this.valueCache.getCalculatedValue(columnPosition, rowPosition, (ICalculatedValueCacheKey)new GroupByValueCacheKey(columnPosition, rowPosition, groupByObject), calculateInBackground, () -> summaryProvider.summarize(columnPosition, children));
            }
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    public IGroupBySummaryProvider<T> getGroupBySummaryProvider(LabelStack labelStack) {
        if (this.configRegistry != null) {
            return (IGroupBySummaryProvider)this.configRegistry.getConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, DisplayMode.NORMAL, (List)labelStack);
        }
        return null;
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IVisualChangeEvent) {
            this.clearCache();
        }
        super.handleLayerEvent(event);
    }

    public void clearCache() {
        this.valueCache.clearCache();
        this.treeFormat.clearComparatorCache();
        this.itemsByGroup.clear();
    }

    public void killCache() {
        this.valueCache.killCache();
        this.treeFormat.clearComparatorCache();
        this.itemsByGroup.clear();
    }

    public boolean doCommand(ILayerCommand command) {
        if (command instanceof CalculateSummaryRowValuesCommand) {
            int i = 0;
            while (i < this.getRowCount()) {
                if (this.treeData.getDataAtIndex(i) instanceof GroupByObject) {
                    int j = 0;
                    while (j < this.getColumnCount()) {
                        LabelStack labelStack = this.getConfigLabelsByPosition(j, i);
                        IGroupBySummaryProvider summaryProvider = this.getGroupBySummaryProvider(labelStack);
                        if (summaryProvider != null) {
                            GroupByObject groupByObject = (GroupByObject)this.treeData.getDataAtIndex(i);
                            List children = this.getItemsInGroup(groupByObject);
                            int col = j;
                            this.valueCache.getCalculatedValue(j, i, (ICalculatedValueCacheKey)new GroupByValueCacheKey(j, i, groupByObject), false, () -> summaryProvider.summarize(col, children));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else if (command instanceof DisposeResourcesCommand) {
            this.treeFormat.clearComparatorCache();
            this.valueCache.killCache();
            this.valueCache.dispose();
        }
        return super.doCommand(command);
    }

    public ICalculatedValueCache getValueCache() {
        return this.valueCache;
    }

    public void setValueCache(ICalculatedValueCache valueCache) {
        this.valueCache = valueCache;
    }

    public List<T> getItemsInGroup(GroupByObject group) {
        return this.itemsByGroup.computeIfAbsent(group, g -> {
            this.eventList.getReadWriteLock().readLock().lock();
            try {
                FilterList filterList = new FilterList(this.eventList, this.getGroupDescriptorMatcher((GroupByObject)g, this.columnAccessor));
                ArrayList arrayList = new ArrayList(filterList);
                return arrayList;
            }
            finally {
                this.eventList.getReadWriteLock().readLock().unlock();
            }
        });
    }

    protected Matcher<T> getGroupDescriptorMatcher(GroupByObject group, IColumnAccessor<T> columnAccessor) {
        return new GroupDescriptorMatcher<T>(group, columnAccessor);
    }

    private class GroupByExpansionModel
    implements TreeList.ExpansionModel<Object> {
        Set<Object> collapsed = new HashSet<Object>();

        private GroupByExpansionModel() {
        }

        public boolean isExpanded(Object element, List<Object> path) {
            return !this.collapsed.contains(element);
        }

        public void setExpanded(Object element, List<Object> path, boolean expanded) {
            if (!expanded) {
                this.collapsed.add(element);
            } else {
                this.collapsed.remove(element);
            }
        }

        public void cleanupCollapsed(Collection<Object> groupByObjects) {
            this.collapsed.retainAll(groupByObjects);
        }
    }

    class GroupByValueCacheKey
    implements ICalculatedValueCacheKey {
        private final int columnPosition;
        private final int rowPosition;
        private final GroupByObject groupBy;

        public GroupByValueCacheKey(int columnPosition, int rowPosition, GroupByObject groupBy) {
            this.columnPosition = columnPosition;
            this.rowPosition = rowPosition;
            this.groupBy = groupBy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.columnPosition;
            result = 31 * result + (this.groupBy == null ? 0 : this.groupBy.hashCode());
            result = 31 * result + this.rowPosition;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupByValueCacheKey other = (GroupByValueCacheKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.columnPosition != other.columnPosition) {
                return false;
            }
            if (this.groupBy == null ? other.groupBy != null : !this.groupBy.equals(other.groupBy)) {
                return false;
            }
            return this.rowPosition == other.rowPosition;
        }

        private GroupByDataLayer<T> getOuterType() {
            return GroupByDataLayer.this;
        }
    }

    public static class GroupDescriptorMatcher<T>
    implements Matcher<T> {
        private final GroupByObject group;
        private final IColumnAccessor<T> columnAccessor;

        public GroupDescriptorMatcher(GroupByObject group, IColumnAccessor<T> columnAccessor) {
            this.group = group;
            this.columnAccessor = columnAccessor;
        }

        public boolean matches(T element) {
            for (Map.Entry<Integer, Object> desc : this.group.getDescriptor().entrySet()) {
                int columnIndex = desc.getKey();
                Object groupName = desc.getValue();
                if (this.equals(groupName, this.columnAccessor.getDataValue(element, columnIndex))) continue;
                return false;
            }
            return true;
        }

        private boolean equals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }
}

