/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingInvocationHandler;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservableCollection;
import org.eclipse.papyrus.infra.tools.databinding.IDelegatingObservable;

public class DelegatingObservableList
extends DelegatingObservableCollection<IObservableList>
implements IObservableList {
    private static final Object LIST_EVENT_TYPE = new Object();
    private IListChangeListener forwardingListChangeListener;

    DelegatingObservableList(IObservableList delegate) {
        super(delegate, IObservableList.class);
    }

    DelegatingObservableList(Realm realm) {
        super(realm, IObservableList.class);
    }

    public static IObservableList wrap(IObservableList observable) {
        IObservableList result;
        if (observable instanceof IDelegatingObservable) {
            try {
                result = (IObservableList)observable.getClass().getDeclaredConstructor(IObservableList.class).newInstance(observable);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("observable is an invalid implementation of IDelegatingObservable", e);
            }
        } else {
            result = DelegatingInvocationHandler.wrap(new DelegatingObservableList(observable), IObservableList.class);
        }
        return result;
    }

    public static IObservableList create(Realm realm, ClassLoader loader, Class<?> ... mixins) {
        return DelegatingInvocationHandler.wrap(new DelegatingObservableList(realm), IObservableList.class, loader, mixins);
    }

    public void addListChangeListener(IListChangeListener listener) {
        this.addListener(LIST_EVENT_TYPE, (IObservablesListener)listener);
    }

    public void removeListChangeListener(IListChangeListener listener) {
        this.removeListener(LIST_EVENT_TYPE, (IObservablesListener)listener);
    }

    @Override
    protected void hookDelegate(IObservableList delegate) {
        super.hookDelegate(delegate);
        delegate.addListChangeListener(this.getForwardingListChangeListener());
    }

    @Override
    protected void unhookDelegate(IObservableList delegate) {
        delegate.removeListChangeListener(this.getForwardingListChangeListener());
        super.unhookDelegate(delegate);
    }

    @Override
    protected void delegateChanged(IObservableList oldDelegate, IObservableList newDelegate) {
        super.delegateChanged(oldDelegate, newDelegate);
        List oldList = oldDelegate == null || oldDelegate.isDisposed() ? Collections.EMPTY_LIST : oldDelegate;
        List newList = newDelegate == null ? Collections.EMPTY_LIST : newDelegate;
        this.fireEvent((ObservableEvent)new MyListChangeEvent(Diffs.computeListDiff((List)oldList, (List)newList)));
    }

    public void add(int index, Object element) {
        if (this.getDelegate() == null) {
            throw new IndexOutOfBoundsException();
        }
        ((IObservableList)this.getDelegate()).add(index, element);
    }

    public boolean addAll(int index, Collection c) {
        if (this.getDelegate() == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((IObservableList)this.getDelegate()).addAll(index, c);
    }

    public Object get(int index) {
        this.getterCalled();
        if (this.getDelegate() == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((IObservableList)this.getDelegate()).get(index);
    }

    public Object set(int index, Object element) {
        if (this.getDelegate() == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((IObservableList)this.getDelegate()).set(index, element);
    }

    public Object move(int oldIndex, int newIndex) {
        if (this.getDelegate() == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((IObservableList)this.getDelegate()).move(oldIndex, newIndex);
    }

    public Object remove(int index) {
        return this.getDelegate() == null ? Collections.EMPTY_LIST.remove(index) : ((IObservableList)this.getDelegate()).remove(index);
    }

    public int indexOf(Object o) {
        this.getterCalled();
        return this.getDelegate() == null ? -1 : ((IObservableList)this.getDelegate()).indexOf(o);
    }

    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.getDelegate() == null ? -1 : ((IObservableList)this.getDelegate()).lastIndexOf(o);
    }

    public ListIterator listIterator() {
        this.getterCalled();
        return this.getDelegate() == null ? Collections.EMPTY_LIST.listIterator() : ((IObservableList)this.getDelegate()).listIterator();
    }

    public ListIterator listIterator(int index) {
        this.getterCalled();
        return this.getDelegate() == null ? Collections.EMPTY_LIST.listIterator(index) : ((IObservableList)this.getDelegate()).listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        this.getterCalled();
        return this.getDelegate() == null ? Collections.EMPTY_LIST.subList(fromIndex, toIndex) : ((IObservableList)this.getDelegate()).subList(fromIndex, toIndex);
    }

    private IListChangeListener getForwardingListChangeListener() {
        if (this.forwardingListChangeListener == null) {
            this.forwardingListChangeListener = new IListChangeListener(){

                public void handleListChange(ListChangeEvent event) {
                    MyListChangeEvent myEvent = new MyListChangeEvent(event.diff);
                    DelegatingObservableList.this.fireEvent((ObservableEvent)myEvent);
                }
            };
        }
        return this.forwardingListChangeListener;
    }

    class MyListChangeEvent
    extends ListChangeEvent {
        private static final long serialVersionUID = 1L;

        MyListChangeEvent(ListDiff diff) {
            super((IObservableList)DelegatingObservableList.this.getRealObservable(), diff);
        }

        protected Object getListenerType() {
            return LIST_EVENT_TYPE;
        }
    }
}

