/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertyHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        if (request.getElementToDestroy() instanceof Property) {
            ArrayList<Association> dependents = new ArrayList<Association>();
            EReference[] refs = null;
            Property propertyToDelete = (Property)request.getElementToDestroy();
            refs = new EReference[]{UMLPackage.eINSTANCE.getConnectorEnd_Role(), UMLPackage.eINSTANCE.getConnectorEnd_PartWithPort()};
            Collection connectorEndRefs = EMFCoreUtil.getReferencers((EObject)propertyToDelete, (EReference[])refs);
            dependents.addAll(connectorEndRefs);
            refs = new EReference[]{UMLPackage.eINSTANCE.getAssociation_MemberEnd()};
            Collection associationRefs = EMFCoreUtil.getReferencers((EObject)propertyToDelete, (EReference[])refs);
            for (Association association : associationRefs) {
                ArrayList remainingMembers = new ArrayList();
                remainingMembers.addAll(association.getMemberEnds());
                remainingMembers.removeAll(request.getDependentElementsToDestroy());
                if (remainingMembers.size() > 2) continue;
                dependents.add(association);
            }
            if (!dependents.isEmpty()) {
                return request.getDestroyDependentsCommand(dependents);
            }
        }
        return null;
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        IElementEditService provider;
        Property propertyToEdit;
        Association relatedAssociation;
        ICommand gmfCommand = super.getBeforeSetCommand(request);
        EObject elementToEdit = request.getElementToEdit();
        if (elementToEdit instanceof Property && !(elementToEdit instanceof Port) && request.getFeature() == UMLPackage.eINSTANCE.getProperty_Aggregation() && request.getValue() != AggregationKind.NONE_LITERAL && (relatedAssociation = (propertyToEdit = (Property)elementToEdit).getAssociation()) != null) {
            HashSet members = new HashSet();
            members.addAll(relatedAssociation.getMemberEnds());
            members.remove(propertyToEdit);
            for (Property member : members) {
                if (member.getAggregation() == AggregationKind.NONE_LITERAL) continue;
                SetRequest setRequest = new SetRequest((EObject)member, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_Aggregation(), (Object)AggregationKind.NONE_LITERAL);
                SetValueCommand setAggregationCommand = new SetValueCommand(setRequest);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)setAggregationCommand);
            }
        }
        if (elementToEdit instanceof Property && !(elementToEdit instanceof Port) && request.getFeature() == UMLPackage.eINSTANCE.getTypedElement_Type() && request.getValue() == null && (relatedAssociation = (propertyToEdit = (Property)elementToEdit).getAssociation()) != null && (provider = ElementEditServiceUtils.getCommandProvider((EObject)relatedAssociation)) != null) {
            DestroyElementRequest destroyRequest = new DestroyElementRequest((EObject)relatedAssociation, false);
            ArrayList<Property> ps = new ArrayList<Property>();
            ps.add(propertyToEdit);
            destroyRequest.setParameter("DEPENDENTS_TO_KEEP", ps);
            ICommand destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
            gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)destroyCommand);
        }
        if (elementToEdit instanceof Property && !(elementToEdit instanceof Port) && request.getFeature() == UMLPackage.eINSTANCE.getTypedElement_Type() && request.getValue() instanceof Type) {
            Association relatedAssociation2;
            propertyToEdit = (Property)elementToEdit;
            EReference[] refs = new EReference[]{UMLPackage.eINSTANCE.getConnectorEnd_PartWithPort()};
            Collection referencers = EMFCoreUtil.getReferencers((EObject)propertyToEdit, (EReference[])refs);
            IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((EObject)propertyToEdit);
            if (provider2 != null) {
                for (ConnectorEnd end : referencers) {
                    Type newType = (Type)request.getValue();
                    ConnectableElement cElt = end.getRole();
                    if (newType != null && newType instanceof EncapsulatedClassifier && cElt != null && cElt instanceof Port) {
                        Port role = (Port)cElt;
                        EncapsulatedClassifier composite = (EncapsulatedClassifier)newType;
                        if (composite.getAllAttributes().contains((Object)role)) continue;
                    }
                    DestroyElementRequest req = new DestroyElementRequest((EObject)end, false);
                    ICommand deleteCommand = provider2.getEditCommand((IEditCommandRequest)req);
                    gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)deleteCommand);
                }
            }
            if ((relatedAssociation2 = propertyToEdit.getAssociation()) == null || !ElementUtil.hasNature((Element)relatedAssociation2, "UML_Nature")) {
                return gmfCommand;
            }
            if (request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") == null) {
                HashSet<View> viewsToDestroy = new HashSet<View>();
                viewsToDestroy.addAll(this.getViewsToDestroy(relatedAssociation2));
                if (!viewsToDestroy.isEmpty()) {
                    DestroyDependentsRequest ddr = new DestroyDependentsRequest(request.getEditingDomain(), (EObject)relatedAssociation2, false);
                    ddr.setClientContext(request.getClientContext());
                    ddr.addParameters(request.getParameters());
                    ICommand destroyViewsCommand = ddr.getDestroyDependentsCommand(viewsToDestroy);
                    gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)destroyViewsCommand);
                }
                if (gmfCommand != null) {
                    gmfCommand.reduce();
                }
            }
        }
        if (gmfCommand != null) {
            gmfCommand = gmfCommand.reduce();
        }
        return gmfCommand;
    }

    public void configureRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            this.configureCreateElementRequest((CreateElementRequest)request);
        } else {
            super.configureRequest(request);
        }
    }

    protected void configureCreateElementRequest(CreateElementRequest request) {
        if (request.getContainmentFeature() == null && UMLPackage.Literals.VALUE_SPECIFICATION.isSuperTypeOf(request.getElementType().getEClass())) {
            request.setContainmentFeature(UMLPackage.Literals.PROPERTY__DEFAULT_VALUE);
        }
    }

    private HashSet<View> getViewsToDestroy(Association association) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        EReference[] refs = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
        Collection associationViews = EMFCoreUtil.getReferencers((EObject)association, (EReference[])refs);
        viewsToDestroy.addAll(associationViews);
        return viewsToDestroy;
    }

    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        ICommand gmfCommand = super.getBeforeMoveCommand(request);
        for (Object movedObject : request.getElementsToMove().keySet()) {
            if (!(movedObject instanceof Property) || !(((Property)movedObject).eContainer() instanceof Association)) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return gmfCommand;
    }
}

