/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.advices.values;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.types.Activator;
import org.eclipse.papyrus.infra.emf.types.advices.values.FeatureToSet;
import org.eclipse.papyrus.infra.emf.types.advices.values.FeatureValue;
import org.eclipse.papyrus.infra.emf.types.advices.values.FeatureValueUtils;
import org.eclipse.papyrus.infra.emf.types.advices.values.SetValuesAdviceConfiguration;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class SetValuesAdviceEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected Map<String, FeatureValue> featuresToStaticDefinitions = new HashMap<String, FeatureValue>();

    public SetValuesAdviceEditHelperAdvice(SetValuesAdviceConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        for (FeatureToSet featureToSet : configuration.getFeaturesToSet()) {
            this.featuresToStaticDefinitions.put(featureToSet.getFeatureName(), featureToSet.getValue());
        }
    }

    public boolean approveRequest(IEditCommandRequest request) {
        return super.approveRequest(request);
    }

    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        return super.getBeforeCreateCommand(request);
    }

    protected ICommand getAfterCreateCommand(CreateElementRequest request) {
        return super.getAfterCreateCommand(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return super.getBeforeConfigureCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        ICommand resultCommand = null;
        EObject elementToConfigure = request.getElementToConfigure();
        if (elementToConfigure == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)elementToConfigure);
        if (service == null) {
            Activator.log.error("Impossible to get edit service from element: " + String.valueOf(elementToConfigure), null);
            return null;
        }
        for (Map.Entry<String, FeatureValue> featureEntry : this.featuresToStaticDefinitions.entrySet()) {
            ICommand command = this.getSetFeatureValueCommand(elementToConfigure, featureEntry.getKey(), featureEntry.getValue(), service, request);
            if (command == null) continue;
            resultCommand = resultCommand == null ? command : resultCommand.compose((IUndoableOperation)command);
        }
        if (resultCommand != null) {
            return resultCommand.reduce();
        }
        return super.getAfterConfigureCommand(request);
    }

    protected ICommand getSetFeatureValueCommand(EObject elementToConfigure, String name, FeatureValue featureValue, IElementEditService service, ConfigureRequest configureRequest) {
        if (name == null) {
            Activator.log.debug("No feature name has been set.");
            return null;
        }
        if (elementToConfigure.eClass() == null) {
            Activator.log.error("Impossible to find EClass from EObject: " + String.valueOf(elementToConfigure), null);
            return null;
        }
        EStructuralFeature feature = elementToConfigure.eClass().getEStructuralFeature(name);
        if (feature == null) {
            Activator.log.error("Impossible to find feature " + name + " for eobject " + String.valueOf(elementToConfigure), null);
            return null;
        }
        Object value = FeatureValueUtils.getValue(elementToConfigure, feature, featureValue);
        SetRequest request = new SetRequest(elementToConfigure, feature, value);
        request.addParameters(configureRequest.getParameters());
        return service.getEditCommand((IEditCommandRequest)request);
    }
}

