/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.source;

import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CodeGenTagCompletionProposal implements IJavaCompletionProposal,
		ICompletionProposalExtension2, ICompletionProposalExtension3 {

	private final CompletionContext context;

	private final Image image;

	private final String displayString;

	private final String replaceText;

	private final String additionalProposalInfo;

	public CodeGenTagCompletionProposal(CompletionContext context, Image image,
			String displayString, String replaceText,
			String additionalProposalInfo) {
		this.context = context;
		this.image = image;
		this.replaceText = replaceText;
		this.displayString = displayString;
		this.additionalProposalInfo = additionalProposalInfo;
	}

	public int getRelevance() {
		return 0;
	}

	public void apply(IDocument document) {
	}

	public String getAdditionalProposalInfo() {
		return additionalProposalInfo;
	}

	public IContextInformation getContextInformation() {
		return null;
	}

	public String getDisplayString() {
		return displayString;
	}

	public Image getImage() {
		return image;
	}

	public Point getSelection(IDocument document) {
		return null;
	}

	public void apply(ITextViewer viewer, char trigger, int stateMask,
			int offset) {
		try {
			IDocument doc = viewer.getDocument();
			int start = context.getTokenStart();
			doc.replace(start, offset - start, replaceText);
		} catch (BadLocationException e) {
			MintUI.getDefault().logError(null, e);
		}
	}

	public void selected(ITextViewer viewer, boolean smartToggle) {
	}

	public void unselected(ITextViewer viewer) {
	}

	public boolean validate(IDocument document, int offset, DocumentEvent event) {
		try {
			int start = context.getTokenStart();
			int length = offset - start;
			String prefix = document.get(start, length);
			return replaceText.startsWith(prefix);
		} catch (BadLocationException e) {
			// ignore
		}

		return false;
	}

	public IInformationControlCreator getInformationControlCreator() {
		return null;
	}

	public int getPrefixCompletionStart(IDocument document, int completionOffset) {
		return context.getTokenStart();
	}

	public CharSequence getPrefixCompletionText(IDocument document,
			int completionOffset) {
		if (validate(document, completionOffset, null))
			return replaceText;

		return null;
	}
}
