/*******************************************************************************
 * Copyright (c) 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.examples.ext.genmodel;

import java.util.LinkedList;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelSwitch;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.IItemJavaElementSourceContributor;
import org.eclipse.ui.services.IDisposable;

public class ValidatorJavaElementSourceContributor implements
		IItemJavaElementSourceContributor, IChangeNotifier, IDisposable {

	private static final boolean DISABLE = "false".equals(System
			.getProperty("org.eclipse.emf.examples.generator.validator"));

	protected final GenModelSwitch<Adapter> modelSwitch = new GenModelSwitch<Adapter>() {

		@Override
		public Adapter caseGenModel(GenModel object) {
			return createGenModelAdapter();
		}

		@Override
		public Adapter caseGenClass(GenClass object) {
			return createGenClassAdapter();
		}

		@Override
		public Adapter caseGenFeature(GenFeature object) {
			return createGenFeatureAdapter();
		}
	};

	protected final LinkedList<IDisposable> adapters = new LinkedList<IDisposable>();

	protected final IChangeNotifier changeNotifier = new LightweightChangeNotifier();

	protected Adapter createAdapter(Notifier target) {
		Adapter adapter = modelSwitch.doSwitch((EObject) target);
		if (adapter != null)
			target.eAdapters().add(adapter);

		return adapter;
	}

	protected Adapter createGenModelAdapter() {
		Adapter adapter = new GenModelItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenClassAdapter() {
		Adapter adapter = new GenClassItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenFeatureAdapter() {
		Adapter adapter = new GenFeatureItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	public IItemJavaElementSource getItemJavaElementSource(Object object) {
		if (DISABLE)
			return null;

		if (object instanceof Notifier)
			return (IItemJavaElementSource) createAdapter((Notifier) object);

		return null;
	}

	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);
	}

	public void dispose() {
		for (IDisposable adapter : adapters)
			adapter.dispose();
	}

	private static class LightweightChangeNotifier implements IChangeNotifier {

		private INotifyChangedListener listener;

		private ChangeNotifier changeNotifier;

		public void addListener(INotifyChangedListener notifyChangedListener) {
			if (listener == null)
				listener = notifyChangedListener;
			else {
				if (changeNotifier == null)
					changeNotifier = new ChangeNotifier();

				changeNotifier.addListener(notifyChangedListener);
			}
		}

		public void removeListener(INotifyChangedListener notifyChangedListener) {
			if (changeNotifier == null) {
				if (listener == notifyChangedListener)
					listener = null;
			} else {
				changeNotifier.removeListener(notifyChangedListener);
				if (changeNotifier.isEmpty())
					changeNotifier = null;
			}
		}

		public void fireNotifyChanged(Notification notification) {
			if (listener != null)
				listener.notifyChanged(notification);

			if (changeNotifier != null)
				changeNotifier.fireNotifyChanged(notification);
		}
	}
}
