/*******************************************************************************
 * Copyright (c) 2008, 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;

/**
 * Interface for describing a particular Java code facet of a given model
 * element. Descriptors applicable to a particular model element are obtained by
 * calling {@link IItemJavaElementSource#getJavaElementDescriptors(Object)}.
 * 
 * <p>
 * Clients may implement this interface.
 * </p>
 */
public interface IItemJavaElementDescriptor {

	/**
	 * Descriptor kind.
	 */
	enum Kind {
		
		/**
		 * Descriptor represents a {@link IJavaElement}.
		 * @see IItemJavaElementDescriptor#getJavaElement(Object)
		 */
		JAVA_ELEMENT,
		
		/**
		 * Descriptor represents a {@link IJavaTypeReference}.
		 * @see IItemJavaElementDescriptor#getJavaTypeReference(Object)
		 */
		JAVA_TYPE_REFERENCE,
		
		/**
		 * Descriptor represents a non-Java element (e.g., a {@link IResource}).
		 * @see IItemJavaElementDescriptor#getNonJavaElement(Object)
		 */
		NON_JAVA_RESOURCE
	}
	
	/**
	 * Returns this descriptor's kind for the given model element.
	 * 
	 * @param object model element
	 * @return descriptor kind
	 */
	Kind getKind(Object object);
	
	/**
	 * Returns a specific Java element for the given model element.
	 * 
	 * @param object
	 *            model element
	 * @return Java element for the given model element
	 * @see Kind#JAVA_ELEMENT
	 */
	IJavaElement getJavaElement(Object object);

	/**
	 * Returns an unresolved Java element reference for the given model element.
	 * 
	 * @param object
	 *            model element
	 * @return Java element reference
	 * @see Kind#JAVA_TYPE_REFERENCE
	 */
	IJavaTypeReference getJavaTypeReference(Object object);
	
	/**
	 * Returns the non-Java element for the given model element.
	 * 
	 * @param object model element
	 * @return non-Java element for the given model element
	 * @see Kind#NON_JAVA_RESOURCE
	 */
	Object getNonJavaElement(Object object);

	/**
	 * Returns an optional category used for grouping descriptors.
	 * 
	 * @param object
	 *            model element
	 * @return category used for grouping descriptors (may be {@code null})
	 */
	String getCategory(Object object);

	/**
	 * Returns an optional description of the Java code facet that this
	 * descriptor represents.
	 * 
	 * @param object
	 *            model element
	 * @return Java element description (i.e., how it relates to the model
	 *         element)F
	 */
	String getDescription(Object object);

	/**
	 * Returns a display name for the Java element that this descriptor
	 * represents for the given model element.
	 * 
	 * @param object
	 *            model element
	 * @return Java element's display name (i.e., what it represents for the
	 *         given model element)
	 */
	String getDisplayName(Object object);

	/**
	 * Returns an optional related feature that this descriptor represents.
	 * 
	 * @param object
	 *            model element
	 * @return feature related to this descriptor (may be {@code null})
	 */
	Object getFeature(Object object);
}
