/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.util.Collection;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.ValidationRollbackTest;
import org.eclipse.emf.transaction.tests.fixtures.TestCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.transaction.util.ValidateEditSupport;

public class ValidateEditTest
extends AbstractTest {
    private static final String newTitle = "New Title";
    private Book book;
    private final Command setTitle = new TestCommand(){

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            try {
                ValidateEditTest.this.book.setTitle(ValidateEditTest.newTitle);
            }
            catch (Exception e) {
                ValidateEditTest.this.fail(e);
            }
        }
    };
    private final Command clearTitle = new TestCommand(){

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            try {
                ValidateEditTest.this.book.setTitle(null);
            }
            catch (Exception e) {
                ValidateEditTest.this.fail(e);
            }
        }
    };

    public ValidateEditTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ValidateEditTest.class, "Validate-Edit Support Tests");
    }

    public void test_noValidateEditRequired() {
        try {
            this.getCommandStack().execute(this.setTitle, null);
            this.assertTitleChanged();
            this.assertResourceDirty();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void ignore_test_validateEditRollback() {
        this.setResourceReadOnly();
        try {
            this.getCommandStack().execute(this.setTitle, null);
            ValidateEditTest.fail((String)"Should have rolled back");
        }
        catch (RollbackException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.assertTitleNotChanged();
        this.assertResourceNotDirty();
    }

    public void test_customValidateEditSupport() {
        final boolean[] token = new boolean[1];
        this.setValidateEdit(new ValidateEditSupport.Default(){

            protected IStatus doValidateEdit(Transaction transaction, Collection<? extends Resource> resources, Object context) {
                token[0] = true;
                return Status.CANCEL_STATUS;
            }
        });
        try {
            this.getCommandStack().execute(this.setTitle, null);
            ValidateEditTest.fail((String)"Should have rolled back");
        }
        catch (RollbackException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
        ValidateEditTest.assertTrue((String)"Custom validation not invoked", (boolean)token[0]);
        this.assertTitleNotChanged();
        this.assertResourceNotDirty();
    }

    public void test_liveValidationFailure_validateEditOK() {
        try {
            this.getCommandStack().execute(this.clearTitle, null);
            ValidateEditTest.fail((String)"Should have rolled back");
        }
        catch (RollbackException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_validationRollback_validateEditFails() {
        this.setResourceReadOnly();
        try {
            this.getCommandStack().execute(this.clearTitle, null);
            ValidateEditTest.fail((String)"Should have rolled back");
        }
        catch (RollbackException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.assertResourceNotDirty();
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        ValidationRollbackTest.validationEnabled = true;
        this.setValidateEdit(Boolean.TRUE);
        this.testResource.setTrackingModification(true);
        this.startReading();
        this.book = (Book)this.find("root/Root Book");
        this.commit();
        ValidateEditTest.assertNotNull((Object)this.book);
    }

    @Override
    protected void doTearDown() throws Exception {
        this.book = null;
        ValidationRollbackTest.validationEnabled = false;
        super.doTearDown();
    }

    void setResourceReadOnly() {
        ResourceAttributes attr = new ResourceAttributes();
        attr.setReadOnly(true);
        try {
            this.file.setResourceAttributes(attr);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
    }

    void setValidateEdit(Object optionValue) {
        TransactionalEditingDomain.DefaultOptions defaults = (TransactionalEditingDomain.DefaultOptions)TransactionUtil.getAdapter((TransactionalEditingDomain)this.domain, TransactionalEditingDomain.DefaultOptions.class);
        defaults.setDefaultTransactionOptions(Collections.singletonMap("validate_edit", optionValue));
    }

    void assertTitleChanged() {
        ValidateEditTest.assertEquals((String)newTitle, (String)this.book.getTitle());
    }

    void assertTitleNotChanged() {
        ValidateEditTest.assertFalse((boolean)newTitle.equals(this.book.getTitle()));
    }

    void assertResourceDirty() {
        ValidateEditTest.assertTrue((String)"Resource not dirty", (boolean)this.testResource.isModified());
    }

    void assertResourceNotDirty() {
        ValidateEditTest.assertFalse((String)"Resource is dirty", (boolean)this.testResource.isModified());
    }
}

