/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class TransactionChangeRecorderTest
extends AbstractTest {
    private Resource rootResource;
    private Resource nestedResource1;
    private Resource nestedResource2;

    public TransactionChangeRecorderTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TransactionChangeRecorderTest.class, "Change Recorder Tests");
    }

    public void test_nestedNotLoaded_readOnlyTX() {
        this.startReading();
        this.loadRoot();
        TransactionChangeRecorderTest.assertTrue((boolean)this.rootResource.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource1.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource2.isLoaded());
    }

    public void test_changeRecorderPropagatedOnLoad_readOnlyTX() {
        this.startReading();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EPackage pkg = this.findPackage("root/nested1", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)pkg));
        Iterator contents = ((InternalEList)pkg.eContents()).basicIterator();
        EObject obj = (EObject)contents.next();
        TransactionChangeRecorderTest.assertTrue((!(obj instanceof EPackage) || obj.eIsProxy() ? 1 : 0) != 0);
        obj = (EObject)contents.next();
        TransactionChangeRecorderTest.assertTrue((!(obj instanceof EPackage) || obj.eIsProxy() ? 1 : 0) != 0);
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource1.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource2.isLoaded());
        pkg = this.findPackage("root/nested1/nested2", true);
        TransactionChangeRecorderTest.assertFalse((boolean)pkg.eIsProxy());
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)pkg));
        TransactionChangeRecorderTest.assertTrue((boolean)this.nestedResource1.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource2.isLoaded());
    }

    public void test_propagation_setTarget() {
        this.startReading();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        this.rootResource.eAdapters().remove((Object)recorder);
        this.loadRoot();
        this.commit();
        this.startWriting();
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource1.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource2.isLoaded());
        this.rootResource.eAdapters().add((Object)recorder);
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource1.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource2.isLoaded());
        this.rootResource.eAdapters().add((Object)recorder);
        this.unloadAndRemove(this.rootResource);
        this.commit();
    }

    public void test_nestedNotLoaded_writeTX() {
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorderTest.assertTrue((boolean)this.rootResource.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource1.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource2.isLoaded());
    }

    public void test_changeRecorderPropagatedOnLoad_writeTX() {
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EPackage pkg = this.findPackage("root/nested1", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)pkg));
        Iterator contents = ((InternalEList)pkg.eContents()).basicIterator();
        EObject obj = (EObject)contents.next();
        TransactionChangeRecorderTest.assertTrue((!(obj instanceof EPackage) || obj.eIsProxy() ? 1 : 0) != 0);
        obj = (EObject)contents.next();
        TransactionChangeRecorderTest.assertTrue((!(obj instanceof EPackage) || obj.eIsProxy() ? 1 : 0) != 0);
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource1.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource2.isLoaded());
        pkg = this.findPackage("root/nested1/nested2", true);
        TransactionChangeRecorderTest.assertFalse((boolean)pkg.eIsProxy());
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)pkg));
        TransactionChangeRecorderTest.assertTrue((boolean)this.nestedResource1.isLoaded());
        TransactionChangeRecorderTest.assertFalse((boolean)this.nestedResource2.isLoaded());
    }

    public void test_changeRecorderDispose_161169() {
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EClass eclass = this.findClass("root/A", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)eclass));
        this.commit();
        this.domain.dispose();
        try {
            eclass.setName("NewName");
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionChangeRecorderTest.fail((String)("Should not have asserted the transaction protocol: " + e.getLocalizedMessage()));
        }
    }

    public void test_changeRecorderDispose_detachedElements_161169() {
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EClass eclass = this.findClass("root/A", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)eclass));
        eclass.getEPackage().getEClassifiers().remove((Object)eclass);
        this.commit();
        this.domain.dispose();
        try {
            eclass.setName("NewName");
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionChangeRecorderTest.fail((String)("Should not have asserted the transaction protocol: " + e.getLocalizedMessage()));
        }
    }

    public void test_freeDetachedResources_161169() {
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EClass eclass = this.findClass("root/A", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)eclass));
        this.commit();
        this.domain.getResourceSet().getResources().remove((Object)this.rootResource);
        TransactionUtil.disconnectFromEditingDomain((Resource)this.rootResource);
        try {
            eclass.setName("NewName");
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionChangeRecorderTest.fail((String)("Should not have asserted the transaction protocol: " + e.getLocalizedMessage()));
        }
    }

    public void test_freeDetachedResources_properContents_161169() {
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EClass eclass = this.findClass("root/A", true);
        EClass nested = this.findClass("root/nested1/nested2/nested3/D", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)eclass));
        this.commit();
        this.domain.getResourceSet().getResources().remove((Object)this.rootResource);
        TransactionUtil.disconnectFromEditingDomain((Resource)this.rootResource);
        try {
            TransactionUtil.disconnectFromEditingDomain((Resource)this.nestedResource1);
            TransactionChangeRecorderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        try {
            nested.setName("NewName");
            TransactionChangeRecorderTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_freeDetachedElements_161169() {
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EClass eclass = this.findClass("root/A", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)eclass));
        EObject container = eclass.eContainer();
        EcoreUtil.remove((EObject)container);
        this.commit();
        TransactionUtil.disconnectFromEditingDomain((EObject)container);
        try {
            eclass.setName("NewName");
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionChangeRecorderTest.fail((String)("Should not have asserted the transaction protocol: " + e.getLocalizedMessage()));
        }
    }

    public void test_freeDetachedElements_properContents_161169() {
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EClass eclass = this.findClass("root/A", true);
        EClass nested = this.findClass("root/nested1/nested2/nested3/D", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)eclass));
        EObject container = eclass.eContainer();
        EcoreUtil.remove((EObject)container);
        this.commit();
        try {
            TransactionUtil.disconnectFromEditingDomain((EObject)nested);
            TransactionChangeRecorderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        try {
            nested.setName("NewName");
            TransactionChangeRecorderTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
    }

    public void test_freeElements_multipleEditingDomains_161169() {
        TransactionalEditingDomain other = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        this.startWriting();
        this.loadRoot();
        TransactionChangeRecorder recorder = this.getRecorder((Notifier)this.rootResource);
        EClass eclass = this.findClass("root/A", true);
        TransactionChangeRecorderTest.assertSame((Object)recorder, (Object)this.getRecorder((Notifier)eclass));
        this.commit();
        other.getResourceSet().getResources().add((Object)this.rootResource);
        try {
            TransactionUtil.disconnectFromEditingDomain((Resource)this.rootResource);
            TransactionChangeRecorderTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        other.getResourceSet().getResources().remove((Object)this.rootResource);
        TransactionUtil.disconnectFromEditingDomain((Resource)this.rootResource);
        try {
            eclass.setName("NewName");
        }
        catch (Exception e) {
            e.printStackTrace();
            TransactionChangeRecorderTest.fail((String)("Should not have asserted the transaction protocol: " + e.getLocalizedMessage()));
        }
    }

    public void test_resourceLoadsWhileUnloading_189587() {
        AdapterImpl reloader = new AdapterImpl(){

            public void unsetTarget(Notifier oldTarget) {
                TransactionChangeRecorderTest.assertTrue((boolean)(oldTarget instanceof EObject));
                EObject eobject = (EObject)oldTarget;
                TransactionChangeRecorderTest.assertTrue((boolean)eobject.eIsProxy());
                EcoreUtil.resolve((EObject)eobject, (ResourceSet)TransactionChangeRecorderTest.this.domain.getResourceSet());
            }
        };
        this.loadRoot();
        EClass eclass = this.findClass("root/A", true);
        eclass.eAdapters().add((Object)reloader);
        Resource res = eclass.eResource();
        res.unload();
        TransactionChangeRecorderTest.assertTrue((String)"Resource not reloaded", (boolean)res.isLoaded());
        try {
            res.unload();
        }
        catch (IllegalStateException e) {
            TransactionChangeRecorderTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        ResourceSet rset = this.domain.getResourceSet();
        try {
            this.rootResource = rset.getResource(URI.createURI((String)EmfTransactionTestsBundle.getEntry("/test_models/test_model.ecore").toString()), true);
            this.rootResource.setURI(URI.createPlatformResourceURI((String)"/emftxtests/test_model.ecore", (boolean)true));
            this.nestedResource1 = rset.createResource(URI.createPlatformResourceURI((String)"/emftxtests/test_model1.ecore", (boolean)true));
            this.nestedResource2 = rset.createResource(URI.createPlatformResourceURI((String)"/emftxtests/test_model2.ecore", (boolean)true));
            this.startWriting();
            EPackage pkg = this.findPackage("root/nested1/nested2", true);
            this.nestedResource1.getContents().add((Object)pkg);
            pkg = this.findPackage("root/nested1/nested2/nested3/nested4", true);
            this.nestedResource2.getContents().add((Object)pkg);
            this.commit();
            this.startReading();
            this.rootResource.save(Collections.EMPTY_MAP);
            this.nestedResource1.save(Collections.EMPTY_MAP);
            this.nestedResource2.save(Collections.EMPTY_MAP);
            this.rootResource.unload();
            this.nestedResource1.unload();
            this.nestedResource2.unload();
            this.commit();
        }
        catch (IOException e) {
            TransactionChangeRecorderTest.fail((String)("Failed to create test model: " + e.getLocalizedMessage()));
        }
    }

    @Override
    protected void doTearDown() throws Exception {
        if (this.rootResource != null) {
            this.unloadAndRemove(this.rootResource);
            this.rootResource = null;
        }
        if (this.nestedResource1 != null) {
            this.unloadAndRemove(this.nestedResource1);
            this.nestedResource1 = null;
        }
        if (this.nestedResource2 != null) {
            this.unloadAndRemove(this.nestedResource2);
            this.nestedResource2 = null;
        }
        super.doTearDown();
    }

    protected EPackage findPackage(String qname, boolean require) {
        EPackage result = (EPackage)this.find(this.rootResource, qname);
        if (require) {
            TransactionChangeRecorderTest.assertNotNull((String)("Did not find package " + qname), (Object)result);
        }
        return result;
    }

    protected EClass findClass(String qname, boolean require) {
        EClass result = (EClass)this.find(this.rootResource, qname);
        if (require) {
            TransactionChangeRecorderTest.assertNotNull((String)("Did not find class " + qname), (Object)result);
        }
        return result;
    }

    @Override
    protected String getName(EObject object) {
        if (object instanceof ENamedElement) {
            return ((ENamedElement)object).getName();
        }
        return super.getName(object);
    }

    protected void loadRoot() {
        try {
            this.rootResource.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
            TransactionChangeRecorderTest.fail((String)("Failed to load root resource: " + e.getLocalizedMessage()));
        }
    }

    protected TransactionChangeRecorder getRecorder(Notifier notifier) {
        TransactionChangeRecorder result = null;
        for (Object next : notifier.eAdapters()) {
            if (!(next instanceof TransactionChangeRecorder)) continue;
            result = (TransactionChangeRecorder)next;
            break;
        }
        TransactionChangeRecorderTest.assertNotNull((String)"Did not find change recorder", result);
        return result;
    }
}

