/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.util.CompositeChangeDescription;

public class MemoryLeakTest
extends AbstractTest {
    public MemoryLeakTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MemoryLeakTest.class, "Memory Leak (GC) Tests");
    }

    public void test_unloadResource() {
        ReferenceQueue q = new ReferenceQueue();
        WeakReference<Library> ref = new WeakReference<Library>(this.root, q);
        this.startWriting();
        this.root.setName("foo");
        this.commit();
        this.startReading();
        this.testResource.unload();
        this.commit();
        this.root = null;
        System.gc();
        this.idle(2000L);
        System.gc();
        MemoryLeakTest.assertSame(ref, q.poll());
    }

    public void test_reclaimEditingDomain() {
        ReferenceQueue q = new ReferenceQueue();
        WeakReference<TransactionalEditingDomain> ref = new WeakReference<TransactionalEditingDomain>(this.domain, q);
        this.startWriting();
        this.root.setName("foo");
        this.commit();
        this.domain = null;
        this.testResource = null;
        this.root = null;
        System.gc();
        this.idle(2000L);
        System.gc();
        MemoryLeakTest.assertSame(ref, q.poll());
    }

    public void test_nonRecordingChildTransactions_153908() {
        long initialUsedHeap = this.usedHeap();
        this.startWriting();
        String oldName = this.root.getName();
        this.root.setName("foo");
        Map<String, Boolean> options = Collections.singletonMap("unprotected", Boolean.TRUE);
        int i = 0;
        while (i < 1000) {
            this.startWriting(options);
            this.root.setName("foo" + i);
            this.commit();
            this.root.setName("foo" + (i + 1000));
            ++i;
        }
        long currentUsedHeap = this.usedHeap();
        System.out.println("Additional heap used by the transaction: " + (currentUsedHeap - initialUsedHeap) / 1024L + " kB");
        Transaction tx = this.commit();
        CompositeChangeDescription change = (CompositeChangeDescription)tx.getChangeDescription();
        List<ChangeDescription> children = MemoryLeakTest.getChildren(change);
        MemoryLeakTest.assertEquals((int)1, (int)children.size());
        this.startWriting(options);
        String newName = this.root.getName();
        change.applyAndReverse();
        this.commit();
        MemoryLeakTest.assertEquals((String)oldName, (String)this.root.getName());
        this.startWriting(options);
        change.applyAndReverse();
        this.commit();
        MemoryLeakTest.assertEquals((String)newName, (String)this.root.getName());
    }

    public void test_crossReferenceAdapter_undoredo_normalCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RemoveCommand cmd = new RemoveCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, level1){

            public void doDispose() {
                if (this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
                    for (Object o : this.collection) {
                        EObject next = (EObject)o;
                        if (next.eContainer() == this.owner) continue;
                        next.eAdapters().clear();
                    }
                }
                super.doDispose();
            }
        };
        this.getCommandStack().execute((Command)cmd);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().flush();
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_recordingCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        final EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RecordingCommand cmd = new RecordingCommand(this.domain, "Remove Branch"){

            protected void doExecute() {
                MemoryLeakTest.this.root.getBranches().remove((Object)level1);
            }
        };
        this.getCommandStack().execute((Command)cmd);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().flush();
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_normalTriggerCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RemoveCommand trigger = new RemoveCommand((EditingDomain)this.domain, (EObject)this.root, (EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__BRANCHES, level1){

            public void doDispose() {
                if (this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
                    for (Object o : this.collection) {
                        EObject next = (EObject)o;
                        if (next.eContainer() == this.owner) continue;
                        next.eAdapters().clear();
                    }
                }
                super.doDispose();
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener((Command)trigger){
            private final /* synthetic */ Command val$trigger;
            {
                this.val$trigger = command;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                if (notification.getFeature() == EXTLibraryPackage.Literals.LIBRARY__NAME) {
                    return this.val$trigger;
                }
                return null;
            }
        });
        Command cmd = this.domain.createCommand(SetCommand.class, new CommandParameter((Object)this.root, (Object)EXTLibraryPackage.Literals.LIBRARY__NAME, (Object)"newname"));
        this.getCommandStack().execute(cmd);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().flush();
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    public void test_crossReferenceAdapter_undoredo_recordingTriggerCommands() {
        ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter();
        this.domain.getResourceSet().eAdapters().add((Object)xrefAdapter);
        TransactionSniffer sniffer = new TransactionSniffer(this.domain);
        final EObject level1 = this.find(this.root, "level1");
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        RecordingCommand trigger = new RecordingCommand(this.domain, "Remove Branch"){

            protected void doExecute() {
                MemoryLeakTest.this.root.getBranches().remove((Object)level1);
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)new TriggerListener((Command)trigger){
            private final /* synthetic */ Command val$trigger;
            {
                this.val$trigger = command;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                if (notification.getFeature() == EXTLibraryPackage.Literals.LIBRARY__NAME) {
                    return this.val$trigger;
                }
                return null;
            }
        });
        Command cmd = this.domain.createCommand(SetCommand.class, new CommandParameter((Object)this.root, (Object)EXTLibraryPackage.Literals.LIBRARY__NAME, (Object)"newname"));
        this.getCommandStack().execute(cmd);
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().undo();
        this.getCommandStack().redo();
        MemoryLeakTest.assertTrue((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        this.getCommandStack().flush();
        MemoryLeakTest.assertFalse((boolean)level1.eAdapters().contains((Object)xrefAdapter));
        sniffer.assertChangesDisposed();
    }

    protected long usedHeap() {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        this.idle(2000L);
        rt.gc();
        long result = rt.totalMemory() - rt.freeMemory();
        System.out.println("Used Heap: " + result / 1024L + " kB");
        return result;
    }

    static List<ChangeDescription> getChildren(CompositeChangeDescription compositeChange) {
        List result = null;
        try {
            Field children = compositeChange.getClass().getDeclaredField("changes");
            children.setAccessible(true);
            result = (List)children.get(compositeChange);
        }
        catch (Exception e) {
            e.printStackTrace();
            MemoryLeakTest.fail((String)e.getLocalizedMessage());
        }
        return result;
    }

    private static class TransactionSniffer
    extends ResourceSetListenerImpl {
        private final TransactionalEditingDomain domain;
        private final List<ChangeDescription> changes = new BasicEList.FastCompare();

        TransactionSniffer(TransactionalEditingDomain domain) {
            this.domain = domain;
            domain.addResourceSetListener((ResourceSetListener)this);
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            Transaction tx = event.getTransaction();
            if (tx != null && tx.getChangeDescription() != null) {
                this.changes.add((ChangeDescription)tx.getChangeDescription());
            }
        }

        void assertChangesDisposed() {
            this.domain.removeResourceSetListener((ResourceSetListener)this);
            TreeIterator iter = EcoreUtil.getAllContents(this.changes);
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                MemoryLeakTest.assertEquals((String)"Adapters not cleared.", (int)0, (int)next.eAdapters().size());
            }
        }
    }
}

