/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class LifecycleListenersTest
extends AbstractTest {
    private LifecycleListener listener;

    public LifecycleListenersTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LifecycleListenersTest.class, "Editing Domain Life-cycle Event Tests");
    }

    public void test_eventSequence_commit() {
        Book book = (Book)this.find("root/Root Book");
        LifecycleListenersTest.assertNotNull((Object)book);
        this.startWriting();
        book.setTitle("New Title");
        this.startWriting();
        book.setTitle("Another Title");
        this.commit();
        this.commit();
        List<Integer> expected = Arrays.asList(1, 4, 8, 1, 4, 8, 16, 16);
        LifecycleListenersTest.assertEquals((String)"Wrong event sequence", expected, this.listener.eventTypesReceived);
    }

    public void test_eventSequence_rollback() {
        Book book = (Book)this.find("root/Root Book");
        LifecycleListenersTest.assertNotNull((Object)book);
        this.startWriting();
        book.setTitle("New Title");
        this.startWriting();
        book.setTitle("Another Title");
        this.commit();
        this.rollback();
        List<Integer> expected = Arrays.asList(1, 4, 8, 16);
        LifecycleListenersTest.assertEquals((String)"Wrong event sequence", expected, this.listener.eventTypesReceived);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.listener = new LifecycleListener();
        ((TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)this.domain, TransactionalEditingDomain.Lifecycle.class)).addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this.listener);
    }

    protected void doTearDown() throws Exception {
        ((TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)this.domain, TransactionalEditingDomain.Lifecycle.class)).removeTransactionalEditingDomainListener((TransactionalEditingDomainListener)this.listener);
        this.listener = null;
        super.doTearDown();
    }

    private class LifecycleListener
    implements TransactionalEditingDomainListener {
        List<Integer> eventTypesReceived = new ArrayList<Integer>();

        private LifecycleListener() {
        }

        public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
            LifecycleListenersTest.assertNull((Object)event.getTransaction());
            this.eventTypesReceived.add(event.getEventType());
        }

        public void transactionClosed(TransactionalEditingDomainEvent event) {
            LifecycleListenersTest.assertNotNull((Object)event.getTransaction());
            LifecycleListenersTest.assertFalse((boolean)event.getTransaction().isActive());
            this.eventTypesReceived.add(event.getEventType());
        }

        public void transactionClosing(TransactionalEditingDomainEvent event) {
            LifecycleListenersTest.assertNotNull((Object)event.getTransaction());
            LifecycleListenersTest.assertTrue((boolean)event.getTransaction().isActive());
            this.eventTypesReceived.add(event.getEventType());
        }

        public void transactionInterrupted(TransactionalEditingDomainEvent event) {
            LifecycleListenersTest.assertNotNull((Object)event.getTransaction());
            LifecycleListenersTest.assertFalse((boolean)event.getTransaction().isActive());
            this.eventTypesReceived.add(event.getEventType());
        }

        public void transactionStarted(TransactionalEditingDomainEvent event) {
            LifecycleListenersTest.assertNotNull((Object)event.getTransaction());
            LifecycleListenersTest.assertTrue((boolean)event.getTransaction().isActive());
            this.eventTypesReceived.add(event.getEventType());
        }

        public void transactionStarting(TransactionalEditingDomainEvent event) {
            LifecycleListenersTest.assertNotNull((Object)event.getTransaction());
            LifecycleListenersTest.assertFalse((boolean)event.getTransaction().isActive());
            this.eventTypesReceived.add(event.getEventType());
        }
    }
}

