/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.repositories;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdate;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.h2.jdbcx.JdbcDataSource;

public class LocalCDORepository
extends CDORepositoryImpl {
    public static final String PROP_SECURITY_DISABLED = "securityDisabled";
    public static final String PROP_SECURITY_CONFIG = "securityConfig";
    public static final String PROP_TCP_DISABLED = "tcpDisabled";
    public static final String PROP_TCP_PORT = "tcpPort";
    private static final PasswordCredentials CREDENTIALS = new PasswordCredentials("Administrator", "0000");
    private boolean securityDisabled;
    private String securityConfig;
    private boolean tcpDisabled;
    private int tcpPort;
    private IRepository repository;
    private IAcceptor tcpAcceptor;

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean isClone() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public final String getConnectorType() {
        return "jvm";
    }

    @Override
    public final String getConnectorDescription() {
        return "local";
    }

    @Override
    public String getURI() {
        if (this.tcpDisabled) {
            return String.valueOf(this.getConnectorType()) + "://" + this.getConnectorDescription() + "/" + this.getName();
        }
        return "tcp://localhost:" + this.tcpPort + "/" + this.getName();
    }

    public final boolean isSecurityDisabled() {
        return this.securityDisabled;
    }

    public final String getSecurityConfig() {
        return this.securityConfig;
    }

    public final boolean isTCPDisabled() {
        return this.tcpDisabled;
    }

    public final int getTCPPort() {
        return this.tcpPort;
    }

    @Override
    protected void init(File folder, String type, Properties properties) {
        super.init(folder, type, properties);
        this.securityDisabled = Boolean.parseBoolean(properties.getProperty(PROP_SECURITY_DISABLED, Boolean.TRUE.toString()));
        this.securityConfig = StringUtil.safe((Object)properties.get(PROP_SECURITY_CONFIG));
        this.tcpDisabled = Boolean.parseBoolean(properties.getProperty(PROP_TCP_DISABLED, Boolean.TRUE.toString()));
        this.tcpPort = Integer.parseInt(properties.getProperty(PROP_TCP_PORT, "0"));
    }

    @Override
    protected void collectProperties(Properties properties) {
        super.collectProperties(properties);
        properties.setProperty(PROP_SECURITY_DISABLED, Boolean.toString(this.securityDisabled));
        properties.setProperty(PROP_SECURITY_CONFIG, StringUtil.safe((String)this.securityConfig));
        properties.setProperty(PROP_TCP_DISABLED, Boolean.toString(this.tcpDisabled));
        properties.setProperty(PROP_TCP_PORT, Integer.toString(this.tcpPort));
    }

    @Override
    public CDOSession openSession() {
        String repositoryName = this.getName();
        File folder = new File(this.getFolder(), "db");
        CDORepository.VersioningMode versioningMode = this.getVersioningMode();
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + folder);
        boolean supportingAudits = versioningMode.isSupportingAudits();
        boolean supportingBranches = versioningMode.isSupportingBranches();
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)supportingAudits, (boolean)supportingBranches, (boolean)false);
        mappingStrategy.setProperties(this.getMappingStrategyProperties());
        IDBAdapter dbAdapter = DBUtil.getDBAdapter((String)"h2");
        IDBConnectionProvider connectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)connectionProvider);
        this.repository = CDOServerUtil.createRepository((String)repositoryName, (IStore)store, this.getRepositoryProperties());
        IManagedContainer container = this.getContainer();
        CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)this.repository);
        if (!this.securityDisabled) {
            try {
                String qualifiedDescription = String.format("%s:%s", repositoryName, this.securityConfig);
                if (container.getElement("org.eclipse.emf.cdo.server.security.managers", "default", qualifiedDescription) == null) {
                    throw new IllegalStateException("Security manager for repository " + repositoryName + " could not be created: " + this.securityConfig);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        String connectorType = this.getConnectorType();
        String connectorDescription = this.getConnectorDescription();
        Net4jUtil.getAcceptor((IManagedContainer)container, (String)connectorType, (String)connectorDescription);
        if (!this.tcpDisabled) {
            this.tcpAcceptor = Net4jUtil.getAcceptor((IManagedContainer)container, (String)"tcp", (String)("0.0.0.0:" + this.tcpPort));
        }
        return super.openSession();
    }

    @Override
    public boolean isAuthenticating() {
        return !this.isSecurityDisabled();
    }

    @Override
    public IPasswordCredentials getCredentials(String realm) {
        if (!this.isSecurityDisabled()) {
            return CREDENTIALS;
        }
        return super.getCredentials(realm);
    }

    @Override
    public void setCredentials(IPasswordCredentials credentials) {
        if (!this.isSecurityDisabled()) {
            return;
        }
        super.setCredentials(credentials);
    }

    @Override
    public IPasswordCredentialsUpdate getCredentialsUpdate(String realm, String userID, CredentialsUpdateOperation operation) {
        if (!this.isSecurityDisabled()) {
            return null;
        }
        return super.getCredentialsUpdate(realm, userID, operation);
    }

    protected Map<String, String> getRepositoryProperties() {
        CDORepository.VersioningMode versioningMode = this.getVersioningMode();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", Boolean.toString(versioningMode.isSupportingAudits()));
        props.put("supportingBranches", Boolean.toString(versioningMode.isSupportingBranches()));
        props.put("idGenerationLocation", this.getIDGeneration().getLocation().toString());
        return props;
    }

    protected Map<String, String> getMappingStrategyProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("qualifiedNames", "true");
        props.put("copyOnBranch", "true");
        return props;
    }

    @Override
    protected void closeSession() {
        super.closeSession();
        LifecycleUtil.deactivate((Object)this.tcpAcceptor);
        this.tcpAcceptor = null;
        LifecycleUtil.deactivate((Object)this.repository);
        this.repository = null;
    }
}

