/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.lm.server.XMLLifecycleManager;
import org.eclipse.emf.cdo.lm.server.bundle.OM;
import org.eclipse.emf.cdo.spi.server.AppExtension;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.PropertiesFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LMAppExtension
extends AppExtension {
    private final Map<InternalRepository, XMLLifecycleManager> lifecycleManagers = new HashMap<InternalRepository, XMLLifecycleManager>();

    public String getName() {
        return "Lifecycle management";
    }

    protected void start(InternalRepository repository, Element repositoryConfig) throws Exception {
        NodeList lmElements = repositoryConfig.getElementsByTagName("lifecycleManager");
        int length = lmElements.getLength();
        if (length > 1) {
            throw new IllegalStateException("At most one lifecycle manager must be configured for repository " + repository.getName());
        }
        if (length == 1) {
            Element lmElement = (Element)lmElements.item(0);
            this.configureLifecycleManager(repository, lmElement);
        }
    }

    protected void stop(InternalRepository repository) throws Exception {
        XMLLifecycleManager lifecycleManager = this.lifecycleManagers.get(repository);
        if (lifecycleManager != null) {
            OM.LOG.info("Deactivating lifecycle manager of repository " + repository.getName());
            lifecycleManager.deactivate();
        }
    }

    private void configureLifecycleManager(InternalRepository repository, Element lmElement) {
        NodeList moduleTemplateElements;
        int length;
        String systemName = lmElement.getAttribute("systemName");
        if (systemName == null || systemName.isEmpty()) {
            throw new IllegalStateException("A systemName must be specified for the lifecycle manager of repository " + repository.getName());
        }
        String moduleDefinitionPath = lmElement.getAttribute("moduleDefinitionPath");
        if (moduleDefinitionPath == null || moduleDefinitionPath.isEmpty()) {
            moduleDefinitionPath = ".module.md";
        }
        if ((length = (moduleTemplateElements = lmElement.getElementsByTagName("moduleTemplate")).getLength()) != 1) {
            throw new IllegalStateException("Exactly one module template must be configured for the lifecycle manager of repository " + repository.getName());
        }
        Element moduleTemplateElement = (Element)moduleTemplateElements.item(0);
        XMLLifecycleManager lifecycleManager = this.createLifecycleManager(repository, lmElement);
        lifecycleManager.setSystemRepository(repository);
        lifecycleManager.setSystemName(systemName);
        lifecycleManager.setModuleDefinitionPath(moduleDefinitionPath);
        lifecycleManager.setModuleTemplateElement(moduleTemplateElement);
        OM.LOG.info("Activating lifecycle manager of repository " + repository.getName());
        lifecycleManager.activate();
        this.lifecycleManagers.put(repository, lifecycleManager);
    }

    protected XMLLifecycleManager createLifecycleManager(InternalRepository repository, Element lmElement) {
        XMLLifecycleManager lifecycleManager = (XMLLifecycleManager)((Object)this.getContainerElement(lmElement, "default", repository.getContainer()));
        return lifecycleManager;
    }

    protected Map<String, String> initializeModuleTypesDefinition() {
        return Collections.emptyMap();
    }

    protected Map<String, Boolean> initializeDropTypesDefinition() {
        HashMap<String, Boolean> dropTypes = new HashMap<String, Boolean>();
        dropTypes.put("Tag", false);
        dropTypes.put("Milestone", false);
        dropTypes.put("Release", true);
        return dropTypes;
    }

    private <T> T getContainerElement(Element element, String defaultType, IManagedContainer container) {
        String description;
        String type = element.getAttribute("type");
        if (StringUtil.isEmpty((String)type)) {
            type = defaultType;
        }
        if (StringUtil.isEmpty((String)(description = element.getAttribute("description")))) {
            Map properties = RepositoryConfigurator.getProperties((Element)element, (int)1);
            description = PropertiesFactory.createDescription((Map)properties);
        }
        Object containerElement = container.getElement("org.eclipse.emf.cdo.lm.server.lifecycleManagers", type, description, false);
        return (T)containerElement;
    }
}

