/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.lm;

import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Process;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.StreamMode;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.tests.lm.AbstractLMTest;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class LMVersionEvolutionTest
extends AbstractLMTest {
    private static final String INITIAL_STREAM = "InitialStream";
    private static final String MODULE_CLIENT = "ModuleClient";
    private static final String MODULE_CLIENT_A = "ModuleClientA";
    private static final String MODULE_SUPPLIER = "ModuleSupplier";
    private static final String MODULE_SUPPLIER_A = "ModuleSupplierA";
    private static final String SUPPLIER_DROP_TYPE = "SupplierDropType";
    private static final String TAG1_0 = "Tag1.0";

    public void testVersionEvolution() throws Exception {
        ISystemDescriptor systemDescriptor = LMVersionEvolutionTest.createSystemRepository();
        System system = systemDescriptor.getSystem();
        AbstractLMTest.ModuleCreationResult supplierModuleCreationResult = this.createModule(systemDescriptor, system, MODULE_SUPPLIER, INITIAL_STREAM, 0, 1);
        Module supplierModule = supplierModuleCreationResult.module;
        Stream supplierStream = supplierModuleCreationResult.stream;
        IAssemblyDescriptor supplierStreamDescriptor = supplierModuleCreationResult.assemblyDescriptor;
        this.editStream(supplierStreamDescriptor, transaction -> {
            CDOResource resource = transaction.createResource(MODULE_SUPPLIER_A);
            DropType dropType = LMFactory.eINSTANCE.createDropType();
            dropType.setName(SUPPLIER_DROP_TYPE);
            System sys = LMFactory.eINSTANCE.createSystem();
            sys.setName("SupplierSystem");
            Process process = LMFactory.eINSTANCE.createProcess();
            process.getDropTypes().add((Object)dropType);
            sys.setProcess(process);
            resource.getContents().add((Object)sys);
        });
        this.publishTag(systemDescriptor, system, supplierStream, "Tag0.1");
        AbstractLMTest.ModuleCreationResult clientModuleCreationResult = this.createModule(systemDescriptor, system, MODULE_CLIENT, INITIAL_STREAM, 0, 1);
        IAssemblyDescriptor clientStreamDescriptor = clientModuleCreationResult.assemblyDescriptor;
        this.createDependency(clientStreamDescriptor, MODULE_SUPPLIER, new VersionRange("[0.0.0,1.0.0)"));
        this.updateClient(clientStreamDescriptor);
        this.editStream(clientStreamDescriptor, transaction -> {
            CDOResource resourceClient = transaction.createResource(MODULE_CLIENT_A);
            CDOView view = clientStreamDescriptor.getCheckout().openView();
            ResourceSet resourceSet = view.getResourceSet();
            URI uri = URI.createURI((String)"cdo://ModuleSupplier/ModuleSupplierA");
            CDOResource resourceSupplier = (CDOResource)resourceSet.getResource(uri, true);
            MatcherAssert.assertThat((Object)resourceSupplier, (Matcher)CoreMatchers.notNullValue());
            EObject eObject = (EObject)resourceSupplier.getContents().get(0);
            MatcherAssert.assertThat((Object)eObject, (Matcher)CoreMatchers.instanceOf(System.class));
            DropType supplierDropType = (DropType)((System)resourceSupplier.getContents().get(0)).getProcess().getDropTypes().get(0);
            System clientSystem = LMFactory.eINSTANCE.createSystem();
            clientSystem.setName("ClientStream");
            Module clientModule = LMFactory.eINSTANCE.createModule();
            clientModule.setName("SampleClientModule");
            clientSystem.getModules().add((Object)clientModule);
            Stream stream = LMFactory.eINSTANCE.createStream();
            stream.setCodeName("ClientStream");
            clientModule.getStreams().add((Object)stream);
            Drop drop = LMFactory.eINSTANCE.createDrop();
            drop.setLabel("ClientDrop");
            drop.setType(supplierDropType);
            stream.getContents().add((Object)drop);
            resourceClient.getContents().add((Object)clientSystem);
        });
        this.retrieveValueAndTest(clientStreamDescriptor, resourceSupplier -> LMVersionEvolutionTest.assertNotEquals(0, resourceSupplier.getContents().size()), element -> LMVersionEvolutionTest.assertNotEquals(null, element));
        this.updateDependency(clientStreamDescriptor, MODULE_SUPPLIER, new VersionRange("[1.0.0,2.0.0)"));
        try {
            LMVersionEvolutionTest.waitForUpdates(clientStreamDescriptor);
            LMVersionEvolutionTest.fail((String)"InterruptedException expected");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.editStream(supplierStreamDescriptor, transaction -> {
            CDOResource resource = transaction.getResource(MODULE_SUPPLIER_A);
            resource.getContents().clear();
        });
        this.publishRelease(systemDescriptor, system, supplierStream, "Release0.1");
        supplierStream.getLastRelease();
        Stream stream1_0 = this.createStream(systemDescriptor, supplierModule, supplierStream.getLastRelease(), 1, 0, "Stream1.0");
        MatcherAssert.assertThat((Object)supplierStream.getMode(), (Matcher)CoreMatchers.is((Object)StreamMode.MAINTENANCE));
        try {
            this.publishTag(systemDescriptor, system, stream1_0, TAG1_0);
            LMVersionEvolutionTest.fail((String)"CDOException expected");
        }
        catch (CDOException cDOException) {
            // empty catch block
        }
        this.setModuleVersion(stream1_0, MODULE_SUPPLIER, 1, 0, 0);
        this.publishTag(systemDescriptor, system, stream1_0, TAG1_0);
        Baseline baseline = stream1_0.getContents().stream().filter(b -> b.getName().equals(TAG1_0)).findAny().orElse(null);
        MatcherAssert.assertThat((Object)baseline, (Matcher)CoreMatchers.instanceOf(Drop.class));
        if (baseline instanceof Drop) {
            Drop tag1_0 = (Drop)baseline;
            LMVersionEvolutionTest.assertTrue((tag1_0.getVersion().compareTo((Object)Version.createOSGi((int)1, (int)0, (int)0)) > 0 ? 1 : 0) != 0);
        }
        this.updateDependency(clientStreamDescriptor, MODULE_SUPPLIER, new VersionRange("[1.0.0,2.0.0)"));
        IAssemblyDescriptor.Updates updates = LMVersionEvolutionTest.waitForUpdates(clientStreamDescriptor);
        LMVersionEvolutionTest.assertEquals((int)2, (int)updates.getModifications().size());
        this.updateClient(clientStreamDescriptor);
        this.retrieveValueAndTest(clientStreamDescriptor, resourceSupplier -> LMVersionEvolutionTest.assertEquals((int)0, (int)resourceSupplier.getContents().size()), element -> LMVersionEvolutionTest.assertEquals(null, (Object)element));
    }

    private void retrieveValueAndTest(IAssemblyDescriptor clientStreamDescriptor, Consumer<Resource> testResource, Consumer<DropType> testDropType) {
        CDOTransaction transaction = clientStreamDescriptor.getCheckout().openTransaction();
        URI uriSupplier = URI.createURI((String)"cdo://ModuleSupplier/ModuleSupplierA");
        CDOResource resourceSupplier = (CDOResource)transaction.getResourceSet().getResource(uriSupplier, true);
        testResource.accept((Resource)resourceSupplier);
        CDOResource clientResource = transaction.getResource(MODULE_CLIENT_A);
        System sampleClientSystem = (System)clientResource.getContents().get(0);
        Module sampleClientModule = (Module)sampleClientSystem.getModules().get(0);
        Stream sampleClientStream = (Stream)sampleClientModule.getStreams().get(0);
        Baseline sampleClientbaseline = (Baseline)sampleClientStream.getContents().get(0);
        MatcherAssert.assertThat((Object)sampleClientbaseline, (Matcher)CoreMatchers.instanceOf(Drop.class));
        DropType sampleClientDropType = ((Drop)sampleClientbaseline).getType();
        testDropType.accept(sampleClientDropType);
        transaction.close();
    }

    private static void assertNotEquals(Object unexpected, Object actual) {
        if (LMVersionEvolutionTest.objectsAreEqual(unexpected, actual)) {
            LMVersionEvolutionTest.fail((String)("expected: not equal but was: <" + actual + ">"));
        }
    }

    private static void assertNotEquals(int unexpected, int actual) {
        if (unexpected == actual) {
            LMVersionEvolutionTest.fail((String)("expected: not equal but was: <" + actual + ">"));
        }
    }

    private static boolean objectsAreEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

