/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.execution.ui.launching.configuration;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.editor.qvtcore.ui.QVTcCreationFactory;
import org.eclipse.qvt.declarative.editor.qvtrelation.ui.QVTrCreationFactory;
import org.eclipse.qvt.declarative.execution.ui.launching.configuration.DeclarativeQVTElementLabelProvider;
import org.eclipse.qvt.declarative.execution.ui.launching.configuration.DeclarativeQVTFileFetcher;
import org.eclipse.qvt.declarative.execution.ui.launching.configuration.TransformationSelectionDialog;
import org.eclipse.qvt.declarative.modelregistry.eclipse.EclipseFileHandle;
import org.eclipse.qvt.declarative.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AccessorKindRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.model.AccessorRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.FileHandleRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.ProjectRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.Registration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarativeQVTMainTab
extends AbstractLaunchConfigurationTab {
    public static String TAB_NAME = "Main";
    private Text projectText;
    private Button projectButton;
    private Text transformationText;
    private Button transformationButton;
    private Composite modelsComposite;
    private Map<String, List<Widget>> dynamicModelsWidget = new HashMap<String, List<Widget>>();
    private IFile currentTransformationFile;
    private IProject currentProject;
    private RelationalTransformation currentRelationalTransformation;
    private SelectionListener targetButtonsSelectionListener = new TargetButtonSelectionListener();

    public void createControl(Composite parent) {
        Composite comp = DeclarativeQVTMainTab.createMainComposite(parent);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createTransformationEditor(comp, "Transformation");
        this.setControl((Control)comp);
    }

    private static Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(font);
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static void createLabel(Composite parent, String text, int layoutStyle) {
        Label tempLabel = new Label(parent, 0x1000000);
        tempLabel.setText(text);
        tempLabel.setLayoutData((Object)new GridData(layoutStyle));
    }

    private static Composite createMainComposite(Composite parent) {
        Composite comp = DeclarativeQVTMainTab.createComposite(parent, parent.getFont(), 2, 1, 768);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        return comp;
    }

    private static Text createSingleText(Composite parent, int hspan) {
        Text t = new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        t.setLayoutData((Object)gd);
        return t;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Project");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.projectText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.setFont(font);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeclarativeQVTMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectButton = this.createPushButton((Composite)group, "Browse...", null);
        this.projectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DeclarativeQVTMainTab.this.handleProjectButtonSelected();
                DeclarativeQVTMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createTransformationEditor(Composite parent, String text) {
        Group mainGroup = DeclarativeQVTMainTab.createGroup(parent, text, 2, 1, 768);
        Composite comp = DeclarativeQVTMainTab.createComposite((Composite)mainGroup, parent.getFont(), 2, 2, 1808);
        this.removeCompositeMargin(comp);
        this.transformationText = DeclarativeQVTMainTab.createSingleText(comp, 1);
        this.transformationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeclarativeQVTMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.transformationButton = this.createPushButton(comp, "Search...", null);
        this.transformationButton.addSelectionListener((SelectionListener)new TransformationSelectionListener(comp));
    }

    private RelationalTransformation handleSearchButtonSelected() {
        IProject project = this.getCurrentProject();
        Object searchScope = null;
        searchScope = project != null && project.exists() ? this.getCurrentProject() : DeclarativeQVTMainTab.getWorkspaceRoot();
        if (searchScope != null) {
            Object selection;
            DeclarativeQVTFileFetcher fetcher = new DeclarativeQVTFileFetcher((IContainer)searchScope);
            Set<IFile> qvtFiles = fetcher.getQVTfiles();
            TransformationSelectionDialog tsd = new TransformationSelectionDialog(this.getShell(), qvtFiles);
            tsd.setListLabelProvider(new DeclarativeQVTElementLabelProvider());
            if (tsd.open() == 0 && (selection = tsd.getFirstResult()) instanceof IFile) {
                IFile file;
                this.currentTransformationFile = file = (IFile)selection;
                this.currentProject = file.getProject();
                this.transformationText.setText(file.getName());
                this.projectText.setText(file.getProject().getName());
                Resource modelResource = this.getModelResource(file);
                return this.getTransformation(modelResource);
            }
        }
        return null;
    }

    private Resource getModelResource(IFile file) {
        String modelPath = file.getFullPath().removeFileExtension().addFileExtension("eqvtrelation").toString();
        URI modelURI = URI.createPlatformResourceURI((String)modelPath, (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource modelResource = resourceSet.getResource(modelURI, true);
        return modelResource;
    }

    private RelationalTransformation getTransformation(Resource modelResource) {
        EObject object = (EObject)modelResource.getContents().get(0);
        if (object instanceof RelationalTransformation) {
            return (RelationalTransformation)object;
        }
        return null;
    }

    private void createAllModelEditors(Composite parent, RelationalTransformation transformation) {
        if (this.modelsComposite != null) {
            this.modelsComposite.dispose();
        }
        this.modelsComposite = DeclarativeQVTMainTab.createComposite(parent, parent.getFont(), 3, 2, 1808);
        ((GridLayout)this.modelsComposite.getLayout()).verticalSpacing = 0;
        DeclarativeQVTMainTab.createLabel(this.modelsComposite, "Model", 0);
        DeclarativeQVTMainTab.createLabel(this.modelsComposite, "Target", 0);
        DeclarativeQVTMainTab.createLabel(this.modelsComposite, "Location", 768);
        this.dynamicModelsWidget.clear();
        int count = 0;
        EList models = transformation.getModelParameter();
        int lastModelIndex = models.size() - 1;
        for (TypedModel typedModel : models) {
            this.createModelEditor(this.modelsComposite, typedModel, count == lastModelIndex);
            ++count;
        }
        this.updateLaunchConfigurationDialog();
    }

    private void removeCompositeMargin(Composite composite) {
        GridLayout gl = (GridLayout)composite.getLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
    }

    private void createModelEditor(Composite parent, TypedModel typedModel, boolean isTarget) {
        Label label = new Label(parent, 0x1000000);
        String modelName = typedModel.getName();
        label.setText(modelName);
        Button targetButton = new Button(parent, 16);
        targetButton.setSelection(isTarget);
        Composite subComposite = DeclarativeQVTMainTab.createComposite(parent, parent.getFont(), 4, 1, 1808);
        this.removeCompositeMargin(subComposite);
        Text text = DeclarativeQVTMainTab.createSingleText(subComposite, 1);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeclarativeQVTMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button searchModelButton = this.createPushButton(subComposite, "Search", null);
        searchModelButton.addSelectionListener((SelectionListener)new ModelButtonSelectionListener(text, 4096));
        Button newModelButton = this.createPushButton(subComposite, "New...", null);
        newModelButton.addSelectionListener((SelectionListener)new ModelButtonSelectionListener(text, 8192));
        newModelButton.setEnabled(isTarget);
        targetButton.addSelectionListener(this.targetButtonsSelectionListener);
        ArrayList<Object> modelWidgets = new ArrayList<Object>();
        modelWidgets.add(targetButton);
        modelWidgets.add(text);
        modelWidgets.add(searchModelButton);
        modelWidgets.add(newModelButton);
        this.dynamicModelsWidget.put(modelName, modelWidgets);
    }

    private void handleProjectButtonSelected() {
        DeclarativeQVTElementLabelProvider labelProvider = new DeclarativeQVTElementLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection");
        dialog.setMessage("Select a project to constrain your search.");
        Object[] declarativeQVTProjects = this.getDeclarativeQVTProjects();
        dialog.setElements(declarativeQVTProjects);
        Object currentProject = null;
        boolean projectFound = false;
        int i = 0;
        while (i < declarativeQVTProjects.length && !projectFound) {
            Object project = declarativeQVTProjects[i];
            if (project.getName().equals(this.projectText.getText().trim())) {
                currentProject = project;
                projectFound = true;
            }
            ++i;
        }
        if (projectFound) {
            dialog.setInitialSelections(new Object[]{currentProject});
        }
        IProject selectedProject = null;
        if (dialog.open() == 0) {
            selectedProject = (IProject)dialog.getFirstResult();
        }
        if (selectedProject != null) {
            this.projectText.setText(selectedProject.getName());
        }
    }

    private IProject getCurrentProject() {
        String currentProjectName = this.projectText.getText().trim();
        IProject[] iProjectArray = DeclarativeQVTMainTab.getWorkspaceRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().equals(currentProjectName)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private IProject[] getDeclarativeQVTProjects() {
        ArrayList<IProject> qvtProjectList = new ArrayList<IProject>();
        IProject[] iProjectArray = DeclarativeQVTMainTab.getWorkspaceRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.getNature(QVTrCreationFactory.NATURE_ID) != null || project.getNature(QVTcCreationFactory.NATURE_ID) != null) {
                    qvtProjectList.add(project);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return qvtProjectList.toArray(new IProject[0]);
    }

    public String getName() {
        return TAB_NAME;
    }

    private static IFile getFileFromURI(String uriString) throws URISyntaxException {
        java.net.URI uri = new java.net.URI(uriString);
        String path = uri.toString();
        if (uri.getScheme().equals("file")) {
            path = new File(uri).toString();
        }
        IFile iFile = DeclarativeQVTMainTab.getWorkspaceRoot().getFileForLocation((IPath)new Path(path));
        return iFile;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String executablePath = configuration.getAttribute("QVTExecutableAttributeName", "");
            List modelNameList = configuration.getAttribute("QVTModelNamesAttributeName", Collections.EMPTY_LIST);
            List modelPathList = configuration.getAttribute("QVTModelPathsAttributeName", Collections.EMPTY_LIST);
            String directionModel = configuration.getAttribute("QVTDirectionmodelPathsAttributeName", "");
            if (executablePath == null || executablePath == "") {
                return;
            }
            IFile sourceFile = DeclarativeQVTMainTab.getSourceFile(executablePath);
            if (sourceFile == null) {
                return;
            }
            this.currentProject = sourceFile.getProject();
            this.projectText.setText(this.currentProject.getName());
            this.currentTransformationFile = sourceFile;
            this.currentRelationalTransformation = this.getTransformation(this.getModelResource(this.currentTransformationFile));
            this.transformationText.setText(this.currentTransformationFile.getName());
            this.createAllModelEditors(this.transformationText.getParent(), this.getTransformation(this.getModelResource(this.currentTransformationFile)));
            for (Object modelNameObject : modelNameList) {
                int index = modelNameList.indexOf(modelNameObject);
                String modelname = (String)modelNameObject;
                List<Widget> widgetList = this.dynamicModelsWidget.get(modelname);
                this.getTargetWiget(widgetList).setSelection(modelname.equals(directionModel));
                String modelPath = (String)modelPathList.get(index);
                IFile modelFile = DeclarativeQVTMainTab.getFileFromURI(modelPath);
                if (modelFile == null) continue;
                String relativePath = URI.createPlatformPluginURI((String)modelFile.getFullPath().toString(), (boolean)true).toString();
                this.getModelPathWiget(widgetList).setText(relativePath);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private Button getTargetWiget(List<Widget> widgetList) {
        Widget widget = widgetList.get(0);
        if (widget instanceof Button) {
            return (Button)widget;
        }
        return null;
    }

    private Text getModelPathWiget(List<Widget> widgetList) {
        Widget widget = widgetList.get(1);
        if (widget instanceof Text) {
            return (Text)widget;
        }
        return null;
    }

    private boolean isTargetModel(List<Widget> widgetList) {
        Button button = this.getTargetWiget(widgetList);
        if (button != null) {
            return button.getSelection();
        }
        return false;
    }

    private String getModelURIString(List<Widget> widgetList) {
        Text text = this.getModelPathWiget(widgetList);
        if (text != null) {
            return text.getText();
        }
        return null;
    }

    private String getModelFileURIString(URI modelURI) {
        File modelFile = this.getURIFile(modelURI);
        return modelFile.toURI().toString();
    }

    private String getModelFileURIString(List<Widget> widgetList) {
        String modelPath = this.getModelURIString(widgetList);
        if (modelPath != null) {
            URI modelURI = URI.createURI((String)modelPath);
            return this.getModelFileURIString(modelURI);
        }
        return null;
    }

    private Collection<? extends Registration<?>> getMetamodelRegistrations() {
        EclipseProjectHandle projectHandle = new EclipseProjectHandle(this.currentProject);
        ProjectRegistry projectRegistry = new ProjectRegistry((AbstractProjectHandle)projectHandle, (ResourceSet)new ResourceSetImpl());
        projectRegistry.loadModel();
        AccessorKindRegistry accessorKindRegistry = ModelRegistryEnvironment.getInstance().getAccessorKindRegistry();
        Class accessorClass = accessorKindRegistry.getAccessorClass("Model Name");
        if (accessorClass != null) {
            EclipseFileHandle fileHandleAncestor = projectHandle.getFileHandle((IResource)this.currentTransformationFile);
            while (fileHandleAncestor != null) {
                AccessorRegistry accessorRegistry;
                FileHandleRegistry fileHandleRegistry = projectRegistry.get((AbstractFileHandle)fileHandleAncestor);
                if (fileHandleRegistry != null && (accessorRegistry = fileHandleRegistry.getOrCreate(accessorClass)) != null) {
                    Collection fileHandleRegistrations = accessorRegistry.getRegistrations();
                    return fileHandleRegistrations;
                }
                fileHandleAncestor = fileHandleAncestor.getParentFileHandle();
            }
        }
        return null;
    }

    private Map<URI, String> getReverseRegistrations(Collection<? extends Registration<?>> registrations) {
        HashMap<URI, String> result = new HashMap<URI, String>();
        for (Registration<?> registration : registrations) {
            result.put(registration.getURI(), registration.getAccessorName());
        }
        return result;
    }

    private File getURIFile(URI uri) {
        Path absolutePath = null;
        if (uri.isPlatform()) {
            Path relativePath = new Path(uri.toPlatformString(true));
            absolutePath = DeclarativeQVTMainTab.getWorkspaceRoot().getLocation().append((IPath)relativePath);
            return absolutePath.toFile();
        }
        if (uri.isFile()) {
            absolutePath = new Path(uri.toFileString());
        }
        if (absolutePath != null) {
            return absolutePath.toFile();
        }
        return null;
    }

    private static IPath getExecutablePath(IProject project, IFile sourceFile, String direction) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath srcContainer = null;
        IPath currentTransformationPath = sourceFile.getFullPath();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath classPathEntryPath;
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3 && (classPathEntryPath = classpathEntry.getPath()).isPrefixOf(currentTransformationPath)) {
                    srcContainer = classpathEntry.getPath();
                }
                ++n2;
            }
            IPath relativeTransformationPath = currentTransformationPath.removeFirstSegments(srcContainer.segmentCount());
            IPath binPath = javaProject.getOutputLocation();
            IPath relativeExecutablePath = binPath.append(relativeTransformationPath).removeFileExtension().addFileExtension(direction).addFileExtension("asm");
            IPath absoluteExecutablePath = DeclarativeQVTMainTab.getWorkspaceRoot().getLocation().append(relativeExecutablePath);
            return absoluteExecutablePath;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IFile getSourceFile(String executablePath) {
        try {
            IFile executableFile = DeclarativeQVTMainTab.getFileFromURI(executablePath);
            IJavaProject javaProject = JavaCore.create((IProject)executableFile.getProject());
            IPath executableRelativePath = executableFile.getFullPath().removeFirstSegments(javaProject.getOutputLocation().segmentCount());
            IPath sourceRelativePath = executableRelativePath.removeFileExtension().removeFileExtension().addFileExtension("qvtr");
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3) {
                    IPath classPathPath = classpathEntry.getPath();
                    IFolder classPathFolder = DeclarativeQVTMainTab.getWorkspaceRoot().getFolder(classPathPath);
                    IFile searchedFile = classPathFolder.getFile(sourceRelativePath);
                    if (searchedFile.exists()) {
                        return searchedFile;
                    }
                }
                ++n2;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.currentProject != null && this.currentTransformationFile != null) {
            Collection<? extends Registration<?>> registrations = this.getMetamodelRegistrations();
            Map<URI, String> reverseRegistrations = this.getReverseRegistrations(registrations);
            String direction = null;
            ArrayList<String> modelNameList = new ArrayList<String>();
            ArrayList<String> modelPathList = new ArrayList<String>();
            ArrayList<String> metamodelNameList = new ArrayList<String>();
            ArrayList<String> metamodelPathList = new ArrayList<String>();
            for (Map.Entry<String, List<Widget>> entry : this.dynamicModelsWidget.entrySet()) {
                List<Widget> widgetList = entry.getValue();
                String modelName = entry.getKey();
                modelNameList.add(modelName);
                String modelFileURIString = this.getModelFileURIString(widgetList);
                modelPathList.add(modelFileURIString);
                if (this.isTargetModel(widgetList)) {
                    direction = modelName;
                }
                if (this.currentRelationalTransformation == null) continue;
                TypedModel typedModel = this.currentRelationalTransformation.getModelParameter(modelName);
                for (EPackage ePackage : typedModel.getUsedPackage()) {
                    URI metamodelURI = ePackage.eResource().getURI();
                    metamodelNameList.add(reverseRegistrations.get(metamodelURI));
                    metamodelPathList.add(this.getModelFileURIString(metamodelURI));
                }
            }
            String absoluteExecutablePath = DeclarativeQVTMainTab.getExecutablePath(this.currentProject, this.currentTransformationFile, direction).toString();
            configuration.setAttribute("QVTExecutableAttributeName", absoluteExecutablePath);
            configuration.setAttribute("QVTModelNamesAttributeName", modelNameList);
            configuration.setAttribute("QVTModelPathsAttributeName", modelPathList);
            configuration.setAttribute("QVTMetamodelNamesAttributeName", metamodelNameList);
            configuration.setAttribute("QVTMetamodelPathsAttributeName", metamodelPathList);
            configuration.setAttribute("QVTDirectionmodelPathsAttributeName", direction);
            configuration.setAttribute("QVTExecutionModeAttributeName", "enforcement");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        System.out.println("setDefaults");
    }

    private boolean isProjectValid() {
        String projectTextValue = this.projectText.getText().trim();
        if (projectTextValue.length() == 0) {
            this.setErrorMessage("No project specified.");
            return false;
        }
        if (this.getCurrentProject() == null) {
            this.setErrorMessage("Project " + projectTextValue + " does not exit.");
            return false;
        }
        return true;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!this.isProjectValid()) {
            return false;
        }
        String transformationTextValue = this.transformationText.getText().trim();
        if (transformationTextValue.length() == 0) {
            this.setErrorMessage("No transformation specified");
            return false;
        }
        for (Map.Entry<String, List<Widget>> modelEditor : this.dynamicModelsWidget.entrySet()) {
            List<Widget> wigetList = modelEditor.getValue();
            if (this.getModelPathWiget(wigetList).getText().trim().length() != 0) continue;
            this.setErrorMessage("Path to model " + modelEditor.getKey() + " not specified");
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage("Launch Declarative QVT Transformation");
        return true;
    }

    private class ModelButtonSelectionListener
    implements SelectionListener {
        Text relatedText;
        int style;

        public ModelButtonSelectionListener(Text relatedText, int style) {
            this.relatedText = relatedText;
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ResourceDialog rd = new ResourceDialog(DeclarativeQVTMainTab.this.getShell(), "Model Selection", this.style | 4);
            rd.open();
            if (rd.getReturnCode() == 0) {
                this.relatedText.setText(rd.getURIText());
            }
            DeclarativeQVTMainTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class TargetButtonSelectionListener
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            for (Map.Entry entry : DeclarativeQVTMainTab.this.dynamicModelsWidget.entrySet()) {
                List widgetList = (List)entry.getValue();
                Widget widget = (Widget)widgetList.get(3);
                if (!(widget instanceof Button)) continue;
                Button newModelButton = (Button)widget;
                if (e.getSource() == widgetList.get(0)) {
                    newModelButton.setEnabled(true);
                    continue;
                }
                newModelButton.setEnabled(false);
            }
        }
    }

    private class TransformationSelectionListener
    implements SelectionListener {
        Composite parent = null;

        public TransformationSelectionListener(Composite parent) {
            this.parent = parent;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            DeclarativeQVTMainTab.this.currentRelationalTransformation = DeclarativeQVTMainTab.this.handleSearchButtonSelected();
            if (DeclarativeQVTMainTab.this.currentRelationalTransformation != null) {
                DeclarativeQVTMainTab.this.createAllModelEditors(this.parent, DeclarativeQVTMainTab.this.currentRelationalTransformation);
            }
            DeclarativeQVTMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

