/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.outline;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OutlineViewerInputTest
extends AbstractTestWithProject {
    @Test
    public void testDocumentURIAbsolutePathForWorkspaceFile() throws CoreException, IOException {
        IProject project = TestUtils.createProject("testProject" + System.currentTimeMillis());
        IFile testFile = TestUtils.createUniqueTestFile(project, "test content for outline");
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        LSSymbolsContentProvider.OutlineViewerInput outlineInput = new LSSymbolsContentProvider.OutlineViewerInput(document, null, null);
        URI documentURI = this.getDocumentURI(outlineInput);
        Assertions.assertNotNull((Object)documentURI, (String)"documentURI should not be null");
        Assertions.assertTrue((boolean)"file".equals(documentURI.getScheme()));
        Assertions.assertTrue((boolean)documentURI.toString().startsWith("file:///"));
        String workspaceFileLocation = testFile.getLocation().toString();
        Assertions.assertTrue((boolean)documentURI.toString().contains(workspaceFileLocation), (String)"documentURI should contain the abolute path in the file system");
    }

    @Test
    public void testDocumentURIAbsolutePathForExternalFile() throws IOException, CoreException {
        File tempFile = TestUtils.createTempFile("externalTest" + System.currentTimeMillis(), ".lspt");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter fileWriter = new FileWriter(tempFile);){
            fileWriter.write("external file content for testing absolute paths");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ITextEditor editor = (ITextEditor)TestUtils.openExternalFileInEditor(tempFile);
        IDocument document = LSPEclipseUtils.getDocument((ITextEditor)editor);
        LSSymbolsContentProvider.OutlineViewerInput outlineInput = new LSSymbolsContentProvider.OutlineViewerInput(document, null, editor);
        URI documentURI = this.getDocumentURI(outlineInput);
        Assertions.assertNotNull((Object)documentURI, (String)"DocumentURI should not be null for external files");
        Assertions.assertTrue((boolean)"file".equals(documentURI.getScheme()));
        Assertions.assertTrue((boolean)documentURI.toString().startsWith("file:///"));
        Assertions.assertTrue((boolean)documentURI.toString().contains(tempFile.getAbsolutePath().replace("\\", "/")), (String)"documentURI should contain the abolute path in the file system");
    }

    private URI getDocumentURI(LSSymbolsContentProvider.OutlineViewerInput outlineInput) {
        try {
            Field field = LSSymbolsContentProvider.OutlineViewerInput.class.getDeclaredField("documentURI");
            field.setAccessible(true);
            return (URI)field.get(outlineInput);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access documentURI field", e);
        }
    }
}

