/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunNetworkModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RunImageNetworkTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "RunNetworkTab.name";
    private static final int COLUMNS = 3;
    private final DataBindingContext dbc = new DataBindingContext();
    private final ImageRunNetworkModel model;
    private Control containerControl;
    private Control otherControl;

    public RunImageNetworkTab(ImageRunNetworkModel model) {
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        if (this.model == null) {
            this.setErrorMessage(LaunchMessages.getString("NoConnectionError.msg"));
        } else {
            this.setErrorMessage(null);
            this.createNetworkSettingsSection(container);
        }
        this.setControl((Control)container);
    }

    private void createNetworkSettingsSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().spacing(10, 2).applyTo(container);
        Label modeLabel = new Label(container, 0);
        modeLabel.setText(WizardMessages.getString("ImageRunNetworkPage.mode"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)modeLabel);
        int COLUMNS = 2;
        int INDENT = 20;
        Composite subContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).indent(20, 0).span(2, 1).grab(true, false).applyTo((Control)subContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).spacing(10, 5).applyTo(subContainer);
        modeLabel.setEnabled(true);
        Button defaultButton = new Button(subContainer, 16);
        this.bindButton(defaultButton, "");
        defaultButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.default"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)defaultButton);
        Button bridgeButton = new Button(subContainer, 16);
        bridgeButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.bridge"));
        this.bindButton(bridgeButton, "bridge");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)bridgeButton);
        Button hostButton = new Button(subContainer, 16);
        hostButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.host"));
        this.bindButton(hostButton, "host");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)hostButton);
        Button noneButton = new Button(subContainer, 16);
        noneButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.none"));
        this.bindButton(noneButton, "none");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)noneButton);
        Button containerButton = new Button(subContainer, 16);
        containerButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.container"));
        this.bindButton(containerButton, "container");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)containerButton);
        Combo containerList = new Combo(subContainer, 12);
        this.setContainerControl((Control)containerList);
        containerList.setItems(this.model.getContainerNames().toArray(new String[0]));
        if (containerList.getItemCount() > 0) {
            containerList.select(0);
        }
        containerList.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)containerList);
        this.dbc.bindList((IObservableList)WidgetProperties.items().observe((Widget)containerList), BeanProperties.list(ImageRunNetworkModel.class, (String)"containerNames").observe((Object)this.model));
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)containerList), BeanProperties.value(ImageRunNetworkModel.class, (String)"selectedContainer").observe((Object)this.model));
        containerButton.addSelectionListener(this.onContainerSelection(containerButton, containerList));
        Button otherButton = new Button(subContainer, 16);
        otherButton.setText(WizardMessages.getString("ImageRunNetworkPage.mode.other"));
        this.bindButton(otherButton, "other");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)otherButton);
        Text otherText = new Text(subContainer, 2052);
        this.setOtherControl((Control)otherText);
        otherText.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)otherText);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)otherText), BeanProperties.value(ImageRunNetworkModel.class, (String)"otherString").observe((Object)this.model));
        otherButton.addSelectionListener(this.onOtherSelection(otherButton, otherText));
    }

    private Control getContainerControl() {
        return this.containerControl;
    }

    private void setContainerControl(Control containerControl) {
        this.containerControl = containerControl;
    }

    private Control getOtherControl() {
        return this.otherControl;
    }

    private void setOtherControl(Control containerControl) {
        this.otherControl = containerControl;
    }

    private Binding bindButton(Button button, final String strValue) {
        return this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)button), BeanProperties.value(ImageRunNetworkModel.class, (String)"networkMode").observe((Object)this.model), (UpdateValueStrategy)new UpdateValueStrategy<Object, Object>(this){

            public Object convert(Object value) {
                if (value.equals(Boolean.TRUE)) {
                    return strValue;
                }
                return null;
            }
        }, (UpdateValueStrategy)new UpdateValueStrategy<Object, Object>(this){

            public Object convert(Object value) {
                return value.equals(strValue);
            }
        });
    }

    private SelectionListener onContainerSelection(Button containerButton, Combo containerList) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            boolean selection = containerButton.getSelection();
            containerList.setEnabled(selection);
        });
    }

    private SelectionListener onOtherSelection(Button otherButton, Text otherText) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            boolean selection = otherButton.getSelection();
            otherText.setEnabled(selection);
        });
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.linuxtools.docker.ui.network_tab.gif");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.model == null) {
            return;
        }
        try {
            String networkModeString = configuration.getAttribute("networkMode", "");
            if (networkModeString.startsWith("container")) {
                String[] token = networkModeString.split(":");
                this.model.setNetworkMode("container");
                if (token.length > 1) {
                    this.model.setSelectedContainer(token[1]);
                }
                this.getContainerControl().setEnabled(true);
            } else {
                switch (networkModeString) {
                    case "bridge": 
                    case "host": 
                    case "none": 
                    case "": {
                        this.model.setNetworkMode(networkModeString);
                        break;
                    }
                    default: {
                        this.model.setNetworkMode("other");
                        this.model.setOtherString(networkModeString);
                        this.getOtherControl().setEnabled(true);
                    }
                }
            }
            this.model.addPropertyChangeListener(new LaunchConfigurationChangeListener());
        }
        catch (CoreException e) {
            Activator.logErrorMessage(LaunchMessages.getString("RunDockerImageLaunchConfiguration.load.failure"), e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.model == null) {
            return;
        }
        configuration.setAttribute("networkMode", this.model.getNetworkModeString());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            if (this.model == null) {
                return false;
            }
            if (this.model.getNetworkMode().equals("container") && ((Combo)this.getContainerControl()).getText().isEmpty()) {
                this.setWarningMessage(WizardMessages.getString("WarningNoContainerSelected.msg"));
                return false;
            }
            if (this.model.getNetworkMode().equals("other") && ((Text)this.getOtherControl()).getText().isEmpty()) {
                this.setWarningMessage(WizardMessages.getString("WarningOtherFieldEmpty.msg"));
                return false;
            }
        }
        catch (Exception e) {
            Activator.log(e);
            return false;
        }
        this.setWarningMessage(null);
        return true;
    }

    public String getName() {
        return LaunchMessages.getString(TAB_NAME);
    }

    private class LaunchConfigurationChangeListener
    implements PropertyChangeListener {
        private LaunchConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RunImageNetworkTab.this.updateLaunchConfigurationDialog();
        }
    }
}

