/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.EditDockerConnectionPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditDockerConnectionPage
extends WizardPage {
    private final DataBindingContext dbc;
    private final EditDockerConnectionPageModel model;

    public EditDockerConnectionPage(IDockerConnection currentConnection) {
        super("DockerConnectionPage", WizardMessages.getString("DockerConnectionPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("DockerConnectionPage.msg"));
        this.model = new EditDockerConnectionPageModel(currentConnection);
        this.dbc = new DataBindingContext();
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollTop = new ScrolledComposite(parent, 768);
        scrollTop.setExpandVertical(true);
        scrollTop.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrollTop, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        this.createConnectionSettingsContainer(container);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        scrollTop.setContent((Control)container);
        Point point = container.computeSize(-1, -1);
        scrollTop.setSize(point);
        scrollTop.setMinSize(point);
        this.setControl((Control)container);
    }

    public void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.dispose();
    }

    private void createConnectionSettingsContainer(Composite parent) {
        int COLUMNS = 3;
        int INDENT = 20;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).spacing(10, 2).applyTo(container);
        Label connectionNameLabel = new Label(container, 0);
        connectionNameLabel.setText(WizardMessages.getString("DockerConnectionPage.nameLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)connectionNameLabel);
        Text connectionNameText = new Text(container, 2048);
        connectionNameText.setToolTipText(WizardMessages.getString("DockerConnectionPage.nameTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)connectionNameText);
        Button unixSocketBindingModeButton = new Button(container, 16);
        unixSocketBindingModeButton.setText(WizardMessages.getString("DockerConnectionPage.unixSocket"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(0, 10).span(3, 1).applyTo((Control)unixSocketBindingModeButton);
        Label unixSocketPathLabel = new Label(container, 0);
        unixSocketPathLabel.setText(WizardMessages.getString("DockerConnectionPage.location"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).applyTo((Control)unixSocketPathLabel);
        Text unixSocketPathText = new Text(container, 2048);
        unixSocketPathText.setToolTipText(WizardMessages.getString("DockerConnectionPage.unixPathTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)unixSocketPathText);
        Button unixSocketPathBrowseButton = new Button(container, 524288);
        unixSocketPathBrowseButton.setText(WizardMessages.getString("DockerConnectionPage.browseButton"));
        unixSocketPathBrowseButton.addSelectionListener(this.onBrowseUnixSocketPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)unixSocketPathBrowseButton);
        Button tcpConnectionBindingModeButton = new Button(container, 16);
        tcpConnectionBindingModeButton.setText(WizardMessages.getString("DockerConnectionPage.tcpConnection"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)tcpConnectionBindingModeButton);
        Label tcpHostLabel = new Label(container, 0);
        tcpHostLabel.setText(WizardMessages.getString("DockerConnectionPage.hostLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).applyTo((Control)tcpHostLabel);
        Text tcpHostText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)tcpHostText);
        Button tcpAuthButton = new Button(container, 32);
        tcpAuthButton.setText(WizardMessages.getString("DockerConnectionPage.tcpAuthButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).span(3, 1).applyTo((Control)tcpAuthButton);
        Label tcpCertPathLabel = new Label(container, 0);
        tcpCertPathLabel.setText(WizardMessages.getString("DockerConnectionPage.tcpPathLabel"));
        tcpCertPathLabel.setToolTipText(WizardMessages.getString("DockerConnectionPage.tcpPathTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, 0).applyTo((Control)tcpCertPathLabel);
        Text tcpCertPathText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)tcpCertPathText);
        Button tcpCertPathBrowseButton = new Button(container, 524288);
        tcpCertPathBrowseButton.setText(WizardMessages.getString("DockerConnectionPage.browseButton"));
        tcpCertPathBrowseButton.addSelectionListener(this.onBrowseTcpCertPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)tcpCertPathBrowseButton);
        Button testConnectionButton = new Button(container, 0);
        testConnectionButton.setText(WizardMessages.getString("DockerConnectionPage.testConnection"));
        GridDataFactory.fillDefaults().span(3, 1).indent(0, 10).align(0x1000008, 0x1000000).applyTo((Control)testConnectionButton);
        testConnectionButton.addSelectionListener(this.onTestConnectionButtonSelection());
        IObservableValue connectionNameModelObservable = BeanProperties.value(EditDockerConnectionPageModel.class, (String)"connectionName", String.class).observe((Object)this.model);
        IObservableValue unixSocketBindingModeModelObservable = BeanProperties.value(EditDockerConnectionPageModel.class, (String)"unixSocketBindingMode", Boolean.class).observe((Object)this.model);
        IObservableValue unixSocketPathModelObservable = BeanProperties.value(EditDockerConnectionPageModel.class, (String)"unixSocketPath", String.class).observe((Object)this.model);
        IObservableValue tcpConnectionBindingModeModelObservable = BeanProperties.value(EditDockerConnectionPageModel.class, (String)"tcpConnectionBindingMode", Boolean.class).observe((Object)this.model);
        IObservableValue tcpCertPathModelObservable = BeanProperties.value(EditDockerConnectionPageModel.class, (String)"tcpCertPath", String.class).observe((Object)this.model);
        IObservableValue tcpTlsVerifyModelObservable = BeanProperties.value(EditDockerConnectionPageModel.class, (String)"tcpTLSVerify", Boolean.class).observe((Object)this.model);
        IObservableValue tcpHostModelObservable = BeanProperties.value(EditDockerConnectionPageModel.class, (String)"tcpHost", String.class).observe((Object)this.model);
        Control[] unixSocketControls = new Control[]{unixSocketPathText, unixSocketPathLabel, unixSocketPathBrowseButton};
        Control[] tcpConnectionControls = new Control[]{tcpHostText, tcpHostLabel, tcpAuthButton};
        Control[] tcpAuthControls = new Control[]{tcpCertPathText, tcpCertPathLabel, tcpCertPathBrowseButton};
        unixSocketBindingModeModelObservable.addChangeListener(this.onUnixSocketBindingSelection(unixSocketControls));
        tcpConnectionBindingModeModelObservable.addChangeListener(this.onTcpConnectionBindingSelection(tcpConnectionControls, tcpAuthControls));
        tcpTlsVerifyModelObservable.addValueChangeListener(this.onTcpAuthSelection(tcpAuthControls));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)connectionNameText), connectionNameModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)unixSocketBindingModeButton), unixSocketBindingModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)unixSocketPathText), unixSocketPathModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)tcpConnectionBindingModeButton), tcpConnectionBindingModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)tcpHostText), tcpHostModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)tcpAuthButton), tcpTlsVerifyModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)tcpCertPathText), tcpCertPathModelObservable);
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new ConnectionNameValidator((IObservableValue<String>)connectionNameModelObservable, this.model.getInitialConnectionName()));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new UnixSocketValidator((IObservableValue<Boolean>)unixSocketBindingModeModelObservable, (IObservableValue<String>)unixSocketPathModelObservable));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new TcpHostValidator((IObservableValue<Boolean>)tcpConnectionBindingModeModelObservable, (IObservableValue<String>)tcpHostModelObservable));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new TcpCertificatesValidator((IObservableValue<Boolean>)tcpConnectionBindingModeModelObservable, (IObservableValue<Boolean>)tcpTlsVerifyModelObservable, (IObservableValue<String>)tcpCertPathModelObservable));
        connectionNameText.setFocus();
        this.updateWidgetsState(unixSocketControls, tcpConnectionControls, tcpAuthControls);
    }

    private SelectionListener onBrowseUnixSocketPath() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog fileDialog = new FileDialog(this.getShell());
            String selectedPath = fileDialog.open();
            if (selectedPath != null) {
                this.model.setUnixSocketPath("unix://" + selectedPath);
            }
        });
    }

    private SelectionListener onBrowseTcpCertPath() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
            directoryDialog.setFilterPath(this.model.getTcpCertPath());
            String selectedPath = directoryDialog.open();
            if (selectedPath != null) {
                this.model.setTcpCertPath(selectedPath);
            }
        });
    }

    private void updateWidgetsState(Control[] unixSocketControls, Control[] tcpConnectionControls, Control[] tcpAuthControls) {
        this.setWidgetsEnabled(this.model.isTcpConnectionBindingMode() && this.model.isTcpTLSVerify(), tcpAuthControls);
        this.setWidgetsEnabled(this.model.isTcpConnectionBindingMode(), tcpConnectionControls);
        this.setWidgetsEnabled(this.model.isUnixSocketBindingMode(), unixSocketControls);
    }

    private IChangeListener onUnixSocketBindingSelection(Control[] unixSocketControls) {
        return event -> this.setWidgetsEnabled(this.model.isUnixSocketBindingMode(), unixSocketControls);
    }

    private IChangeListener onTcpConnectionBindingSelection(Control[] tcpConnectionControls, Control[] tcpAuthControls) {
        return event -> {
            this.setWidgetsEnabled(this.model.isTcpConnectionBindingMode() && this.model.isTcpTLSVerify(), tcpAuthControls);
            this.setWidgetsEnabled(this.model.isTcpConnectionBindingMode(), tcpConnectionControls);
        };
    }

    private IValueChangeListener<Boolean> onTcpAuthSelection(Control[] tcpAuthControls) {
        return event -> this.setWidgetsEnabled(this.model.isTcpConnectionBindingMode() && this.model.isTcpTLSVerify(), tcpAuthControls);
    }

    private void setWidgetsEnabled(boolean enabled, Control ... controls) {
        for (Control control : controls) {
            control.setEnabled(enabled);
        }
        if (enabled) {
            for (Control control : controls) {
                if (!(control instanceof Text)) continue;
                control.setFocus();
                break;
            }
        }
    }

    private SelectionListener onTestConnectionButtonSelection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    EditDockerConnectionPage.this.getWizard().getContainer().run(true, false, monitor -> {
                        monitor.beginTask(WizardMessages.getString("DockerConnectionPage.pingTask"), -1);
                        try (DockerConnection dockerConnection = EditDockerConnectionPage.this.getDockerConnection();){
                            dockerConnection.open(false);
                            this.displaySuccessDialog();
                        }
                        catch (DockerException e) {
                            if (e.getCause() != null) {
                                this.displayErrorDialog(e.getCause());
                            }
                            this.displayErrorDialog(e);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException o_O) {
                    Activator.log(o_O);
                }
            }

            private void displaySuccessDialog() {
                this.displayDialog(WizardMessages.getString("DockerConnectionPage.success"), WizardMessages.getString("DockerConnectionPage.pingSuccess"), 2, new String[]{WizardMessages.getString("DockerConnectionPage.ok")});
            }

            private void displayErrorDialog(Throwable cause) {
                this.displayDialog(WizardMessages.getString("DockerConnectionPage.failure"), WizardMessages.getFormattedString("DockerConnectionPage.pingFailure", cause.getMessage()), 1, new String[]{WizardMessages.getString("DockerConnectionPage.ok")});
            }

            private void displayDialog(String dialogTitle, String dialogMessage, int icon, String[] buttonLabels) {
                Display.getDefault().syncExec(() -> new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dialogTitle, null, dialogMessage, icon, buttonLabels, 0).open());
            }
        };
    }

    protected DockerConnection getDockerConnection() {
        if (this.model.getBindingMode() == EnumDockerConnectionSettings.UNIX_SOCKET) {
            return new DockerConnection.Builder().name(this.model.getConnectionName()).unixSocketConnection(new UnixSocketConnectionSettings(this.model.getUnixSocketPath()));
        }
        return new DockerConnection.Builder().name(this.model.getConnectionName()).tcpConnection(new TCPConnectionSettings(this.model.getTcpHost(), this.model.getTcpCertPath()));
    }

    private static class ConnectionNameValidator
    extends MultiValidator {
        private final IObservableValue<String> connectionNameModelObservable;
        private final String initialConnectionName;

        public ConnectionNameValidator(IObservableValue<String> connectionNameModelObservable, String initialConnectionName) {
            this.connectionNameModelObservable = connectionNameModelObservable;
            this.initialConnectionName = initialConnectionName;
        }

        public IObservableList<IObservable> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.connectionNameModelObservable);
            return targets;
        }

        protected IStatus validate() {
            String connectionName = (String)this.connectionNameModelObservable.getValue();
            if (connectionName == null || connectionName.isEmpty()) {
                return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.missingConnectionName.msg"));
            }
            if (!connectionName.equals(this.initialConnectionName) && DockerConnectionManager.getInstance().findConnection(connectionName) != null) {
                return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.duplicateConnectionName.msg"));
            }
            return ValidationStatus.ok();
        }
    }

    private static class UnixSocketValidator
    extends MultiValidator {
        private final IObservableValue<Boolean> unixSocketBindingModeModelObservable;
        private final IObservableValue<String> unixSocketPathModelObservable;

        public UnixSocketValidator(IObservableValue<Boolean> unixSocketBindingModeModelObservable, IObservableValue<String> unixSocketPathModelObservable) {
            this.unixSocketBindingModeModelObservable = unixSocketBindingModeModelObservable;
            this.unixSocketPathModelObservable = unixSocketPathModelObservable;
        }

        public IObservableList<IObservable> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.unixSocketPathModelObservable);
            return targets;
        }

        protected IStatus validate() {
            block8: {
                Boolean unixSocketBindingMode = (Boolean)this.unixSocketBindingModeModelObservable.getValue();
                String unixSocketPath = (String)this.unixSocketPathModelObservable.getValue();
                if (unixSocketBindingMode.booleanValue()) {
                    if (unixSocketPath == null || unixSocketPath.isEmpty()) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.missingUnixSocket.msg"));
                    }
                    try {
                        URI unixSocketURI = new URI(unixSocketPath);
                        if (unixSocketURI.getScheme() != null && !unixSocketURI.getScheme().equals("unix")) {
                            return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidUnixSocketScheme.msg"));
                        }
                        if (unixSocketURI.getPath() != null) {
                            File unixSocket = new File(unixSocketURI.getPath());
                            if (!unixSocket.exists()) {
                                return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                            }
                            if (!unixSocket.canRead() || !unixSocket.canWrite()) {
                                return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.unreadableUnixSocket.msg"));
                            }
                            break block8;
                        }
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                    }
                    catch (URISyntaxException e) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                    }
                }
            }
            return ValidationStatus.ok();
        }
    }

    private static class TcpHostValidator
    extends MultiValidator {
        private final IObservableValue<Boolean> tcpConnectionBindingModeModelObservable;
        private final IObservableValue<String> tcpHostModelObservable;

        public TcpHostValidator(IObservableValue<Boolean> tcpConnectionBindingModeModelObservable, IObservableValue<String> tcpHostModelObservable) {
            this.tcpConnectionBindingModeModelObservable = tcpConnectionBindingModeModelObservable;
            this.tcpHostModelObservable = tcpHostModelObservable;
        }

        public IObservableList<IObservable> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.tcpHostModelObservable);
            return targets;
        }

        protected IStatus validate() {
            Boolean tcpConnectionBindingMode = (Boolean)this.tcpConnectionBindingModeModelObservable.getValue();
            String tcpHost = (String)this.tcpHostModelObservable.getValue();
            if (tcpConnectionBindingMode.booleanValue()) {
                if (tcpHost == null || tcpHost.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.missingTcpConnectionURI.msg"));
                }
                try {
                    URI uri = new URI(tcpHost);
                    String scheme = uri.getScheme() != null ? uri.getScheme().toLowerCase() : null;
                    String host = uri.getHost();
                    int port = uri.getPort();
                    if (!(scheme == null || scheme.equals("tcp") || scheme.equals("http") || scheme.equals("https"))) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpConnectionScheme.msg"));
                    }
                    if (host == null) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpConnectionHost.msg"));
                    }
                    if (port == -1) {
                        return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpConnectionPort.msg"));
                    }
                }
                catch (URISyntaxException e) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpConnectionURI.msg"));
                }
            }
            return ValidationStatus.ok();
        }
    }

    private static class TcpCertificatesValidator
    extends MultiValidator {
        private final IObservableValue<Boolean> tcpConnectionBindingModeModelObservable;
        private final IObservableValue<Boolean> tcpTlsVerifyModelObservable;
        private final IObservableValue<String> tcpCertPathModelObservable;

        public TcpCertificatesValidator(IObservableValue<Boolean> tcpConnectionBindingModeModelObservable, IObservableValue<Boolean> tcpTlsVerifyModelObservable, IObservableValue<String> tcpCertPathModelObservable) {
            this.tcpConnectionBindingModeModelObservable = tcpConnectionBindingModeModelObservable;
            this.tcpTlsVerifyModelObservable = tcpTlsVerifyModelObservable;
            this.tcpCertPathModelObservable = tcpCertPathModelObservable;
        }

        public IObservableList<IObservable> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.tcpCertPathModelObservable);
            return targets;
        }

        protected IStatus validate() {
            Boolean tcpConnectionBindingMode = (Boolean)this.tcpConnectionBindingModeModelObservable.getValue();
            Boolean tcpTlsVerify = (Boolean)this.tcpTlsVerifyModelObservable.getValue();
            String tcpCertPath = (String)this.tcpCertPathModelObservable.getValue();
            if (tcpConnectionBindingMode.booleanValue() && tcpTlsVerify.booleanValue()) {
                if (tcpCertPath == null || tcpCertPath.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.missingTcpCertPath.msg"));
                }
                File tcpCert = new File(tcpCertPath);
                if (!tcpCert.exists()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.invalidTcpCertPath.msg"));
                }
                if (!tcpCert.canRead() || !tcpCert.canRead()) {
                    return ValidationStatus.error((String)WizardMessages.getString("DockerConnectionPage.validation.unreadableTcpCertPath.msg"));
                }
            }
            return ValidationStatus.ok();
        }
    }
}

