/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.ConjugateGradient;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.eclipse.january.dataset.AbstractCompoundDataset;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.SliceIterator;

public class LinearAlgebra {
    private static final int CROSSOVERPOINT = 16;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$january$dataset$LinearAlgebra$NormOrder;

    public static Dataset tensorDotProduct(Dataset a, Dataset b, int axisa, int axisb) {
        int[] ashape = a.getShapeRef();
        int[] bshape = b.getShapeRef();
        int arank = ashape.length;
        int brank = bshape.length;
        int aaxis = axisa;
        if (aaxis < 0) {
            aaxis += arank;
        }
        if (aaxis < 0 || aaxis >= arank) {
            throw new IllegalArgumentException("Summing axis outside valid rank of 1st dataset");
        }
        if (ashape[aaxis] < 16) {
            return LinearAlgebra.tensorDotProduct(a, b, new int[]{axisa}, new int[]{axisb});
        }
        int baxis = axisb;
        if (baxis < 0) {
            baxis += arank;
        }
        if (baxis < 0 || baxis >= arank) {
            throw new IllegalArgumentException("Summing axis outside valid rank of 2nd dataset");
        }
        boolean[] achoice = new boolean[arank];
        boolean[] bchoice = new boolean[brank];
        Arrays.fill(achoice, true);
        Arrays.fill(bchoice, true);
        achoice[aaxis] = false;
        bchoice[baxis] = false;
        boolean[] notachoice = new boolean[arank];
        boolean[] notbchoice = new boolean[brank];
        notachoice[aaxis] = true;
        notbchoice[baxis] = true;
        int drank = arank + brank - 2;
        int[] dshape = new int[drank];
        int d = 0;
        int i = 0;
        while (i < arank) {
            if (achoice[i]) {
                dshape[d++] = ashape[i];
            }
            ++i;
        }
        i = 0;
        while (i < brank) {
            if (bchoice[i]) {
                dshape[d++] = bshape[i];
            }
            ++i;
        }
        int dtype = DTypeUtils.getBestDType(a.getDType(), b.getDType());
        Dataset data = DatasetFactory.zeros(dshape, dtype);
        SliceIterator ita = a.getSliceIteratorFromAxes(null, achoice);
        int l = 0;
        int[] apos = ita.getPos();
        while (ita.hasNext()) {
            SliceIterator itb = b.getSliceIteratorFromAxes(null, bchoice);
            int[] bpos = itb.getPos();
            while (itb.hasNext()) {
                SliceIterator itaa = a.getSliceIteratorFromAxes(apos, notachoice);
                SliceIterator itba = b.getSliceIteratorFromAxes(bpos, notbchoice);
                double sum = 0.0;
                double com = 0.0;
                while (itaa.hasNext() && itba.hasNext()) {
                    double y = a.getElementDoubleAbs(itaa.index) * b.getElementDoubleAbs(itba.index) - com;
                    double t = sum + y;
                    com = t - sum - y;
                    sum = t;
                }
                data.setObjectAbs(l++, sum);
            }
        }
        return data;
    }

    public static Dataset tensorDotProduct(Dataset a, Dataset b, int[] axisa, int[] axisb) {
        if (axisa.length != axisb.length) {
            throw new IllegalArgumentException("Numbers of summing axes must be same");
        }
        int[] ashape = a.getShapeRef();
        int[] bshape = b.getShapeRef();
        int arank = ashape.length;
        int brank = bshape.length;
        int[] aaxes = new int[axisa.length];
        int[] baxes = new int[axisa.length];
        int i = 0;
        while (i < axisa.length) {
            int n = axisa[i];
            if (n < 0) {
                n += arank;
            }
            if (n < 0 || n >= arank) {
                throw new IllegalArgumentException("Summing axis outside valid rank of 1st dataset");
            }
            aaxes[i] = n;
            n = axisb[i];
            if (n < 0) {
                n += brank;
            }
            if (n < 0 || n >= brank) {
                throw new IllegalArgumentException("Summing axis outside valid rank of 2nd dataset");
            }
            baxes[i] = n;
            if (ashape[aaxes[i]] != bshape[n]) {
                throw new IllegalArgumentException("Summing axes do not have matching lengths");
            }
            ++i;
        }
        boolean[] achoice = new boolean[arank];
        boolean[] bchoice = new boolean[brank];
        Arrays.fill(achoice, true);
        Arrays.fill(bchoice, true);
        int i2 = 0;
        while (i2 < aaxes.length) {
            achoice[aaxes[i2]] = false;
            bchoice[baxes[i2]] = false;
            ++i2;
        }
        int drank = arank + brank - 2 * aaxes.length;
        int[] dshape = new int[drank];
        int d = 0;
        int i3 = 0;
        while (i3 < arank) {
            if (achoice[i3]) {
                dshape[d++] = ashape[i3];
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < brank) {
            if (bchoice[i3]) {
                dshape[d++] = bshape[i3];
            }
            ++i3;
        }
        int dtype = DTypeUtils.getBestDType(a.getDType(), b.getDType());
        Dataset data = DatasetFactory.zeros(dshape, dtype);
        SliceIterator ita = a.getSliceIteratorFromAxes(null, achoice);
        int l = 0;
        int[] apos = ita.getPos();
        while (ita.hasNext()) {
            SliceIterator itb = b.getSliceIteratorFromAxes(null, bchoice);
            int[] bpos = itb.getPos();
            while (itb.hasNext()) {
                double sum = 0.0;
                double com = 0.0;
                apos[aaxes[aaxes.length - 1]] = -1;
                bpos[baxes[aaxes.length - 1]] = -1;
                while (true) {
                    int e = aaxes.length - 1;
                    while (e >= 0) {
                        int ai = aaxes[e];
                        int bi = baxes[e];
                        int n = ai;
                        apos[n] = apos[n] + 1;
                        int n2 = bi;
                        bpos[n2] = bpos[n2] + 1;
                        if (apos[ai] != ashape[ai]) break;
                        apos[ai] = 0;
                        bpos[bi] = 0;
                        --e;
                    }
                    if (e == -1) break;
                    double y = a.getDouble(apos) * b.getDouble(bpos) - com;
                    double t = sum + y;
                    com = t - sum - y;
                    sum = t;
                }
                data.setObjectAbs(l++, sum);
            }
        }
        return data;
    }

    public static Dataset dotProduct(Dataset a, Dataset b) {
        if (b.getRank() < 2) {
            return LinearAlgebra.tensorDotProduct(a, b, -1, 0);
        }
        return LinearAlgebra.tensorDotProduct(a, b, -1, -2);
    }

    public static Dataset outerProduct(Dataset a, Dataset b) {
        int[] as = a.getShapeRef();
        int[] bs = b.getShapeRef();
        int rank = as.length + bs.length;
        int[] shape = new int[rank];
        int i = 0;
        while (i < as.length) {
            shape[i] = as[i];
            ++i;
        }
        i = 0;
        while (i < bs.length) {
            shape[as.length + i] = bs[i];
            ++i;
        }
        int isa = a.getElementsPerItem();
        int isb = b.getElementsPerItem();
        if (isa != 1 || isb != 1) {
            throw new UnsupportedOperationException("Compound datasets not supported");
        }
        Dataset o = DatasetFactory.zeros(shape, DTypeUtils.getBestDType(a.getDType(), b.getDType()));
        IndexIterator ita = a.getIterator();
        IndexIterator itb = b.getIterator();
        int j = 0;
        while (ita.hasNext()) {
            double va = a.getElementDoubleAbs(ita.index);
            while (itb.hasNext()) {
                o.setObjectAbs(j++, va * b.getElementDoubleAbs(itb.index));
            }
            itb.reset();
        }
        return o;
    }

    public static Dataset crossProduct(Dataset a, Dataset b) {
        return LinearAlgebra.crossProduct(a, b, -1, -1, -1);
    }

    public static Dataset crossProduct(Dataset a, Dataset b, int axisA, int axisB, int axisC) {
        int[] shapeB;
        int lb;
        int rankA = a.getRank();
        int rankB = b.getRank();
        if (rankA == 0 || rankB == 0) {
            throw new IllegalArgumentException("Datasets must have one or more dimensions");
        }
        if (axisA < 0) {
            axisA += rankA;
        }
        if (axisA < 0 || axisA >= rankA) {
            throw new IllegalArgumentException("Axis A argument exceeds rank");
        }
        if (axisB < 0) {
            axisB += rankB;
        }
        if (axisB < 0 || axisB >= rankB) {
            throw new IllegalArgumentException("Axis B argument exceeds rank");
        }
        int[] shapeA = a.getShape();
        int la = shapeA[axisA];
        if (Math.min(la, lb = (shapeB = b.getShape())[axisB]) < 2 || Math.max(la, lb) > 3) {
            throw new IllegalArgumentException("Chosen dimension of A & B must be 2 or 3");
        }
        if (Math.max(la, lb) == 2) {
            return LinearAlgebra.crossProduct2D(a, b, axisA, axisB);
        }
        return LinearAlgebra.crossProduct3D(a, b, axisA, axisB, axisC);
    }

    private static int[] removeAxisFromShape(int[] shape, int axis) {
        int[] s = new int[shape.length - 1];
        int i = 0;
        int j = 0;
        while (i < axis) {
            s[j++] = shape[i++];
        }
        ++i;
        while (i < shape.length) {
            s[j++] = shape[i++];
        }
        return s;
    }

    private static int[] removeAxesFromShape(int[] shape, int ... axes) {
        int n = axes.length;
        int[] s = new int[shape.length - n];
        int i = 0;
        int j = 0;
        int k = 0;
        while (k < n) {
            int a = axes[k];
            while (i < a) {
                s[j++] = shape[i++];
            }
            ++i;
            ++k;
        }
        while (i < shape.length) {
            s[j++] = shape[i++];
        }
        return s;
    }

    private static int[] addAxisToShape(int[] shape, int axis, int length) {
        int[] s = new int[shape.length + 1];
        int i = 0;
        int j = 0;
        while (i < axis) {
            s[j++] = shape[i++];
        }
        s[j++] = length;
        while (i < shape.length) {
            s[j++] = shape[i++];
        }
        return s;
    }

    private static int[] addAxesToShape(int[] shape, int[] axes, int[] lengths) {
        int n = axes.length;
        if (lengths.length != n) {
            throw new IllegalArgumentException("Axes and lengths arrays must be same size");
        }
        int[] s = new int[shape.length + n];
        int i = 0;
        int j = 0;
        int k = 0;
        while (k < n) {
            int a = axes[k];
            while (i < a) {
                s[j++] = shape[i++];
            }
            s[j++] = lengths[k];
            ++k;
        }
        while (i < shape.length) {
            s[j++] = shape[i++];
        }
        return s;
    }

    private static Dataset crossProduct2D(Dataset a, Dataset b, int axisA, int axisB) {
        int[] shapeA = LinearAlgebra.removeAxisFromShape(a.getShapeRef(), axisA);
        int[] shapeB = LinearAlgebra.removeAxisFromShape(b.getShapeRef(), axisB);
        List<int[]> fullShapes = BroadcastUtils.broadcastShapes(shapeA, shapeB);
        int[] maxShape = fullShapes.get(0);
        Dataset c = DatasetFactory.zeros(maxShape, DTypeUtils.getBestDType(a.getDType(), b.getDType()));
        PositionIterator ita = a.getPositionIterator(axisA);
        PositionIterator itb = b.getPositionIterator(axisB);
        IndexIterator itc = c.getIterator();
        int[] pa = ita.getPos();
        int[] pb = itb.getPos();
        while (itc.hasNext()) {
            if (!ita.hasNext()) {
                ita.reset();
            }
            if (!itb.hasNext()) {
                itb.reset();
            }
            pa[axisA] = 0;
            pb[axisB] = 1;
            double cv = a.getDouble(pa) * b.getDouble(pb);
            pa[axisA] = 1;
            pb[axisB] = 0;
            c.setObjectAbs(itc.index, cv -= a.getDouble(pa) * b.getDouble(pb));
        }
        return c;
    }

    /*
     * Unable to fully structure code
     */
    private static Dataset crossProduct3D(Dataset a, Dataset b, int axisA, int axisB, int axisC) {
        block12: {
            block11: {
                shapeA = LinearAlgebra.removeAxisFromShape(a.getShapeRef(), axisA);
                shapeB = LinearAlgebra.removeAxisFromShape(b.getShapeRef(), axisB);
                fullShapes = BroadcastUtils.broadcastShapes(new int[][]{shapeA, shapeB});
                maxShape = fullShapes.get(0);
                rankC = maxShape.length + 1;
                if (axisC < 0) {
                    axisC += rankC;
                }
                if (axisC < 0 || axisC >= rankC) {
                    throw new IllegalArgumentException("Axis C argument exceeds rank");
                }
                maxShape = LinearAlgebra.addAxisToShape(maxShape, axisC, 3);
                c = DatasetFactory.zeros(maxShape, DTypeUtils.getBestDType(a.getDType(), b.getDType()));
                ita = a.getPositionIterator(new int[]{axisA});
                itb = b.getPositionIterator(new int[]{axisB});
                itc = c.getPositionIterator(new int[]{axisC});
                pa = ita.getPos();
                pb = itb.getPos();
                pc = itc.getPos();
                la = a.getShapeRef()[axisA];
                lb = b.getShapeRef()[axisB];
                if (la != 2) break block11;
                while (itc.hasNext()) {
                    if (!ita.hasNext()) {
                        ita.reset();
                    }
                    if (!itb.hasNext()) {
                        itb.reset();
                    }
                    pa[axisA] = 1;
                    pb[axisB] = 2;
                    cv = a.getDouble(pa) * b.getDouble(pb);
                    pc[axisC] = 0;
                    c.set((Object)cv, pc);
                    pa[axisA] = 0;
                    pb[axisB] = 2;
                    cv = -a.getDouble(pa) * b.getDouble(pb);
                    pc[axisC] = 1;
                    c.set((Object)cv, pc);
                    pa[axisA] = 0;
                    pb[axisB] = 1;
                    cv = a.getDouble(pa) * b.getDouble(pb);
                    pa[axisA] = 1;
                    pb[axisB] = 0;
                    pc[axisC] = 2;
                    c.set((Object)(cv -= a.getDouble(pa) * b.getDouble(pb)), pc);
                }
                break block12;
            }
            if (lb != 2) ** GOTO lbl96
            while (itc.hasNext()) {
                if (!ita.hasNext()) {
                    ita.reset();
                }
                if (!itb.hasNext()) {
                    itb.reset();
                }
                pa[axisA] = 2;
                pb[axisB] = 1;
                cv = -a.getDouble(pa) * b.getDouble(pb);
                pc[axisC] = 0;
                c.set((Object)cv, pc);
                pa[axisA] = 2;
                pb[axisB] = 0;
                cv = a.getDouble(pa) * b.getDouble(pb);
                pc[axisC] = 1;
                c.set((Object)cv, pc);
                pa[axisA] = 0;
                pb[axisB] = 1;
                cv = a.getDouble(pa) * b.getDouble(pb);
                pa[axisA] = 1;
                pb[axisB] = 0;
                pc[axisC] = 2;
                c.set((Object)(cv -= a.getDouble(pa) * b.getDouble(pb)), pc);
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                if (!ita.hasNext()) {
                    ita.reset();
                }
                if (!itb.hasNext()) {
                    itb.reset();
                }
                pa[axisA] = 1;
                pb[axisB] = 2;
                cv = a.getDouble(pa) * b.getDouble(pb);
                pa[axisA] = 2;
                pb[axisB] = 1;
                pc[axisC] = 0;
                c.set((Object)(cv -= a.getDouble(pa) * b.getDouble(pb)), pc);
                pa[axisA] = 2;
                pb[axisB] = 0;
                cv = a.getDouble(pa) * b.getDouble(pb);
                pa[axisA] = 0;
                pb[axisB] = 2;
                pc[axisC] = 1;
                c.set((Object)(cv -= a.getDouble(pa) * b.getDouble(pb)), pc);
                pa[axisA] = 0;
                pb[axisB] = 1;
                cv = a.getDouble(pa) * b.getDouble(pb);
                pa[axisA] = 1;
                pb[axisB] = 0;
                pc[axisC] = 2;
                c.set((Object)(cv -= a.getDouble(pa) * b.getDouble(pb)), pc);
lbl96:
                // 2 sources

                ** while (itc.hasNext())
            }
        }
        return c;
    }

    public static Dataset power(Dataset a, int n) {
        if (n < 0) {
            LUDecomposition lud = new LUDecomposition(LinearAlgebra.createRealMatrix(a));
            return LinearAlgebra.createDataset(lud.getSolver().getInverse().power(-n));
        }
        Dataset p = LinearAlgebra.createDataset(LinearAlgebra.createRealMatrix(a).power(n));
        if (!a.hasFloatingPointElements()) {
            return p.cast(a.getDType());
        }
        return p;
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset kroneckerProduct(Dataset a, Dataset b) {
        block17: {
            if (a.getElementsPerItem() != 1 || b.getElementsPerItem() != 1) {
                throw new UnsupportedOperationException("Compound datasets (including complex ones) are not currently supported");
            }
            ar = a.getRank();
            br = b.getRank();
            aShape = a.getShapeRef();
            bShape = b.getShapeRef();
            r = ar;
            if (ar < br) {
                r = br;
                shape = new int[br];
                j = 0;
                i = ar;
                while (i < br) {
                    shape[j++] = 1;
                    ++i;
                }
                i = 0;
                while (j < br) {
                    shape[j++] = aShape[i++];
                }
                a = a.reshape(shape);
                aShape = shape;
            } else if (ar > br) {
                shape = new int[ar];
                j = 0;
                i = br;
                while (i < ar) {
                    shape[j++] = 1;
                    ++i;
                }
                i = 0;
                while (j < ar) {
                    shape[j++] = bShape[i++];
                }
                b = b.reshape(shape);
                bShape = shape;
            }
            nShape = new int[r];
            i = 0;
            while (i < r) {
                nShape[i] = aShape[i] * bShape[i];
                ++i;
            }
            kron = DatasetFactory.zeros(nShape, DTypeUtils.getBestDType(a.getDType(), b.getDType()));
            ita = a.getIterator(true);
            itb = b.getIterator(true);
            pa = ita.getPos();
            pb = itb.getPos();
            off = new int[1];
            stride = AbstractDataset.createStrides(1, nShape, null, 0, off);
            if (kron.getDType() != 4) ** GOTO lbl91
            while (ita.hasNext()) {
                av = a.getElementLongAbs(ita.index);
                ka = 0;
                i = 0;
                while (i < r) {
                    ka += stride[i] * bShape[i] * pa[i];
                    ++i;
                }
                itb.reset();
                while (itb.hasNext()) {
                    bv = b.getElementLongAbs(itb.index);
                    kb = ka;
                    i = 0;
                    while (i < r) {
                        kb += stride[i] * pb[i];
                        ++i;
                    }
                    kron.setObjectAbs(kb, av * bv);
                }
            }
            break block17;
lbl-1000:
            // 1 sources

            {
                av = a.getElementDoubleAbs(ita.index);
                ka = 0;
                i = 0;
                while (i < r) {
                    ka += stride[i] * bShape[i] * pa[i];
                    ++i;
                }
                itb.reset();
                while (itb.hasNext()) {
                    bv = b.getElementLongAbs(itb.index);
                    kb = ka;
                    i = 0;
                    while (i < r) {
                        kb += stride[i] * pb[i];
                        ++i;
                    }
                    kron.setObjectAbs(kb, av * bv);
                }
lbl91:
                // 2 sources

                ** while (ita.hasNext())
            }
        }
        return kron;
    }

    public static Dataset trace(Dataset a) {
        return LinearAlgebra.trace(a, 0, 0, 1);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset trace(Dataset a, int offset, int axis1, int axis2) {
        block15: {
            block14: {
                shape = a.getShapeRef();
                axes = new int[]{a.checkAxis(axis1), a.checkAxis(axis2)};
                Arrays.sort(axes);
                is = a.getElementsPerItem();
                trace = DatasetFactory.zeros(is, LinearAlgebra.removeAxesFromShape(shape, axes), a.getDType());
                am = axes[0];
                mmax = shape[am];
                an = axes[1];
                nmax = shape[an];
                it = new PositionIterator(shape, axes);
                pos = it.getPos();
                i = 0;
                if (offset >= 0) {
                    mmin = 0;
                    nmin = offset;
                } else {
                    mmin = -offset;
                    nmin = 0;
                }
                if (is != 1) break block14;
                if (a.getDType() != 4) ** GOTO lbl42
                while (it.hasNext()) {
                    m = mmin;
                    n = nmin;
                    s = 0L;
                    while (m < mmax && n < nmax) {
                        pos[am] = m++;
                        pos[an] = n++;
                        s += a.getLong(pos);
                    }
                    trace.setObjectAbs(i++, s);
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    m = mmin;
                    n = nmin;
                    s = 0.0;
                    while (m < mmax && n < nmax) {
                        pos[am] = m++;
                        pos[an] = n++;
                        s += a.getDouble(pos);
                    }
                    trace.setObjectAbs(i++, s);
lbl42:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl43:
                // 1 sources

                break block15;
            }
            ca = (AbstractCompoundDataset)a;
            if (ca instanceof CompoundLongDataset) {
                t = new long[is];
                s = new long[is];
                while (it.hasNext()) {
                    m = mmin;
                    n = nmin;
                    Arrays.fill(s, 0L);
                    while (m < mmax && n < nmax) {
                        pos[am] = m++;
                        pos[an] = n++;
                        ((CompoundLongDataset)ca).getAbs(ca.get1DIndex(pos), t);
                        k = 0;
                        while (k < is) {
                            v0 = k;
                            s[v0] = s[v0] + t[k];
                            ++k;
                        }
                    }
                    trace.setObjectAbs(i++, s);
                }
            } else {
                t = new double[is];
                s = new double[is];
                while (it.hasNext()) {
                    m = mmin;
                    n = nmin;
                    Arrays.fill(s, 0.0);
                    while (m < mmax && n < nmax) {
                        pos[am] = m++;
                        pos[an] = n++;
                        ca.getDoubleArray(t, pos);
                        k = 0;
                        while (k < is) {
                            v1 = k;
                            s[v1] = s[v1] + t[k];
                            ++k;
                        }
                    }
                    trace.setObjectAbs(i++, s);
                }
            }
        }
        return trace;
    }

    public static double norm(Dataset a) {
        return LinearAlgebra.norm(a, NormOrder.DEFAULT);
    }

    public static double norm(Dataset a, NormOrder order) {
        int r = a.getRank();
        if (r == 1) {
            return LinearAlgebra.vectorNorm(a, order);
        }
        if (r == 2) {
            return LinearAlgebra.matrixNorm(a, order);
        }
        throw new IllegalArgumentException("Rank of dataset must be one or two");
    }

    /*
     * Unable to fully structure code
     */
    private static double vectorNorm(Dataset a, NormOrder order) {
        switch (LinearAlgebra.$SWITCH_TABLE$org$eclipse$january$dataset$LinearAlgebra$NormOrder()[order.ordinal()]) {
            case 2: {
                throw new IllegalArgumentException("Not allowed for vectors");
            }
            case 4: 
            case 5: {
                it = a.getIterator();
                if (order != NormOrder.POS_INFINITY) ** GOTO lbl18
                n = -Infinity;
                if (!a.isComplex()) ** GOTO lbl16
                while (it.hasNext()) {
                    v = ((Complex)a.getObjectAbs(it.index)).abs();
                    n = Math.max(n, v);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    v = Math.abs(a.getElementDoubleAbs(it.index));
                    n = Math.max(n, v);
lbl16:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl17:
                // 1 sources

                break;
lbl18:
                // 1 sources

                n = Infinity;
                if (!a.isComplex()) ** GOTO lbl27
                while (it.hasNext()) {
                    v = ((Complex)a.getObjectAbs(it.index)).abs();
                    n = Math.min(n, v);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    v = Math.abs(a.getElementDoubleAbs(it.index));
                    n = Math.min(n, v);
lbl27:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl28:
                // 1 sources

                break;
            }
            case 3: {
                it = a.getIterator();
                n = 0.0;
                if (!a.isComplex()) ** GOTO lbl40
                while (it.hasNext()) {
                    if (((Complex)a.getObjectAbs(it.index)).equals((Object)Complex.ZERO)) continue;
                    n += 1.0;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    if (!a.getElementBooleanAbs(it.index)) continue;
                    n += 1.0;
lbl40:
                    // 3 sources

                    ** while (it.hasNext())
                }
lbl41:
                // 1 sources

                break;
            }
            default: {
                n = LinearAlgebra.vectorNorm(a, 2.0);
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private static double matrixNorm(Dataset a, NormOrder order) {
        switch (LinearAlgebra.$SWITCH_TABLE$org$eclipse$january$dataset$LinearAlgebra$NormOrder()[order.ordinal()]) {
            case 4: 
            case 5: {
                n = LinearAlgebra.maxMinMatrixNorm(a, 1, order == NormOrder.POS_INFINITY);
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Not allowed for matrices");
            }
            default: {
                it = a.getIterator();
                n = 0.0;
                if (!a.isComplex()) ** GOTO lbl18
                while (it.hasNext()) {
                    v = ((Complex)a.getObjectAbs(it.index)).abs();
                    n += v * v;
                }
                ** GOTO lbl19
lbl-1000:
                // 1 sources

                {
                    v = a.getElementDoubleAbs(it.index);
                    n += v * v;
lbl18:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl19:
                // 2 sources

                n = Math.sqrt(n);
            }
        }
        return n;
    }

    public static double norm(Dataset a, double p) {
        if (p == 0.0) {
            return LinearAlgebra.norm(a, NormOrder.ZERO);
        }
        int r = a.getRank();
        if (r == 1) {
            return LinearAlgebra.vectorNorm(a, p);
        }
        if (r == 2) {
            return LinearAlgebra.matrixNorm(a, p);
        }
        throw new IllegalArgumentException("Rank of dataset must be one or two");
    }

    /*
     * Unable to fully structure code
     */
    private static double vectorNorm(Dataset a, double p) {
        block5: {
            it = a.getIterator();
            n = 0.0;
            if (!a.isComplex()) ** GOTO lbl17
            while (it.hasNext()) {
                v = ((Complex)a.getObjectAbs(it.index)).abs();
                if (p == 2.0) {
                    v *= v;
                } else if (p != 1.0) {
                    v = Math.pow(v, p);
                }
                n += v;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                v = a.getElementDoubleAbs(it.index);
                v = p == 1.0 ? Math.abs(v) : (p == 2.0 ? (v *= v) : Math.pow(Math.abs(v), p));
                n += v;
lbl17:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return Math.pow(n, 1.0 / p);
    }

    private static double matrixNorm(Dataset a, double p) {
        double n;
        if (Math.abs(p) == 1.0) {
            n = LinearAlgebra.maxMinMatrixNorm(a, 0, p > 0.0);
        } else if (Math.abs(p) == 2.0) {
            double[] s = LinearAlgebra.calcSingularValues(a);
            n = p > 0.0 ? s[0] : s[s.length - 1];
        } else {
            throw new IllegalArgumentException("Order not allowed");
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private static double maxMinMatrixNorm(Dataset a, int d, boolean max) {
        block9: {
            block8: {
                it = a.getPositionIterator(new int[]{d});
                pos = it.getPos();
                l = a.getShapeRef()[d];
                if (!max) break block8;
                n = -Infinity;
                if (!a.isComplex()) ** GOTO lbl26
                while (it.hasNext()) {
                    v = ((Complex)a.getObject(pos)).abs();
                    i = 1;
                    while (i < l) {
                        pos[d] = i++;
                        v += ((Complex)a.getObject(pos)).abs();
                    }
                    pos[d] = 0;
                    n = Math.max(n, v);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    v = Math.abs(a.getDouble(pos));
                    i = 1;
                    while (i < l) {
                        pos[d] = i++;
                        v += Math.abs(a.getDouble(pos));
                    }
                    pos[d] = 0;
                    n = Math.max(n, v);
lbl26:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl27:
                // 1 sources

                break block9;
            }
            n = Infinity;
            if (!a.isComplex()) ** GOTO lbl50
            while (it.hasNext()) {
                v = ((Complex)a.getObject(pos)).abs();
                i = 1;
                while (i < l) {
                    pos[d] = i++;
                    v += ((Complex)a.getObject(pos)).abs();
                }
                pos[d] = 0;
                n = Math.min(n, v);
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                v = Math.abs(a.getDouble(pos));
                i = 1;
                while (i < l) {
                    pos[d] = i++;
                    v += Math.abs(a.getDouble(pos));
                }
                pos[d] = 0;
                n = Math.min(n, v);
lbl50:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return n;
    }

    public static double[] calcSingularValues(Dataset a) {
        SingularValueDecomposition svd = new SingularValueDecomposition(LinearAlgebra.createRealMatrix(a));
        return svd.getSingularValues();
    }

    public static Dataset[] calcSingularValueDecomposition(Dataset a) {
        SingularValueDecomposition svd = new SingularValueDecomposition(LinearAlgebra.createRealMatrix(a));
        return new Dataset[]{LinearAlgebra.createDataset(svd.getU()), DatasetFactory.createFromObject(svd.getSingularValues()), LinearAlgebra.createDataset(svd.getV())};
    }

    public static Dataset calcPseudoInverse(Dataset a) {
        SingularValueDecomposition svd = new SingularValueDecomposition(LinearAlgebra.createRealMatrix(a));
        return LinearAlgebra.createDataset(svd.getSolver().getInverse());
    }

    public static int calcMatrixRank(Dataset a) {
        SingularValueDecomposition svd = new SingularValueDecomposition(LinearAlgebra.createRealMatrix(a));
        return svd.getRank();
    }

    public static double calcConditionNumber(Dataset a) {
        SingularValueDecomposition svd = new SingularValueDecomposition(LinearAlgebra.createRealMatrix(a));
        return svd.getConditionNumber();
    }

    public static double calcDeterminant(Dataset a) {
        EigenDecomposition evd = new EigenDecomposition(LinearAlgebra.createRealMatrix(a));
        return evd.getDeterminant();
    }

    public static Dataset calcEigenvalues(Dataset a) {
        EigenDecomposition evd = new EigenDecomposition(LinearAlgebra.createRealMatrix(a));
        double[] rev = evd.getRealEigenvalues();
        if (evd.hasComplexEigenvalues()) {
            double[] iev = evd.getImagEigenvalues();
            return DatasetFactory.createComplexDataset(ComplexDoubleDataset.class, (Object)rev, (Object)iev);
        }
        return DatasetFactory.createFromObject(rev);
    }

    public static Dataset[] calcEigenDecomposition(Dataset a) {
        EigenDecomposition evd = new EigenDecomposition(LinearAlgebra.createRealMatrix(a));
        Dataset[] results = new Dataset[2];
        double[] rev = evd.getRealEigenvalues();
        if (evd.hasComplexEigenvalues()) {
            double[] iev = evd.getImagEigenvalues();
            results[0] = DatasetFactory.createComplexDataset(ComplexDoubleDataset.class, (Object)rev, (Object)iev);
        } else {
            results[0] = DatasetFactory.createFromObject(rev);
        }
        results[1] = LinearAlgebra.createDataset(evd.getV());
        return results;
    }

    public static Dataset[] calcQRDecomposition(Dataset a) {
        QRDecomposition qrd = new QRDecomposition(LinearAlgebra.createRealMatrix(a));
        return new Dataset[]{LinearAlgebra.createDataset(qrd.getQT()).getTransposedView(new int[0]), LinearAlgebra.createDataset(qrd.getR())};
    }

    public static Dataset[] calcLUDecomposition(Dataset a) {
        LUDecomposition lud = new LUDecomposition(LinearAlgebra.createRealMatrix(a));
        return new Dataset[]{LinearAlgebra.createDataset(lud.getL()), LinearAlgebra.createDataset(lud.getU()), LinearAlgebra.createDataset(lud.getP())};
    }

    public static Dataset calcInverse(Dataset a) {
        LUDecomposition lud = new LUDecomposition(LinearAlgebra.createRealMatrix(a));
        return LinearAlgebra.createDataset(lud.getSolver().getInverse());
    }

    public static Dataset solve(Dataset a, Dataset v) {
        LUDecomposition lud = new LUDecomposition(LinearAlgebra.createRealMatrix(a));
        if (v.getRank() == 1) {
            RealVector x = LinearAlgebra.createRealVector(v);
            return LinearAlgebra.createDataset(lud.getSolver().solve(x));
        }
        RealMatrix x = LinearAlgebra.createRealMatrix(v);
        return LinearAlgebra.createDataset(lud.getSolver().solve(x));
    }

    public static Dataset solveSVD(Dataset a, Dataset v) {
        SingularValueDecomposition svd = new SingularValueDecomposition(LinearAlgebra.createRealMatrix(a));
        if (v.getRank() == 1) {
            RealVector x = LinearAlgebra.createRealVector(v);
            return LinearAlgebra.createDataset(svd.getSolver().solve(x));
        }
        RealMatrix x = LinearAlgebra.createRealMatrix(v);
        return LinearAlgebra.createDataset(svd.getSolver().solve(x));
    }

    public static Dataset calcCholeskyDecomposition(Dataset a) {
        CholeskyDecomposition cd = new CholeskyDecomposition(LinearAlgebra.createRealMatrix(a));
        return LinearAlgebra.createDataset(cd.getL());
    }

    public static Dataset calcConjugateGradient(Dataset a, Dataset v) {
        return LinearAlgebra.calcConjugateGradient(a, v, 100, 1.0);
    }

    public static Dataset calcConjugateGradient(Dataset a, Dataset v, int maxIterations, double delta) {
        ConjugateGradient cg = new ConjugateGradient(maxIterations, delta, false);
        return LinearAlgebra.createDataset(cg.solve((RealLinearOperator)LinearAlgebra.createRealMatrix(a), LinearAlgebra.createRealVector(v)));
    }

    private static RealMatrix createRealMatrix(Dataset a) {
        if (a.getRank() != 2) {
            throw new IllegalArgumentException("Dataset must be rank 2");
        }
        int[] shape = a.getShapeRef();
        IndexIterator it = a.getIterator(true);
        int[] pos = it.getPos();
        RealMatrix m = MatrixUtils.createRealMatrix((int)shape[0], (int)shape[1]);
        while (it.hasNext()) {
            m.setEntry(pos[0], pos[1], a.getElementDoubleAbs(it.index));
        }
        return m;
    }

    private static RealVector createRealVector(Dataset a) {
        if (a.getRank() != 1) {
            throw new IllegalArgumentException("Dataset must be rank 1");
        }
        int size = a.getSize();
        IndexIterator it = a.getIterator(true);
        int[] pos = it.getPos();
        ArrayRealVector m = new ArrayRealVector(size);
        while (it.hasNext()) {
            m.setEntry(pos[0], a.getElementDoubleAbs(it.index));
        }
        return m;
    }

    private static Dataset createDataset(RealVector v) {
        DoubleDataset r = DatasetFactory.zeros(DoubleDataset.class, v.getDimension());
        int size = r.getSize();
        if (v instanceof ArrayRealVector) {
            double[] data = ((ArrayRealVector)v).getDataRef();
            int i = 0;
            while (i < size) {
                r.setAbs(i, data[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                r.setAbs(i, v.getEntry(i));
                ++i;
            }
        }
        return r;
    }

    private static Dataset createDataset(RealMatrix m) {
        DoubleDataset r = DatasetFactory.zeros(DoubleDataset.class, m.getRowDimension(), m.getColumnDimension());
        if (m instanceof Array2DRowRealMatrix) {
            double[][] data = ((Array2DRowRealMatrix)m).getDataRef();
            IndexIterator it = r.getIterator(true);
            int[] pos = it.getPos();
            while (it.hasNext()) {
                r.setAbs(it.index, data[pos[0]][pos[1]]);
            }
        } else {
            IndexIterator it = r.getIterator(true);
            int[] pos = it.getPos();
            while (it.hasNext()) {
                r.setAbs(it.index, m.getEntry(pos[0], pos[1]));
            }
        }
        return r;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$january$dataset$LinearAlgebra$NormOrder() {
        if ($SWITCH_TABLE$org$eclipse$january$dataset$LinearAlgebra$NormOrder != null) {
            return $SWITCH_TABLE$org$eclipse$january$dataset$LinearAlgebra$NormOrder;
        }
        int[] nArray = new int[NormOrder.values().length];
        try {
            nArray[NormOrder.DEFAULT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NormOrder.FROBENIUS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NormOrder.NEG_INFINITY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NormOrder.POS_INFINITY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NormOrder.ZERO.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$january$dataset$LinearAlgebra$NormOrder = nArray;
        return nArray;
    }

    public static enum NormOrder {
        DEFAULT,
        FROBENIUS,
        ZERO,
        POS_INFINITY,
        NEG_INFINITY;

    }
}

