/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.smt;

import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import fr.kairos.timesquare.ccsl.smt.ISMTBuilder;
import java.util.Arrays;

public final class SMTSpecification<T, B extends T, F>
implements ISimpleSpecification {
    private ISMTBuilder<T, B, F> b;

    public SMTSpecification(ISMTBuilder<T, B, F> builder) {
        this.b = builder;
    }

    @Override
    public void addClock(String name) {
        boolean res = this.b.addClock(name);
        if (!res) {
            this.b.assert_Ex(this.b.clockN(name), "avoid empty clock " + name);
        }
    }

    @Override
    public final void subclock(String left, String right) {
        this.b.assert_FA(this.b.implies(this.b.clockN(left), this.b.clockN(right)), String.valueOf(left) + " isSubclockOf " + right);
    }

    @Override
    public final void exclusion(String left, String right) {
        this.b.assert_FA(this.b.or(this.b.not(this.b.clockN(left)), this.b.not(this.b.clockN(right))), String.valueOf(left) + " excludes " + right);
    }

    private void prec(String left, String right, int init) {
        F counter = this.b.addDiffCounter(left, right);
        this.b.assert_FA(this.b.implies(this.b.eq(this.b.applyToN(counter), this.b.constant(init)), this.b.not(this.b.clockN(right))), String.valueOf(left) + " < " + right);
    }

    @Override
    public final void precedence(String left, String right) {
        this.prec(left, right, 0);
    }

    @Override
    public final void precedence(String left, String right, int min, int max) {
        this.prec(left, right, min);
        if (max != -1) {
            this.prec(right, left, max);
        }
    }

    private void caus(String left, String right, int init) {
        F counter = this.b.addDiffCounter(left, right);
        this.b.assert_FA(this.b.ge(this.b.applyToN(counter), this.b.constant(-init)), String.valueOf(left) + " <= " + right);
    }

    @Override
    public final void causality(String left, String right) {
        this.caus(left, right, 0);
    }

    @Override
    public final void causality(String left, String right, int min, int max) {
        this.caus(left, right, min);
        if (max != -1) {
            this.caus(right, left, max);
        }
    }

    @Override
    public final void inf(String defClock, String ... clocks) {
        String right = clocks[1];
        if (clocks.length > 2) {
            right = String.valueOf(defClock) + "_i";
            String[] newClocks = Arrays.copyOfRange(clocks, 1, clocks.length);
            this.inf(right, newClocks);
        }
        this.inf(defClock, clocks[0], right);
    }

    private void inf(String defClock, String left, String right) {
        F counter = this.b.addDiffCounter(left, right);
        this.b.assert_FA(this.b.eq(this.b.clockN(defClock), this.b.ite(this.b.ge(this.b.applyToN(counter), this.b.constant(0)), this.b.clockN(right), this.b.clockN(left))), "inf(" + left + ", " + right + ")");
    }

    private void sup(String defClock, String left, String right) {
        F counter = this.b.addDiffCounter(left, right);
        this.b.assert_FA(this.b.eq(this.b.clockN(defClock), this.b.ite(this.b.ge(this.b.applyToN(counter), this.b.constant(0)), this.b.clockN(left), this.b.clockN(right))), "sup(" + left + ", " + right + ")");
    }

    @Override
    public final void sup(String defClock, String ... clocks) {
        String right = clocks[1];
        if (clocks.length > 2) {
            right = String.valueOf(defClock) + "_i";
            String[] newClocks = Arrays.copyOfRange(clocks, 1, clocks.length);
            this.sup(right, newClocks);
        }
        this.sup(defClock, clocks[0], right);
    }

    @Override
    public final void union(String defClock, String ... clocks) {
        this.b.defineClock(defClock, this.b.or(this.b.applyToNall(clocks)), String.valueOf(defClock) + " = " + String.join((CharSequence)" + ", clocks));
    }

    @Override
    public final void intersection(String defClock, String ... clocks) {
        this.b.defineClock(defClock, this.b.and(this.b.applyToNall(clocks)), String.valueOf(defClock) + " = " + String.join((CharSequence)" * ", clocks));
    }

    @Override
    public final void minus(String defClock, String ... clocks) {
        Object[] app = this.b.applyToNall(clocks);
        int i = 1;
        while (i < app.length) {
            app[i] = this.b.not(app[i]);
            ++i;
        }
        this.b.defineClock(defClock, this.b.and(app), String.valueOf(defClock) + " = " + String.join((CharSequence)" - ", clocks));
    }

    @Override
    public final void periodic(String defClock, String ref, int period, int from, int upto) {
        F counter = this.b.addCounterFor(ref);
        this.b.defineClock(defClock, this.b.and(this.b.clockN(ref), this.b.eq(this.b.constant(period - 1), this.b.mod(this.b.applyToN(counter), this.b.constant(period)))), "repeat " + defClock + " every " + period + " " + ref + " from " + from + " upto " + upto);
    }

    @Override
    public void delayFor(String defClock, String ref, int from, int upto, String base) {
        String s = String.valueOf(defClock) + " = " + ref;
        s = upto == -1 ? String.valueOf(s) + " $ " + from : String.valueOf(s) + "[" + from + ", " + upto + "]";
        if (base == null) {
            F counter = this.b.addCounterFor(ref);
            if (upto == -1) {
                this.b.defineClock(defClock, this.b.and(this.b.clockN(ref), this.b.gt(this.b.applyToN(counter), this.b.constant(from - 1))), s);
            } else {
                this.b.defineClock(defClock, this.b.and(this.b.clockN(ref), this.b.gt(this.b.applyToN(counter), this.b.constant(from - 1)), this.b.gt(this.b.constant(upto), this.b.applyToN(counter))), s);
            }
        } else {
            s = String.valueOf(s) + " on " + base;
            System.err.println("does not support " + s);
        }
    }
}

