/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.smt;

import fr.kairos.common.Pair;
import fr.kairos.timesquare.ccsl.smt.ISMTBuilder;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SMTLibBuilder
implements ISMTBuilder<String, String, String> {
    private ArrayList<String[]> constraints = new ArrayList();
    private ArrayList<String> clocks = new ArrayList();
    private ArrayList<String> clocksDecl = new ArrayList();
    private Set<String> counters = new HashSet<String>();
    private Set<Pair<String, String>> diffCounters = new HashSet<Pair<String, String>>();

    @Override
    public final void assert_Ex(String e, String c) {
        this.addConstraint(this.assertE(this.existsNinInt(e)), c);
    }

    @Override
    public final void assert_FA(String e, String c) {
        this.addConstraint(this.assertE(this.forAllNinInt(e)), c);
    }

    @Override
    public final String clockN(String clock) {
        return this.applyToN(this.tick(clock));
    }

    static String op(String op, String ... e) {
        return "(" + op + " " + String.join((CharSequence)" ", e) + ")";
    }

    private void addConstraint(String cons, String com) {
        this.constraints.add(new String[]{cons, com});
    }

    @Override
    public String tick(String clock) {
        return "t_" + clock;
    }

    @Override
    public String counter(String clock) {
        return "c_" + clock;
    }

    @Override
    public void defineClock(String clock, String body, String comment) {
        this.clocks.add(clock);
        this.addConstraint(SMTLibBuilder.op("define-fun", this.tick(clock), "((n Int))", "Bool", body), comment);
    }

    @Override
    public String assertE(String existsNinInt) {
        return "(assert " + existsNinInt + ")";
    }

    @Override
    public String existsNinInt(String e) {
        return "(exists ( (n Int) ) " + e + ")";
    }

    @Override
    public String forAllNinInt(String e) {
        return "(forall ( (n Int) ) " + e + ")";
    }

    public String[] applyToNall(String ... clocks) {
        String[] tab = new String[clocks.length];
        int i = 0;
        while (i < clocks.length) {
            tab[i] = this.clockN(clocks[i]);
            ++i;
        }
        return tab;
    }

    @Override
    public String apply(String f, String e) {
        return "(" + f + " " + e + ")";
    }

    @Override
    public String applyToN(String f) {
        return this.apply(f, "n");
    }

    @Override
    public String not(String e) {
        return "(not " + e + ")";
    }

    @Override
    public String ite(String i, String t, String e) {
        return "(ite " + i + " " + t + " " + e + ")";
    }

    @Override
    public String implies(String cause, String cons) {
        return SMTLibBuilder.op("=>", cause, cons);
    }

    @Override
    public String eq(String left, String right) {
        return SMTLibBuilder.op("=", left, right);
    }

    @Override
    public String gt(String left, String right) {
        return SMTLibBuilder.op(">", left, right);
    }

    @Override
    public String ge(String left, String right) {
        return SMTLibBuilder.op(">=", left, right);
    }

    @Override
    public String or(Object ... e) {
        return SMTLibBuilder.op("or", this.obj2str(e));
    }

    private String[] obj2str(Object[] t) {
        String[] res = new String[t.length];
        int i = 0;
        while (i < t.length) {
            res[i] = t[i].toString();
            ++i;
        }
        return res;
    }

    @Override
    public String and(Object ... e) {
        return SMTLibBuilder.op("and", this.obj2str(e));
    }

    @Override
    public String mod(String left, String right) {
        return SMTLibBuilder.op("mod", left, right);
    }

    @Override
    public String constant(int v) {
        return String.valueOf(v);
    }

    @Override
    public void check(Object ... params) {
        int i;
        PrintWriter pw = new PrintWriter((Writer)params[0]);
        pw.println("(set-logic UFLIA)");
        int longueur = 6;
        if (params.length > 1) {
            longueur = (Integer)params[1];
        }
        for (String clock : this.clocksDecl) {
            pw.println();
            pw.println("; clock " + clock);
            pw.println("(declare-fun t_" + clock + " (Int) Bool)");
        }
        Object[] clockTicks = this.applyToNall(this.clocks.toArray(new String[this.clocks.size()]));
        this.assert_FA(this.or(clockTicks), "avoid empty steps");
        for (String string : this.counters) {
            this.buildCounter(pw, string);
        }
        for (Pair pair : this.diffCounters) {
            this.buildDiffCounter(pw, pair);
        }
        for (String[] stringArray : this.constraints) {
            pw.println();
            pw.println("; " + stringArray[1]);
            pw.println(stringArray[0]);
        }
        pw.println();
        pw.println("(check-sat)");
        pw.println("(get-model)");
        for (String string : this.clocks) {
            pw.append("(get-value (");
            i = 0;
            while (i < longueur) {
                pw.append(SMTLibBuilder.op(this.tick(string), String.valueOf(i)));
                ++i;
            }
            pw.println("))");
        }
        for (String string : this.counters) {
            pw.append("(get-value (");
            i = 0;
            while (i < longueur) {
                pw.append(SMTLibBuilder.op(this.counter(string), String.valueOf(i)));
                ++i;
            }
            pw.println("))");
        }
        for (Pair pair : this.diffCounters) {
            pw.append("(get-value (");
            i = 0;
            while (i < longueur) {
                pw.append(SMTLibBuilder.op(this.counter(pair.getName()), String.valueOf(i)));
                ++i;
            }
            pw.println("))");
        }
    }

    private void buildDiffCounter(PrintWriter pw, Pair<String, String> p) {
        String n_1 = "(- n 1)";
        pw.println("\n(define-fun-rec c_" + p.getName() + " ((n Int)) Int");
        pw.println("    (ite (= 0 n)");
        pw.println("         0");
        pw.println("         " + SMTLibBuilder.op("+", SMTLibBuilder.op("c_" + p.getName(), n_1), this.ite(SMTLibBuilder.op(this.tick(p.getLeft()), n_1), "1", "0"), this.ite(SMTLibBuilder.op(this.tick(p.getRight()), n_1), "-1", "0")));
        pw.println("    ))");
        pw.println("(define-fun-rec c_" + p.getRight() + "_" + p.getLeft() + " ((n Int)) Int");
        pw.println("    (- (c_" + p.getName() + " n)))");
    }

    private void buildCounter(PrintWriter pw, String clock) {
        String n_1 = "(- n 1)";
        pw.println("\n(define-fun-rec c_" + clock + " ((n Int)) Int");
        pw.println("    (ite (= 0 n)");
        pw.println("         0");
        pw.println("         " + SMTLibBuilder.op("+", SMTLibBuilder.op("c_" + clock, n_1), this.ite(SMTLibBuilder.op(this.tick(clock), n_1), "1", "0")));
        pw.println("    ))");
    }

    @Override
    public boolean addClock(String name) {
        if (this.clocks.contains(name)) {
            return true;
        }
        this.clocks.add(name);
        this.clocksDecl.add(name);
        return false;
    }

    @Override
    public String addCounterFor(String clock) {
        this.counters.add(clock);
        return "c_" + clock;
    }

    @Override
    public String addDiffCounter(String left, String right) {
        Pair<String, String> p = new Pair<String, String>(left, right);
        this.diffCounters.add(p);
        return "c_" + p.getName();
    }
}

