/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.resource;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Tuples;

public class RoomResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    private static final Logger LOG = Logger.getLogger(RoomResourceDescriptionStrategy.class);
    public static final String USER_DATA_ROOM_ANNOTATIONS = "ROOM_ANNOTATIONS";
    @Inject
    RoomHelpers roomHelpers;

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (!RoomPackage.eINSTANCE.getStructureClass().isInstance((Object)eObject)) {
            return super.createEObjectDescriptions(eObject, acceptor);
        }
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        if (((StructureClass)eObject).getAnnotations().isEmpty()) {
            return super.createEObjectDescriptions(eObject, acceptor);
        }
        StructureClass sc = (StructureClass)eObject;
        Stream<String> annotationStrings = sc.getAnnotations().stream().map(annotation -> {
            AnnotationType type = annotation.getType();
            String annotationName = type == null || type.eIsProxy() ? "(unknown)" : this.getQualifiedNameProvider().getFullyQualifiedName((EObject)type).toString();
            int hash = this.getAttributesHash((Collection<KeyValue>)annotation.getAttributes());
            return annotationName + ":" + hash;
        });
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                Map<String, String> userData = Collections.singletonMap(USER_DATA_ROOM_ANNOTATIONS, annotationStrings.collect(Collectors.joining(",")));
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, userData));
            }
        }
        catch (Exception exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
        }
        return true;
    }

    private int getAttributesHash(Collection<KeyValue> attributes) {
        Collection raw = attributes.stream().filter(it -> it.getKey() != null && it.getValue() != null && !it.getValue().eIsProxy()).map(it -> Tuples.pair((Object)it.getKey(), (Object)this.roomHelpers.literalToString(it.getValue()))).collect(Collectors.toList());
        return Arrays.hashCode(raw.toArray());
    }
}

