/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;

public class CifPartialSpecAnnotationUtils {
    private CifPartialSpecAnnotationUtils() {
    }

    public static boolean isPartial(Specification spec) {
        return CifAnnotationUtils.hasAnnotation((AnnotatedObject)spec, "partial");
    }

    public static void makePartial(Specification spec) {
        if (!CifPartialSpecAnnotationUtils.isPartial(spec)) {
            spec.getAnnotations().add((Object)CifConstructors.newAnnotation(null, (String)"partial", null));
        }
    }

    public static void makeNonPartial(Specification spec) {
        CifAnnotationUtils.removeAnnotations((AnnotatedObject)spec, "partial");
    }

    public static void modifyPartial(Specification spec, boolean partial) {
        if (partial) {
            CifPartialSpecAnnotationUtils.makePartial(spec);
        } else {
            CifPartialSpecAnnotationUtils.makeNonPartial(spec);
        }
    }
}

