/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.finiteresponse;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.controllercheck.checks.finiteresponse.EventLoop;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.DirectedGraphCycleFinder;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Termination;

public class EventLoopSearch {
    private EventLoopSearch() {
    }

    public static Set<EventLoop> searchEventLoops(Automaton aut, Set<Event> loopEvents, Termination termination) {
        EventLoopFinder finder = new EventLoopFinder(loopEvents, termination);
        return finder.findSimpleCycles(aut);
    }

    private static class EventLoopEdge
    extends DirectedGraphCycleFinder.GraphEdge<Location> {
        public final List<Event> events;

        public EventLoopEdge(Location startVertex, Location destinationVertex, List<Event> events) {
            super((Object)startVertex, (Object)destinationVertex);
            this.events = events;
        }
    }

    public static class EventLoopFinder
    extends DirectedGraphCycleFinder<Automaton, Location, EventLoopEdge, EventLoop> {
        private final Set<Event> loopEvents;

        public EventLoopFinder(Set<Event> loopEvents, Termination termination) {
            super(termination);
            this.loopEvents = loopEvents;
        }

        protected List<Location> getVertices(Automaton graph) {
            return graph.getLocations();
        }

        protected void addCycle(Automaton aut, List<EventLoopEdge> edges, Set<EventLoop> foundCycles) {
            List eventCollections = Lists.listc((int)edges.size());
            for (EventLoopEdge edge : edges) {
                eventCollections.add(edge.events);
            }
            ListProductIterator iter = new ListProductIterator(eventCollections);
            while (iter.hasNext()) {
                List selectedEvents = iter.next();
                foundCycles.add(new EventLoop(selectedEvents));
            }
        }

        protected List<EventLoopEdge> getOutgoingEdges(Automaton aut, Location vertex) {
            List edges = Lists.list();
            for (Edge edge : vertex.getEdges()) {
                if (Sets.isEmptyIntersection(this.loopEvents, (Set)CifEventUtils.getEvents((Edge)edge))) continue;
                Location edgeTargetLoc = CifEdgeUtils.getTarget((Edge)edge);
                List edgeEvents = Lists.list();
                for (Event event : CifEventUtils.getEvents((Edge)edge)) {
                    if (this.loopEvents.contains(event)) {
                        edgeEvents.add(event);
                    }
                    edges.add(new EventLoopEdge(vertex, edgeTargetLoc, edgeEvents));
                }
            }
            return edges;
        }
    }
}

