/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime;

import java.util.List;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.tooldef.runtime.ToolDefRuntimeUtils;
import org.eclipse.escet.tooldef.runtime.ToolDefTuple;

public class ToolDefTuplePair<T1, T2>
extends ToolDefTuple {
    public final T1 left;
    public final T2 right;

    public ToolDefTuplePair(T1 left, T2 right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    protected void collectValues(List<Object> values) {
        values.add(this.left);
        values.add(this.right);
    }

    @Override
    public Object getValue(int idx) {
        if (idx == 0) {
            return this.left;
        }
        if (idx == 1) {
            return this.right;
        }
        throw new IllegalArgumentException("Invalid idx: " + idx);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolDefTuplePair)) {
            return false;
        }
        ToolDefTuplePair other = (ToolDefTuplePair)obj;
        return ToolDefRuntimeUtils.equalValues(this.left, other.left) && ToolDefRuntimeUtils.equalValues(this.right, other.right);
    }

    @Override
    public int hashCode() {
        return ToolDefTuplePair.class.hashCode() ^ ToolDefRuntimeUtils.hashValue(this.left) ^ ToolDefRuntimeUtils.hashValue(this.right);
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"(%s, %s)", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(this.left), ToolDefRuntimeUtils.valueToStr(this.right)});
    }
}

