/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.escet.cif.codegen.CodeGen;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.SingleVariableAssignment;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CodeContext {
    protected final CodeGen codeGen;

    public CodeContext(CodeGen codeGen) {
        this.codeGen = codeGen;
    }

    public MemoryCodeBox makeCodeBox() {
        return this.makeCodeBox(0);
    }

    public MemoryCodeBox makeCodeBox(int numIndents) {
        return this.codeGen.makeCodeBox(numIndents);
    }

    public void addUpdatesBeginScope(CodeBox code) {
        this.codeGen.addUpdatesBeginScope(code);
    }

    public void addUpdatesEndScope(CodeBox code) {
        this.codeGen.addUpdatesEndScope(code);
    }

    public ExprCode predsToTarget(List<Expression> preds) {
        return this.codeGen.exprCodeGen.predsToTarget(preds, this);
    }

    public ExprCode exprToTarget(Expression expr, Destination dest) {
        return this.codeGen.exprCodeGen.exprToTarget(expr, dest, this);
    }

    public VariableInformation makeTempVariable(VariableInformation varInfo) {
        return this.codeGen.makeTempVariable(varInfo);
    }

    public VariableInformation makeTempVariable(CifType type, String name) {
        TypeInfo ti = this.typeToTarget(type);
        return this.makeTempVariable(ti, name);
    }

    public VariableInformation makeTempVariable(TypeInfo ti, String name) {
        if (name == null) {
            name = "tmp";
        }
        return this.codeGen.makeTempVariable(ti, name);
    }

    public Destination makeDestination(Declaration decl) {
        VariableInformation varInfo = this.getWriteVarInfo(decl);
        return this.makeDestination(varInfo);
    }

    public Destination makeDestination(VariableInformation varInfo) {
        return this.codeGen.makeDestination(varInfo);
    }

    public int reserveTempVariables() {
        return this.codeGen.reserveTempVariables();
    }

    public DataValue makeDataValue(String value) {
        return this.codeGen.makeDataValue(value);
    }

    public void unreserveTempVariables(int reservedValue) {
        this.codeGen.unreserveTempVariables(reservedValue);
    }

    public int countCreatedTempVariables() {
        return this.codeGen.countCreatedTempVariables();
    }

    public void performSingleAssign(CodeBox code, SingleVariableAssignment asgn, Expression value, CodeContext readCtxt) {
        this.codeGen.performSingleAssign(code, asgn, value, readCtxt, this);
    }

    public void performAssign(CodeBox code, SingleVariableAssignment asgn, String rhsText, CodeContext readCtxt) {
        this.codeGen.performAssign(code, asgn, rhsText, readCtxt, this);
    }

    public Set<VariableWrapper> getAffectedAlgebraicDerivativeExpressions(VariableWrapper v) {
        return this.codeGen.getAffectedAlgebraicDerivativeExpressions(v);
    }

    public VariableInformation getReadVarInfo(VariableWrapper var) {
        return this.codeGen.getVarInfo(var.decl, this);
    }

    public ExprCode getReadVariableCode(VariableWrapper var) {
        Declaration declaration = var.decl;
        Objects.requireNonNull(declaration);
        Declaration declaration2 = declaration;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AlgVariable.class, ContVariable.class, DiscVariable.class, InputVariable.class}, (Object)declaration2, 0)) {
            case 0 -> {
                AlgVariable algVar = (AlgVariable)declaration2;
                yield this.codeGen.exprCodeGen.convertAlgVariableExpression(algVar, null, this);
            }
            case 1 -> {
                ContVariable contVar = (ContVariable)declaration2;
                yield this.codeGen.exprCodeGen.convertContVariableExpression(contVar, var.isDerivative, null, this);
            }
            case 2 -> {
                DiscVariable discVar = (DiscVariable)declaration2;
                yield this.codeGen.exprCodeGen.convertDiscVariableExpression(discVar, null, this);
            }
            case 3 -> {
                InputVariable inpVar = (InputVariable)declaration2;
                yield this.codeGen.exprCodeGen.convertInputVariableExpression(inpVar, null, this);
            }
            default -> throw new RuntimeException("Unexpected variable read request encountered: " + Strings.str((Object)var.decl));
        };
    }

    public VariableInformation getWriteVarInfo(Declaration decl) {
        VariableInformation varInfo = this.codeGen.getVarInfo(decl, this);
        return varInfo;
    }

    public String getFunctionName(InternalFunction func) {
        return this.codeGen.getTargetVariableName((PositionObject)func);
    }

    public String getOrigFunctionName(InternalFunction func) {
        String origName = this.codeGen.origDeclNames.get(func);
        if (origName == null) {
            origName = func.getName();
        }
        return origName;
    }

    public TypeInfo typeToTarget(CifType type) {
        return this.codeGen.typeCodeGen.typeToTarget(type, this);
    }

    public String getPrefix() {
        return this.codeGen.replacements.get("prefix");
    }

    public void appendReplacement(String replName, String additionalText) {
        if (additionalText.isEmpty()) {
            return;
        }
        String existingText = this.codeGen.replacements.get(replName);
        if (existingText == null || existingText.isEmpty()) {
            this.codeGen.replacements.put(replName, additionalText);
        } else {
            this.codeGen.replacements.put(replName, existingText + "\n" + additionalText);
        }
    }

    public IfElseGenerator getIfElseUpdateGenerator() {
        return this.codeGen.getIfElseUpdateGenerator();
    }
}

