/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.dsl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOExceptionWithCause;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.ESWorkspace;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.test.common.TestSessionProvider2;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.test.model.TestElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Delete {
    private static final int DELETION_RETRIES = 3;
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();

    private Delete() {
    }

    public static void fromNonContained1ToN(final TestElement testElement, final List<TestElement> references) {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                testElement.getNonContained_1ToN().removeAll((Collection)references);
                return null;
            }
        });
    }

    public static void fromNonContained1ToN(final TestElement testElement, final TestElement reference) {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                testElement.getNonContained_1ToN().remove((Object)reference);
                return null;
            }
        });
    }

    public static void fromNonContainedNToM(final TestElement testElement, final TestElement reference) {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                testElement.getNonContained_NToM().remove((Object)reference);
                return null;
            }
        });
    }

    public static void fromNonContainedNToM(final TestElement testElement, final List<TestElement> reference) {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                testElement.getNonContained_NToM().removeAll((Collection)reference);
                return null;
            }
        });
    }

    public static void fromContainedElements(final TestElement testElement, final TestElement containee) {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                testElement.getContainedElements().remove((Object)containee);
                return null;
            }
        });
    }

    public static void fromContainedElements(final TestElement testElement, final List<TestElement> containees) {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                testElement.getContainedElements().removeAll((Collection)containees);
                return null;
            }
        });
    }

    public static void user(ESServer server, ACOrgUnitId userId) throws ESException {
        AdminConnectionManager adminConnectionManager = ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager();
        SessionId sessionId = TestSessionProvider2.getInstance().getDefaultUsersession().getSessionId();
        ESServerImpl s = (ESServerImpl)ESServerImpl.class.cast(server);
        adminConnectionManager.initConnection((ServerInfo)s.toInternalAPI(), sessionId);
        adminConnectionManager.deleteUser(sessionId, userId);
    }

    public static void fromProject(final ESLocalProject localProject, final EObject eObject) {
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                Project project = ((ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI()).getProject();
                project.deleteModelElement(eObject);
            }
        });
    }

    public static void allRemoteProjects(ESServer server, ESUsersession session) throws ESException {
        for (ESRemoteProject project : server.getRemoteProjects()) {
            project.delete(session, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void allLocalProjects() throws ESException, IOException {
        ESWorkspace workspace = ESWorkspaceProvider.INSTANCE.getWorkspace();
        List localProjects = workspace.getLocalProjects();
        for (ESLocalProject localProject : localProjects) {
            Delete.tryDeleteProject(localProject);
        }
    }

    private static void tryDeleteProject(ESLocalProject localProject) throws ESException, IOException {
        int deletionAttempt = 0;
        IOException ioException = null;
        do {
            try {
                localProject.delete((IProgressMonitor)NULL_PROGRESS_MONITOR);
            }
            catch (IOException e) {
                ++deletionAttempt;
                ioException = e;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    throw new IOExceptionWithCause((Throwable)ex);
                }
            }
        } while (deletionAttempt < 3 && ioException != null);
        if (ioException != null) {
            throw ioException;
        }
    }
}

