/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucketCandidate;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.LinkedHashMapWithConflictBucketCandidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OppositeReservationMap
extends LinkedHashMapWithConflictBucketCandidate<ConflictBucketCandidate> {
    private static final long serialVersionUID = 2688817784490600252L;
    private boolean hasOpposites;

    public OppositeReservationMap(boolean hasOpposites) {
        this.hasOpposites = hasOpposites;
    }

    @Override
    public Set<ConflictBucketCandidate> getAllConflictBucketCandidates() {
        LinkedHashSet<ConflictBucketCandidate> candidates = new LinkedHashSet<ConflictBucketCandidate>();
        if (!this.hasOpposites) {
            if (this.getConflictBucketCandidate() != null) {
                candidates.add(this.getConflictBucketCandidate());
            }
            return candidates;
        }
        candidates.addAll(this.values());
        return candidates;
    }

    public boolean hasOpposites() {
        return this.hasOpposites;
    }

    public Set<ConflictBucketCandidate> getConflictBucketCandidates(String oppositeModelElement) {
        LinkedHashSet<ConflictBucketCandidate> candidates = new LinkedHashSet<ConflictBucketCandidate>();
        if (!this.hasOpposites) {
            candidates.add(this.getConflictBucketCandidate());
            return candidates;
        }
        ConflictBucketCandidate matchingBucket = (ConflictBucketCandidate)this.get(oppositeModelElement);
        candidates.add(matchingBucket);
        return candidates;
    }
}

