/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;

public class EMFModelAuthenticationVerifier
extends AbstractAuthenticationControl {
    protected boolean verifyPassword(ACUser resolvedUser, String username, String password) throws AccessControlException {
        if (resolvedUser == null) {
            return false;
        }
        String userPassword = resolvedUser.getPassword();
        if (userPassword == null && (password == null || password.equals(""))) {
            return true;
        }
        return resolvedUser.getPassword().equals(password);
    }

    public AuthenticationInformation logIn(ACUser resolvedUser, String username, String password, ClientVersionInfo clientVersionInfo) throws AccessControlException {
        super.checkClientVersion(clientVersionInfo);
        password = this.preparePassword(password);
        if (this.verifySuperUser(username, password) || this.verifyPassword(resolvedUser, username, password)) {
            return this.createAuthenticationInfo();
        }
        throw new AccessControlException();
    }
}

