/*******************************************************************************
 * Copyright (c) 2008-2011 Chair for Applied Software Engineering,
 * Technische Universitaet Muenchen.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 ******************************************************************************/
package org.eclipse.emf.emfstore.internal.server.model.versioning.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.emfstore.internal.server.model.provider.ServerEditPlugin;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningPackage;

/**
 * This is the item provider adapter for a {@link org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo}
 * object.
 * <!-- begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class HistoryInfoItemProvider extends ItemProviderAdapter implements IEditingDomainItemProvider,
	IStructuredItemContentProvider, ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public HistoryInfoItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getChildren(java.lang.Object)
	 */
	@Override
	public Collection<?> getChildren(Object object) {
		if (object instanceof HistoryInfo) {
			HistoryInfo historyInfo = (HistoryInfo) object;
			ChangePackage changePackage = historyInfo.getChangePackage();
			if (changePackage == null) {
				return new ArrayList<ChangePackage>();
			}
			return Arrays.asList(changePackage);
		}
		return super.getChildren(object);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null)
		{
			super.getPropertyDescriptors(object);

			addLogMessagePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Log Message feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLogMessagePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
			(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_HistoryInfo_logMessage_feature"),
				getString("_UI_PropertyDescriptor_description", "_UI_HistoryInfo_logMessage_feature",
					"_UI_HistoryInfo_type"),
				VersioningPackage.Literals.HISTORY_INFO__LOG_MESSAGE,
				true,
				false,
				true,
				null,
				null,
				null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null)
		{
			super.getChildrenFeatures(object);
			childrenFeatures.add(VersioningPackage.Literals.HISTORY_INFO__PRIMARY_SPEC);
			childrenFeatures.add(VersioningPackage.Literals.HISTORY_INFO__NEXT_SPEC);
			childrenFeatures.add(VersioningPackage.Literals.HISTORY_INFO__PREVIOUS_SPEC);
			childrenFeatures.add(VersioningPackage.Literals.HISTORY_INFO__MERGED_FROM);
			childrenFeatures.add(VersioningPackage.Literals.HISTORY_INFO__MERGED_TO);
			childrenFeatures.add(VersioningPackage.Literals.HISTORY_INFO__TAG_SPECS);
			childrenFeatures.add(VersioningPackage.Literals.HISTORY_INFO__VERSION_PROPERTIES);
			childrenFeatures.add(VersioningPackage.Literals.HISTORY_INFO__CHANGE_PACKAGE);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	// begin of custom code
	/**
	 * @param object
	 *            the object
	 * @return This returns the image.
	 * @generated NOT
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/HistoryInfo.png"));
	}

	// end of custom code

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_HistoryInfo_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(HistoryInfo.class))
		{
		case VersioningPackage.HISTORY_INFO__PRIMARY_SPEC:
		case VersioningPackage.HISTORY_INFO__NEXT_SPEC:
		case VersioningPackage.HISTORY_INFO__PREVIOUS_SPEC:
		case VersioningPackage.HISTORY_INFO__MERGED_FROM:
		case VersioningPackage.HISTORY_INFO__MERGED_TO:
		case VersioningPackage.HISTORY_INFO__TAG_SPECS:
		case VersioningPackage.HISTORY_INFO__VERSION_PROPERTIES:
		case VersioningPackage.HISTORY_INFO__CHANGE_PACKAGE:
			fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
			(VersioningPackage.Literals.HISTORY_INFO__PRIMARY_SPEC,
				VersioningFactory.eINSTANCE.createPrimaryVersionSpec()));

		newChildDescriptors.add
			(createChildParameter
			(VersioningPackage.Literals.HISTORY_INFO__NEXT_SPEC,
				VersioningFactory.eINSTANCE.createPrimaryVersionSpec()));

		newChildDescriptors.add
			(createChildParameter
			(VersioningPackage.Literals.HISTORY_INFO__PREVIOUS_SPEC,
				VersioningFactory.eINSTANCE.createPrimaryVersionSpec()));

		newChildDescriptors.add
			(createChildParameter
			(VersioningPackage.Literals.HISTORY_INFO__MERGED_FROM,
				VersioningFactory.eINSTANCE.createPrimaryVersionSpec()));

		newChildDescriptors.add
			(createChildParameter
			(VersioningPackage.Literals.HISTORY_INFO__MERGED_TO,
				VersioningFactory.eINSTANCE.createPrimaryVersionSpec()));

		newChildDescriptors.add
			(createChildParameter
			(VersioningPackage.Literals.HISTORY_INFO__TAG_SPECS,
				VersioningFactory.eINSTANCE.createTagVersionSpec()));

		newChildDescriptors.add
			(createChildParameter
			(VersioningPackage.Literals.HISTORY_INFO__VERSION_PROPERTIES,
				VersioningFactory.eINSTANCE.createVersionProperty()));

		newChildDescriptors.add
			(createChildParameter
			(VersioningPackage.Literals.HISTORY_INFO__CHANGE_PACKAGE,
				VersioningFactory.eINSTANCE.createChangePackage()));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
		Object childFeature = feature;
		Object childObject = child;

		boolean qualify =
			childFeature == VersioningPackage.Literals.HISTORY_INFO__PRIMARY_SPEC ||
				childFeature == VersioningPackage.Literals.HISTORY_INFO__NEXT_SPEC ||
				childFeature == VersioningPackage.Literals.HISTORY_INFO__PREVIOUS_SPEC ||
				childFeature == VersioningPackage.Literals.HISTORY_INFO__MERGED_FROM ||
				childFeature == VersioningPackage.Literals.HISTORY_INFO__MERGED_TO;

		if (qualify)
		{
			return getString("_UI_CreateChild_text2",
				new Object[] { getTypeText(childObject), getFeatureText(childFeature), getTypeText(owner) });
		}
		return super.getCreateChildText(owner, feature, child, selection);
	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return ServerEditPlugin.INSTANCE;
	}

}