/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.TabContent;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.wizard.AcUserImportAction;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupTabContent
extends TabContent
implements IPropertyChangeListener {
    public GroupTabContent(String string, AdminBroker adminBroker, PropertiesForm frm) {
        super(string, adminBroker, frm);
        this.setTab(this);
    }

    @Override
    protected List<Action> initActions() {
        Action createNewGroup = new Action("Create new group"){

            public void run() {
                try {
                    GroupTabContent.this.getAdminBroker().createGroup("New Group");
                }
                catch (ESException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                GroupTabContent.this.getTableViewer().refresh();
                GroupTabContent.this.getForm().getTableViewer().refresh();
            }
        };
        createNewGroup.setImageDescriptor(Activator.getImageDescriptor("icons/Group.gif"));
        createNewGroup.setToolTipText("Create new group");
        Action deleteGroup = new Action("Delete group"){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)GroupTabContent.this.getTableViewer().getSelection();
                for (ACGroup ou : selection) {
                    if (ou == null) {
                        return;
                    }
                    try {
                        GroupTabContent.this.getAdminBroker().deleteGroup(ou.getId());
                    }
                    catch (ESException e) {
                        EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                    }
                    if (!(GroupTabContent.this.getForm().getCurrentInput() instanceof ACOrgUnit) || !GroupTabContent.this.getForm().getCurrentInput().equals(ou)) continue;
                    GroupTabContent.this.getForm().setInput(null);
                }
                GroupTabContent.this.getTableViewer().refresh();
            }
        };
        deleteGroup.setImageDescriptor(Activator.getImageDescriptor("icons/delete.gif"));
        deleteGroup.setToolTipText("Delete group");
        AcUserImportAction importOrgUnit = new AcUserImportAction(this.getAdminBroker());
        importOrgUnit.addPropertyChangeListener(this);
        return Arrays.asList(new Action[]{createNewGroup, deleteGroup, importOrgUnit});
    }

    @Override
    public ITableLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return Activator.getImageDescriptor("icons/Group.gif").createImage();
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ACGroup)element).getName();
            }
        };
    }

    @Override
    public IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList groups = new ArrayList();
                try {
                    groups.addAll(GroupTabContent.this.getAdminBroker().getGroups());
                }
                catch (ESException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                return groups.toArray(new ACGroup[groups.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getTableViewer().refresh();
    }
}

