/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.startup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.common.ESSystemOutProgressMonitor;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.ModelVersion;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.MalformedModelVersionException;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrationException;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigratorUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationManager {
    public void migrateModel() throws FatalESException {
        ModelVersion modelVersion;
        int modelVersionNumber;
        try {
            modelVersionNumber = ModelUtil.getModelVersionNumber();
        }
        catch (MalformedModelVersionException e1) {
            throw new FatalESException(e1);
        }
        File versionFile = new File(ServerConfiguration.getModelReleaseNumberFileName());
        if (!versionFile.exists()) {
            this.stampCurrentVersionNumber(modelVersionNumber);
        }
        URI versionFileUri = URI.createFileURI((String)ServerConfiguration.getModelReleaseNumberFileName());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(versionFileUri, true);
            EList directContents = resource.getContents();
            modelVersion = (ModelVersion)directContents.get(0);
        }
        catch (RuntimeException runtimeException) {
            modelVersion = ModelFactory.eINSTANCE.createModelVersion();
            modelVersion.setReleaseNumber(4);
        }
        if (modelVersion.getReleaseNumber() == modelVersionNumber) {
            return;
        }
        if (!EMFStoreMigratorUtil.isMigratorAvailable()) {
            throw new FatalESException("Model must be migrated to new version, but no migrators are available.");
        }
        boolean doProcceed = this.askForConfirmationForMigration();
        if (!doProcceed) {
            String message = "Server shutting down, model update is mandatory.";
            System.out.println(message);
            throw new FatalESException(message);
        }
        File serverSpaceDirectory = new File(ServerConfiguration.getServerHome());
        File[] fileArray = serverSpaceDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File projectDirectory = fileArray[n2];
            if (projectDirectory.getName().startsWith("project-") && projectDirectory.isDirectory()) {
                System.out.println("Migrating project at " + projectDirectory + "...");
                this.convertInitialProjectState(modelVersion, projectDirectory);
                File[] listFiles = projectDirectory.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isFile() && (pathname.getName().endsWith(".ucp") || pathname.getName().endsWith(".ups"));
                    }
                });
                this.convertAllVersions(modelVersion, projectDirectory, listFiles);
            }
            ++n2;
        }
        this.stampCurrentVersionNumber(modelVersionNumber);
    }

    private void convertInitialProjectState(ModelVersion modelVersion, File projectDirectory) throws FatalESException {
        URI version0StateURI = URI.createFileURI((String)(String.valueOf(projectDirectory.getAbsolutePath()) + File.separatorChar + "projectstate-" + "0" + ".ups"));
        try {
            System.out.println("Migrating version 0...");
            this.migrate(version0StateURI, new ArrayList<URI>(), modelVersion.getReleaseNumber());
        }
        catch (EMFStoreMigrationException e) {
            throw new FatalESException("Migration of project at " + projectDirectory + " failed!", e);
        }
    }

    private void convertAllVersions(ModelVersion modelVersion, File projectDirectory, File[] listFiles) throws FatalESException {
        ArrayList<URI> changePackageURIs = new ArrayList<URI>();
        Arrays.sort(listFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return this.compare(o1.getName(), o2.getName());
            }

            @Override
            private int compare(String name1, String name2) {
                return this.getNumber(name1).compareTo(this.getNumber(name2));
            }

            private Integer getNumber(String filename) {
                String number;
                String name = filename.substring(0, filename.lastIndexOf("."));
                int i = name.length() - 1;
                while (i >= 0 && '0' <= name.charAt(i) && name.charAt(i) <= '9') {
                    --i;
                }
                return (number = name.substring(++i)).equals("") ? 0 : Integer.parseInt(number);
            }
        });
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File changePackageFile = fileArray[n2];
            String changePackageName = changePackageFile.getName();
            if (changePackageName.startsWith("changepackage-")) {
                int versionSpec = this.parseVersionSpecFromFileName(changePackageName);
                URI changePackageURI = URI.createFileURI((String)changePackageFile.getAbsolutePath());
                changePackageURIs.add(changePackageURI);
                String projectStateFilename = String.valueOf(projectDirectory.getAbsolutePath()) + File.separatorChar + "projectstate-" + versionSpec + ".ups";
                File projectStateFile = new File(projectStateFilename);
                if (projectStateFile.exists()) {
                    URI projectURI = URI.createFileURI((String)projectStateFilename);
                    try {
                        System.out.println("Migrating version " + versionSpec + " with its " + (changePackageURIs.size() - 1) + " previous versions...");
                        this.migrate(projectURI, changePackageURIs, modelVersion.getReleaseNumber());
                    }
                    catch (EMFStoreMigrationException e) {
                        throw new FatalESException("Migration of project at " + projectDirectory + " failed!", e);
                    }
                    changePackageURIs.clear();
                }
            }
            ++n2;
        }
    }

    private int parseVersionSpecFromFileName(String versionName) {
        int startOfFileExtension = versionName.lastIndexOf(".");
        int prefixLength = "changepackage-".length();
        String versionSpecString = versionName.substring(prefixLength, startOfFileExtension);
        int versionSpec = Integer.parseInt(versionSpecString);
        return versionSpec;
    }

    private void migrate(URI projectURI, List<URI> changesURIs, int sourceModelReleaseNumber) throws EMFStoreMigrationException {
        ArrayList<URI> modelURIs = new ArrayList<URI>();
        modelURIs.add(projectURI);
        for (URI changeURI : changesURIs) {
            modelURIs.add(changeURI);
        }
        EMFStoreMigratorUtil.getEMFStoreMigrator().migrate(modelURIs, sourceModelReleaseNumber, (IProgressMonitor)new ESSystemOutProgressMonitor());
    }

    private void stampCurrentVersionNumber(int modelReleaseNumber) {
        URI versionFileUri = URI.createFileURI((String)ServerConfiguration.getModelReleaseNumberFileName());
        Resource versionResource = new ResourceSetImpl().createResource(versionFileUri);
        ModelVersion modelVersion = ModelFactory.eINSTANCE.createModelVersion();
        modelVersion.setReleaseNumber(modelReleaseNumber);
        versionResource.getContents().add((Object)modelVersion);
        try {
            ModelUtil.saveResource((Resource)versionResource, (IResourceLogger)ModelUtil.getResourceLogger());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean askForConfirmationForMigration() throws FatalESException {
        System.out.println("Your model is not up to date. Do you want to update now and did you backup your emfstore folder? (y/n)");
        byte[] buffer = new byte[1];
        String input = "";
        int read = 0;
        try {
            read = System.in.read(buffer, 0, 1);
        }
        catch (IOException e) {
            throw new FatalESException("Cannot read from input", e);
        }
        input = new String(buffer, 0, read);
        return input.equalsIgnoreCase("y");
    }
}

