/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.accesscontrol.AccessControlHelper;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.EMFStorePropertiesOutdatedException;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceImpl;
import org.eclipse.emf.emfstore.internal.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.internal.common.model.EMFStorePropertyType;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.PropertyStringValue;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyManager {
    private final ProjectSpaceImpl projectSpace;
    private Map<String, EMFStoreProperty> sharedProperties;
    private Map<String, EMFStoreProperty> localProperties;

    public PropertyManager(ProjectSpace projectSpace) {
        this.projectSpace = (ProjectSpaceImpl)projectSpace;
        this.localProperties = this.createMap(EMFStorePropertyType.LOCAL);
        this.sharedProperties = this.createMap(EMFStorePropertyType.SHARED);
    }

    public void setLocalProperty(String propertyName, EObject value) {
        EMFStoreProperty prop = this.findProperty(propertyName);
        if (prop == null) {
            prop = this.createProperty(propertyName, value, false);
            prop.setType(EMFStorePropertyType.LOCAL);
            this.projectSpace.getProperties().add((Object)prop);
        } else {
            prop.setValue(value);
        }
        this.localProperties.put(propertyName, prop);
        this.projectSpace.saveProjectSpaceOnly();
    }

    public void setLocalStringProperty(String propertyName, String value) {
        PropertyStringValue propertyValue = ModelFactory.eINSTANCE.createPropertyStringValue();
        propertyValue.setValue(value);
        this.setLocalProperty(propertyName, (EObject)propertyValue);
    }

    public EMFStoreProperty getLocalProperty(String propertyName) {
        return this.localProperties.get(propertyName);
    }

    public String getLocalStringProperty(String propertyName) {
        EMFStoreProperty property = this.localProperties.get(propertyName);
        if (property == null || property.getValue() == null) {
            return null;
        }
        return ((PropertyStringValue)property.getValue()).getValue();
    }

    public void setSharedVersionedProperty(String propertyName, EObject value) {
        this.setSharedProperty(propertyName, value, true);
    }

    public void setSharedStringProperty(String propertyName, String string) {
        PropertyStringValue propertyValue = ModelFactory.eINSTANCE.createPropertyStringValue();
        propertyValue.setValue(string);
        this.setSharedProperty(propertyName, (EObject)propertyValue, false);
    }

    public void setSharedVersionedStringProperty(String propertyName, String string) {
        PropertyStringValue propertyValue = ModelFactory.eINSTANCE.createPropertyStringValue();
        propertyValue.setValue(string);
        this.setSharedProperty(propertyName, (EObject)propertyValue, true);
    }

    private void setSharedProperty(String propertyName, EObject value, boolean isVersioned) {
        EMFStoreProperty prop = this.findProperty(propertyName);
        if (prop == null) {
            prop = this.createProperty(propertyName, value, isVersioned);
            prop.setType(EMFStorePropertyType.SHARED);
            this.projectSpace.getProperties().add((Object)prop);
        } else {
            prop.setValue(value);
        }
        this.projectSpace.getChangedSharedProperties().add((Object)prop);
        this.projectSpace.saveProjectSpaceOnly();
    }

    public void setSharedProperty(String propertyName, EObject value) {
        this.setSharedProperty(propertyName, value, false);
    }

    private void updateProperty(EMFStoreProperty property) {
        EMFStoreProperty prop = this.findProperty(property.getKey());
        if (prop == null) {
            prop = this.createProperty(property.getKey(), property.getValue(), property.getVersion() != 0);
            prop.setType(EMFStorePropertyType.SHARED);
            this.projectSpace.getProperties().add((Object)prop);
        } else {
            prop.setValue(property.getValue());
        }
        prop.setVersion(property.getVersion());
        this.sharedProperties.put(property.getKey(), prop);
        this.projectSpace.saveProjectSpaceOnly();
    }

    public EMFStoreProperty getSharedProperty(String propertyName) {
        return this.sharedProperties.get(propertyName);
    }

    public String getSharedStringProperty(String propertyName) {
        EMFStoreProperty property = this.sharedProperties.get(propertyName);
        if (property == null || property.getValue() == null) {
            return null;
        }
        return ((PropertyStringValue)property.getValue()).getValue();
    }

    public void synchronizeSharedProperties() throws AccessControlException, ESException, EMFStorePropertiesOutdatedException {
        if (this.projectSpace.getUsersession() == null) {
            throw new ESException("Project has not been shared yet.");
        }
        new AccessControlHelper(this.projectSpace.getUsersession()).checkWriteAccess(this.projectSpace.getProjectId());
        ArrayList<EMFStoreProperty> changedProperties = new ArrayList<EMFStoreProperty>((Collection<EMFStoreProperty>)this.projectSpace.getChangedSharedProperties());
        List rejectedProperties = ESWorkspaceProviderImpl.getInstance().getConnectionManager().setEMFProperties(this.projectSpace.getUsersession().getSessionId(), changedProperties, this.projectSpace.getProjectId());
        List<EMFStoreProperty> nonRejectedProperties = this.filterNonRejected(changedProperties, rejectedProperties);
        this.projectSpace.getChangedSharedProperties().removeAll(nonRejectedProperties);
        List sharedProperties = ESWorkspaceProviderImpl.getInstance().getConnectionManager().getEMFProperties(this.projectSpace.getUsersession().getSessionId(), this.projectSpace.getProjectId());
        for (EMFStoreProperty prop : sharedProperties) {
            this.updateProperty(prop);
        }
        if (rejectedProperties.size() > 0) {
            throw new EMFStorePropertiesOutdatedException(rejectedProperties);
        }
    }

    private List<EMFStoreProperty> filterNonRejected(List<EMFStoreProperty> changedProperties, List<EMFStoreProperty> rejectedProperties) {
        ArrayList<EMFStoreProperty> result = new ArrayList<EMFStoreProperty>();
        for (EMFStoreProperty changed : changedProperties) {
            boolean isNotRejected = true;
            for (EMFStoreProperty rejected : rejectedProperties) {
                if (!changed.getKey().equals(rejected.getKey())) continue;
                isNotRejected = false;
                break;
            }
            if (!isNotRejected) continue;
            result.add(changed);
        }
        return result;
    }

    private Map<String, EMFStoreProperty> createMap(EMFStorePropertyType type) {
        LinkedHashMap<String, EMFStoreProperty> map = new LinkedHashMap<String, EMFStoreProperty>();
        EList<EMFStoreProperty> properties = this.projectSpace.getProperties();
        for (EMFStoreProperty prop : properties) {
            if (prop.getType() != type) continue;
            map.put(prop.getKey(), prop);
        }
        return map;
    }

    private EMFStoreProperty createProperty(String key, EObject value, boolean isVersioned) {
        EMFStoreProperty prop = ModelFactory.eINSTANCE.createEMFStoreProperty();
        prop.setKey(key);
        prop.setValue(value);
        if (isVersioned) {
            prop.setVersion(1);
        }
        return prop;
    }

    private EMFStoreProperty findProperty(String propertyName) {
        EMFStoreProperty property = this.localProperties.get(propertyName);
        if (property == null) {
            property = this.sharedProperties.get(propertyName);
        }
        if (property == null) {
            for (EMFStoreProperty p : this.projectSpace.getProperties()) {
                if (!p.getKey().equals(propertyName)) continue;
                property = p;
            }
            if (property != null) {
                if (property.getType() == EMFStorePropertyType.LOCAL) {
                    this.localProperties.put(propertyName, property);
                } else {
                    this.sharedProperties.put(propertyName, property);
                }
            }
        }
        return property;
    }
}

