/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.SettingWithReferencedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovedElementsCache {
    private IdEObjectCollectionImpl collection;
    private List<EObject> removedElements;
    private Map<EObject, ModelElementId> removedElementsIds;
    private Map<EObject, List<SettingWithReferencedElement>> removedElementsToReferenceSettings;

    public RemovedElementsCache(IdEObjectCollectionImpl collection) {
        this.collection = collection;
        this.removedElements = new ArrayList<EObject>();
        this.removedElementsIds = new HashMap<EObject, ModelElementId>();
        this.removedElementsToReferenceSettings = new LinkedHashMap<EObject, List<SettingWithReferencedElement>>();
    }

    public void addRemovedElement(EObject modelElement, Set<EObject> allModelElements, List<SettingWithReferencedElement> crossReferences) {
        this.removedElements.add(modelElement);
        this.removedElementsIds.put(modelElement, this.collection.getDeletedModelElementId(modelElement));
        if (crossReferences.size() != 0) {
            for (EObject eObject : allModelElements) {
                this.removedElementsToReferenceSettings.put(eObject, crossReferences);
            }
        }
    }

    public List<EObject> getRemovedElements() {
        return this.removedElements;
    }

    public ModelElementId getRemovedElementId(EObject modelElement) {
        return this.removedElementsIds.get(modelElement);
    }

    public List<SettingWithReferencedElement> getRemovedElementToReferenceSetting(EObject modelElement) {
        return this.removedElementsToReferenceSettings.get(modelElement);
    }

    public void clear() {
        this.removedElements.clear();
        this.removedElementsIds.clear();
        this.removedElementsToReferenceSettings.clear();
    }
}

