/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AbstractConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.XmlRpcClientManager;
import org.eclipse.emf.emfstore.internal.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcAdminConnectionManager
extends AbstractConnectionManager<XmlRpcClientManager>
implements AdminConnectionManager {
    @Override
    public void initConnection(ServerInfo serverInfo, SessionId id) throws ConnectionException {
        XmlRpcClientManager clientManager = new XmlRpcClientManager("AdminEmfStore");
        clientManager.initConnection(serverInfo);
        this.addConnectionProxy(id, clientManager);
    }

    public void addMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("addMember", sessionId, group, member);
    }

    public void addParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participant) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("addParticipant", sessionId, projectId, participant);
    }

    public void changeOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId, String name, String description) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("changeOrgUnit", sessionId, orgUnitId, name, description);
    }

    public void changeRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnit, EClass role) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("changeRole", sessionId, projectId, orgUnit, role);
    }

    public ACOrgUnitId createGroup(SessionId sessionId, String name) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("createGroup", ACOrgUnitId.class, sessionId, name);
    }

    public ACOrgUnitId createUser(SessionId sessionId, String name) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("createUser", ACOrgUnitId.class, sessionId, name);
    }

    public void deleteGroup(SessionId sessionId, ACOrgUnitId group) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("deleteGroup", sessionId, group);
    }

    public void deleteUser(SessionId sessionId, ACOrgUnitId user) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("deleteUser", sessionId, user);
    }

    public List<ACGroup> getGroups(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getGroups", ACGroup.class, sessionId);
    }

    public List<ACGroup> getGroups(SessionId sessionId, ACOrgUnitId user) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getGroups", ACGroup.class, sessionId, user);
    }

    public List<ACOrgUnit> getMembers(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getMembers", ACOrgUnit.class, sessionId, groupId);
    }

    public ACOrgUnit getOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("getOrgUnit", ACOrgUnit.class, sessionId, orgUnitId);
    }

    public List<ACOrgUnit> getOrgUnits(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getOrgUnits", ACOrgUnit.class, sessionId);
    }

    public List<ACOrgUnit> getParticipants(SessionId sessionId, ProjectId projectId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getParticipants", ACOrgUnit.class, sessionId, projectId);
    }

    public List<ProjectInfo> getProjectInfos(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getProjectInfos", ProjectInfo.class, sessionId);
    }

    public Role getRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnit) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("getRole", Role.class, sessionId, projectId, orgUnit);
    }

    public List<ACUser> getUsers(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getUsers", ACUser.class, sessionId);
    }

    public void removeGroup(SessionId sessionId, ACOrgUnitId user, ACOrgUnitId group) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("removeGroup", sessionId, user, group);
    }

    public void removeMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("removeMember", sessionId, group, member);
    }

    public void removeParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participant) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("removeParticipant", sessionId, projectId, participant);
    }
}

