/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.alg.force.IGraphImporter;
import org.eclipse.elk.alg.force.graph.FEdge;
import org.eclipse.elk.alg.force.graph.FGraph;
import org.eclipse.elk.alg.force.graph.FLabel;
import org.eclipse.elk.alg.force.graph.FNode;
import org.eclipse.elk.alg.force.options.ForceOptions;
import org.eclipse.elk.alg.force.options.InternalProperties;
import org.eclipse.elk.core.UnsupportedGraphException;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class ElkGraphImporter
implements IGraphImporter<ElkNode> {
    @Override
    public FGraph importGraph(ElkNode kgraph) {
        FGraph fgraph = new FGraph();
        fgraph.copyProperties((IPropertyHolder)kgraph);
        fgraph.setProperty(InternalProperties.ORIGIN, kgraph);
        HashMap<ElkNode, FNode> elemMap = new HashMap<ElkNode, FNode>();
        this.transformNodes(kgraph, fgraph, elemMap);
        this.transformEdges(kgraph, fgraph, elemMap);
        return fgraph;
    }

    private void transformNodes(ElkNode parentNode, FGraph fgraph, Map<ElkNode, FNode> elemMap) {
        int index = 0;
        for (ElkNode knode : parentNode.getChildren()) {
            String label = "";
            if (!knode.getLabels().isEmpty()) {
                label = ((ElkLabel)knode.getLabels().get(0)).getText();
            }
            FNode newNode = new FNode(label);
            newNode.copyProperties((IPropertyHolder)knode);
            newNode.setProperty(InternalProperties.ORIGIN, knode);
            newNode.id = index++;
            newNode.getPosition().x = knode.getX() + knode.getWidth() / 2.0;
            newNode.getPosition().y = knode.getY() + knode.getHeight() / 2.0;
            newNode.getSize().x = Math.max(knode.getWidth(), 1.0);
            newNode.getSize().y = Math.max(knode.getHeight(), 1.0);
            fgraph.getNodes().add(newNode);
            elemMap.put(knode, newNode);
            PortConstraints portConstraints = (PortConstraints)knode.getProperty(ForceOptions.PORT_CONSTRAINTS);
            if (portConstraints != PortConstraints.UNDEFINED) continue;
            portConstraints = PortConstraints.FREE;
        }
    }

    private void transformEdges(ElkNode parentNode, FGraph fgraph, Map<ElkNode, FNode> elemMap) {
        for (ElkNode knode : parentNode.getChildren()) {
            for (ElkEdge kedge : ElkGraphUtil.allOutgoingEdges((ElkNode)knode)) {
                if (kedge.isHyperedge()) {
                    throw new UnsupportedGraphException("Graph must not contain hyperedges.");
                }
                if (kedge.isHierarchical() || knode == ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)kedge.getTargets().get(0)))) continue;
                FEdge newEdge = new FEdge();
                newEdge.copyProperties((IPropertyHolder)kedge);
                newEdge.setProperty(InternalProperties.ORIGIN, kedge);
                newEdge.setSource(elemMap.get(knode));
                newEdge.setTarget(elemMap.get(ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)kedge.getTargets().get(0)))));
                fgraph.getEdges().add(newEdge);
                for (ElkLabel klabel : kedge.getLabels()) {
                    FLabel newLabel = new FLabel(newEdge, klabel.getText());
                    newLabel.setProperty(InternalProperties.ORIGIN, klabel);
                    newLabel.getSize().x = Math.max(klabel.getWidth(), 1.0);
                    newLabel.getSize().y = Math.max(klabel.getHeight(), 1.0);
                    newLabel.refreshPosition();
                    fgraph.getLabels().add(newLabel);
                }
            }
        }
    }

    @Override
    public void applyLayout(FGraph fgraph) {
        ElkNode kgraph = (ElkNode)fgraph.getProperty(InternalProperties.ORIGIN);
        double minXPos = 2.147483647E9;
        double minYPos = 2.147483647E9;
        double maxXPos = -2.147483648E9;
        double maxYPos = -2.147483648E9;
        for (FNode node : fgraph.getNodes()) {
            KVector pos = node.getPosition();
            KVector size = node.getSize();
            minXPos = Math.min(minXPos, pos.x - size.x / 2.0);
            minYPos = Math.min(minYPos, pos.y - size.y / 2.0);
            maxXPos = Math.max(maxXPos, pos.x + size.x / 2.0);
            maxYPos = Math.max(maxYPos, pos.y + size.y / 2.0);
        }
        ElkPadding padding = (ElkPadding)kgraph.getProperty(ForceOptions.PADDING);
        KVector offset = new KVector(padding.getLeft() - minXPos, padding.getTop() - minYPos);
        for (FNode fnode : fgraph.getNodes()) {
            Object object = fnode.getProperty(InternalProperties.ORIGIN);
            if (!(object instanceof ElkNode)) continue;
            ElkNode knode = (ElkNode)object;
            KVector nodePos = fnode.getPosition().add(offset);
            knode.setLocation(nodePos.x - knode.getWidth() / 2.0, nodePos.y - knode.getHeight() / 2.0);
        }
        for (FEdge fedge : fgraph.getEdges()) {
            ElkEdge kedge = (ElkEdge)fedge.getProperty(InternalProperties.ORIGIN);
            ElkEdgeSection kedgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)kedge, (boolean)true, (boolean)true);
            KVector startLocation = fedge.getSourcePoint();
            kedgeSection.setStartLocation(startLocation.x, startLocation.y);
            KVector endLocation = fedge.getTargetPoint();
            kedgeSection.setEndLocation(endLocation.x, endLocation.y);
        }
        for (FLabel flabel : fgraph.getLabels()) {
            ElkLabel klabel = (ElkLabel)flabel.getProperty(InternalProperties.ORIGIN);
            KVector labelPos = flabel.getPosition().add(offset);
            klabel.setLocation(labelPos.x, labelPos.y);
        }
        double width = maxXPos - minXPos + padding.getHorizontal();
        double height = maxYPos - minYPos + padding.getVertical();
        ElkUtil.resizeNode((ElkNode)kgraph, (double)width, (double)height, (boolean)false, (boolean)true);
    }
}

