/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphSwitch;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public final class GraphIdentifierGenerator {
    private int[] currentIDs = new int[ElementType.values().length];
    private Set<String> existingIdentifiers = new HashSet<String>();

    private GraphIdentifierGenerator(ElkNode graph) {
        TreeIterator iterator = graph.eAllContents();
        while (iterator.hasNext()) {
            ElkEdgeSection section;
            EObject currentEObject = (EObject)iterator.next();
            if (currentEObject instanceof ElkGraphElement) {
                ElkGraphElement element = (ElkGraphElement)currentEObject;
                if (element.getIdentifier() == null || element.getIdentifier().trim().isEmpty()) continue;
                this.existingIdentifiers.add(element.getIdentifier());
                continue;
            }
            if (!(currentEObject instanceof ElkEdgeSection) || (section = (ElkEdgeSection)currentEObject).getIdentifier() == null || section.getIdentifier().trim().isEmpty()) continue;
            this.existingIdentifiers.add(section.getIdentifier());
        }
    }

    public static void generate(ElkNode graph) {
        new GraphIdentifierGenerator(graph).generateIdentifiers(graph);
    }

    private void generateIdentifiers(ElkGraphElement element) {
        new ElkGraphSwitch<Object>(){

            @Override
            public Object caseElkNode(ElkNode node) {
                if (node.getParent() == null) {
                    if (node.getIdentifier() == null || node.getIdentifier().trim().isEmpty()) {
                        node.setIdentifier("G1");
                    }
                } else {
                    GraphIdentifierGenerator.this.setIdentifierIfMissing(node, ElementType.NODE);
                }
                node.getLabels().stream().forEach(l -> GraphIdentifierGenerator.this.generateIdentifiers(l));
                node.getPorts().stream().forEach(l -> GraphIdentifierGenerator.this.generateIdentifiers(l));
                node.getContainedEdges().stream().forEach(l -> GraphIdentifierGenerator.this.generateIdentifiers(l));
                return null;
            }

            @Override
            public Object caseElkPort(ElkPort port) {
                GraphIdentifierGenerator.this.setIdentifierIfMissing(port, ElementType.PORT);
                port.getLabels().stream().forEach(l -> GraphIdentifierGenerator.this.generateIdentifiers(l));
                return null;
            }

            @Override
            public Object caseElkLabel(ElkLabel label) {
                GraphIdentifierGenerator.this.setIdentifierIfMissing(label, ElementType.LABEL);
                label.getLabels().stream().forEach(l -> GraphIdentifierGenerator.this.generateIdentifiers(l));
                return null;
            }

            @Override
            public Object caseElkEdge(ElkEdge edge) {
                GraphIdentifierGenerator.this.setIdentifierIfMissing(edge, ElementType.EDGE);
                edge.getLabels().stream().forEach(l -> GraphIdentifierGenerator.this.generateIdentifiers(l));
                return null;
            }

            @Override
            public Object caseElkEdgeSection(ElkEdgeSection section) {
                GraphIdentifierGenerator.this.setIdentifierIfMissing(section);
                return null;
            }
        }.doSwitch(element);
    }

    private void setIdentifierIfMissing(ElkGraphElement element, ElementType elementType) {
        if (element.getIdentifier() == null || element.getIdentifier().trim().isEmpty()) {
            String id = this.nextIdentifier(elementType);
            element.setIdentifier(id);
        }
    }

    private void setIdentifierIfMissing(ElkEdgeSection section) {
        if (section.getIdentifier() == null || section.getIdentifier().trim().isEmpty()) {
            String id = this.nextIdentifier(ElementType.EDGE_SECTION);
            section.setIdentifier(id);
        }
    }

    private String nextIdentifier(ElementType elementType) {
        int n;
        String identifier;
        do {
            n = elementType.ordinal();
        } while (this.existingIdentifiers.contains(identifier = String.valueOf(elementType.elementPrefix) + (this.currentIDs[n] = this.currentIDs[n] + 1)));
        return identifier;
    }

    private static enum ElementType {
        NODE("N"),
        PORT("P"),
        EDGE("E"),
        EDGE_SECTION("ES"),
        LABEL("L");

        private String elementPrefix;

        private ElementType(String prefix) {
            this.elementPrefix = prefix;
        }
    }
}

